/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcComponentInfo;
import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfoMap;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CQTask;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTBranch;
import com.ibm.rational.wvcm.ct.CTBranchBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTFolderVersion;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTSymbolicLink;
import com.ibm.rational.wvcm.ct.CTSymbolicLinkVersion;
import com.ibm.rational.wvcm.ct.CTTask;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class CTProvider
extends SrvcProvider {
    public static final String EMPTY_STRING = new String();
    public static final String TRUE = Boolean.toString(true);
    public static final String FALSE = Boolean.toString(false);
    public static final PropertyNameList.PropertyName<String> FULLY_QUALIFIED_DISPLAY_NAME = new PropertyNameList.PropertyName("com.ibm.rational.wvcm", "fully-qualified-display-name");
    public static final PropertyNameList.PropertyName<String> STREAM_TREE_NODE_NAME = new PropertyNameList.PropertyName("com.ibm.rational.wvcm", "stream-tree-node-name");
    public static final String BASECC_CHAR = String.valueOf('|');
    public static final String AT_SIGN = "@";
    private static final String UNRECOGNIZED_OPTION = "Unrecognized option";
    private static final String INIT_COMPLETE = "CTProvider initialization complete";
    private static final int DEFAULT_PROVIDER_CACHE_MAX_SIZE = 10000;
    private static final String DEFAULT_CQ_DBSET_NAME = "sample_schema_repo";
    private static final String DEFAULT_CQ_USERDB_NAME = "SAMPL";
    private static final String DEFAULT_CQ_LOGIN_NAME = "admin";
    public static final int DEFAULT_MAX_CT_CMD_LEN = 16384;
    private static final int DEFAULT_FEEDBACK_CMD_MIN_DURATION_MILLISECONDS = 60000;
    public static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = FALSE;
    public static final PropertyNameList.PropertyName<Integer> PN_MAXIMUM_MEMBER_COUNT = new PropertyNameList.PropertyName("com.ibm.team.interop", "MAXIMUM_MEMBER_COUNT");
    public static final PropertyNameList.PropertyName<String> PN_BRTYPE_DISPLAYNAME = new PropertyNameList.PropertyName("com.ibm.team.interop", "BranchType.DisplayName");
    public static final PropertyNameList.PropertyName<String> PN_ACTIVITY_NAME = new PropertyNameList.PropertyName("com.ibm.team.interop", "Activity.Name");
    private static boolean HAS_VALID_CC = false;
    private boolean isViewActivated = false;
    Log _log = null;
    private CCaseLib _cc;
    static boolean IS_CACHING_ENABLED = true;
    private Map<String, CTResource> persistentObjectCache = null;
    private static final Set<CTLocation.Kind> _uncachedKinds = Collections.singleton(CTLocation.Kind.VOBCOMPONENT);
    private final Map<String, BaseCcSubVobCompRootInfoMap> CachedMapsByViewVobPath = new HashMap<String, BaseCcSubVobCompRootInfoMap>();
    private final Set<String> notifications = new HashSet<String>();

    public CTProvider() {
        super(null);
    }

    public void initialize(Map<String, String> argsArg, ProviderFactory.Callback callback) throws WvcmException {
        CTLocation streamLoc;
        String streamPath;
        String viewStgPath;
        HashMap args = argsArg == null ? new HashMap() : argsArg;
        super.setDisplayName("ClearCase");
        super.initialize(args, callback);
        if (this.lookupCompVobTagValue() == null) {
            CTInitArgUtils.setCompVobTag(this._initArgs, EMPTY_STRING);
        }
        if (this.lookupCompVobTagPrefixValue() == null) {
            CTInitArgUtils.setCompVobTagPrefix(this._initArgs, EMPTY_STRING);
        }
        if (CTInitArgUtils.getProviderCacheMaxSize(this._initArgs) == 0) {
            CTInitArgUtils.setProviderCacheMaxSize(this._initArgs, 10000);
        }
        if (CTInitArgUtils.getMaxCmdLen(this._initArgs) == 0) {
            CTInitArgUtils.setMaxCmdLen(this._initArgs, 16384);
        }
        CTLocation viewLoc = null;
        if (this._initArgs.containsKey("com.ibm.rational.wvcm.WORKSPACE_LOCATION")) {
            String viewLocString = (String)this._initArgs.get("com.ibm.rational.wvcm.WORKSPACE_LOCATION");
            viewLoc = this.location(viewLocString);
            String viewTag = viewLoc.getViewTag();
            CTInitArgUtils.setViewTag(this._initArgs, viewTag);
        }
        if (CTInitArgUtils.getCQDbsetName(this._initArgs) == null) {
            CTInitArgUtils.setCQDbsetName(this._initArgs, DEFAULT_CQ_DBSET_NAME);
        }
        if (CTInitArgUtils.getCQUserdbName(this._initArgs) == null) {
            CTInitArgUtils.setCQUserdbName(this._initArgs, DEFAULT_CQ_USERDB_NAME);
        }
        if (CTInitArgUtils.getCQLoginName(this._initArgs) == null) {
            CTInitArgUtils.setCQLoginName(this._initArgs, DEFAULT_CQ_LOGIN_NAME);
        }
        if (CTInitArgUtils.getCQUCMRecordAction(this._initArgs) == null) {
            CTInitArgUtils.setCQUCMRecordAction(this._initArgs, "");
        }
        if (CTInitArgUtils.getSyncCCVersionComments(this._initArgs) == null) {
            CTInitArgUtils.setSyncCCVersionComments(this._initArgs, "false");
        }
        CTInitArgUtils.setTraceTriggers(this._initArgs, CTInitArgUtils.traceTriggers(this._initArgs));
        String locale = Locale.getDefault().toString();
        String storedLocale = CTInitArgUtils.getLocale(this._initArgs);
        if (storedLocale == null) {
            CTInitArgUtils.setLocale(this._initArgs, locale);
        } else if (!locale.equals(storedLocale)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_WARN_LOCALE_MISMATCH, (Object)locale, (Object)storedLocale));
        }
        String charset = Charset.defaultCharset().name();
        String storedCharset = (String)this._initArgs.get("com.ibm.team.connector.scm.CHARACTER_SET");
        if (storedCharset == null) {
            this._initArgs.put("com.ibm.team.connector.scm.CHARACTER_SET", charset);
        } else if (!charset.equals(storedCharset)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_WARN_CHARSET_MISMATCH, (Object)charset, (Object)storedCharset));
        }
        if (this._initArgs.get("com.ibm.team.connector.scm.LINE_DELIMITER") == null) {
            this._initArgs.put("com.ibm.team.connector.scm.LINE_DELIMITER", InteropUtilities.LineSeparator.LF.name());
        }
        if (this._initArgs.get("com.ibm.team.connector.scm.LINE_DELIMITER_WORKSPACE") == null) {
            this._initArgs.put("com.ibm.team.connector.scm.LINE_DELIMITER_WORKSPACE", InteropUtilities.LineSeparator.PLATFORM.name());
        }
        if ((viewStgPath = CTInitArgUtils.getStgLoc(this._initArgs)) == null) {
            viewStgPath = new String();
        }
        CTInitArgUtils.setDumpEnv(this._initArgs, CTInitArgUtils.getDumpEnv(this._initArgs));
        if (CTInitArgUtils.getCheckinComment(this._initArgs) == null) {
            CTInitArgUtils.setCheckinComment(this._initArgs, "");
        }
        CTInitArgUtils.setUseTripleSet(this._initArgs, CTInitArgUtils.useTripleSet(this._initArgs));
        if (CTInitArgUtils.getHost(this._initArgs) == null) {
            CTInitArgUtils.setHost(this._initArgs, CTProvider.getLocalHostname());
        }
        if (CTInitArgUtils.getHpath(this._initArgs) == null) {
            CTInitArgUtils.setHpath(this._initArgs, viewStgPath);
        }
        if (CTInitArgUtils.getGpath(this._initArgs) == null) {
            CTInitArgUtils.setGpath(this._initArgs, viewStgPath);
        }
        if (!this._initArgs.containsKey("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION")) {
            this._initArgs.put("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION", String.valueOf(300000));
        }
        if (!this._initArgs.containsKey("com.ibm.team.interop.IGNORE_TASK_CREATION_FAILURE")) {
            this._initArgs.put("com.ibm.team.interop.IGNORE_TASK_CREATION_FAILURE", DEFAULT_IGNORE_TASK_CREATION_FAILURE);
        }
        if (CTInitArgUtils.getFeedbackCmdMinDurationValue(this._initArgs) == null) {
            CTInitArgUtils.setFeedbackCmdMinDurationValue(this._initArgs, 60000);
        }
        int feedbackDelayMilliseconds = Integer.valueOf(CTInitArgUtils.getFeedbackCmdMinDurationValue(this._initArgs));
        CommandProvider p = new CommandProvider(feedbackDelayMilliseconds, this._initArgs);
        CTFeedback feedback = new CTFeedback(null);
        if (!HAS_VALID_CC) {
            CommandResult r = p.executeGetResult((SrvcFeedback)feedback, "pwv", "-mvfsroot");
            if (r.getStat() == 1 && r.getStdErr().contains(UNRECOGNIZED_OPTION)) {
                throw new WvcmException(Messages.CTProvider_UNSUPPORTED_CC_VER_ERROR, WvcmException.ReasonCode.FORBIDDEN);
            }
            HAS_VALID_CC = true;
        }
        this._cc = new CCaseLib(p, this._initArgs, this.isCachingEnabled());
        CTInitArgUtils.setCcVersionString(this._initArgs, this._cc.getClearCaseVersion(feedback));
        this.isViewActivated = false;
        String pvobTag = CTInitArgUtils.getPvobTag(this._initArgs);
        if (!(CTInitArgUtils.getPvobTag(this._initArgs) != null && pvobTag.length() != 0 || viewLoc != null && viewLoc.getKind().equals((Object)CTLocation.Kind.BASE_CC_VIEW) || (streamPath = (String)this._initArgs.get("com.ibm.team.interop.OTHER_STREAM_LOCATION")) == null || streamPath.length() == 0 || !(streamLoc = this.location(streamPath)).getKind().equals((Object)CTLocation.Kind.STREAM))) {
            pvobTag = ObjSelUtils.getObjSelVobSel(streamLoc.getDisplayName());
            CTInitArgUtils.setPvobTag(this._initArgs, pvobTag);
        }
        if (pvobTag == null) {
            CTInitArgUtils.setPvobTag(this._initArgs, EMPTY_STRING);
        }
        this.logDebug(INIT_COMPLETE);
    }

    protected void activateView() throws WvcmException {
        if (this.isViewActivated) {
            return;
        }
        String viewTag = this.getTagForDefaultView();
        if (viewTag != null && !this._cc.isViewValid(viewTag, null)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_VIEW_ERROR, (Object)viewTag));
        }
        this.isViewActivated = true;
    }

    public String getTagForDefaultView() {
        return CTInitArgUtils.getViewTag(this._initArgs);
    }

    public static String getLocalHostname() throws WvcmException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new WvcmException(Messages.CTProvider_COULD_NOT_GET_LOCAL_HOSTNAME, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static void printWarning(String message) {
        System.err.println(message);
    }

    private synchronized Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        }
        return this._log;
    }

    public CTFeedback srvcFeedback(Feedback feedback) {
        return new CTFeedback(feedback);
    }

    public void logCreation(String objectName, CTLocation objectLocation) {
        this.logDebug("create `" + objectName + "' with location: " + objectLocation.string());
    }

    public void logInfo(String msg) {
        this.getLog().info((Object)msg);
    }

    public void logDebug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public CCaseLib getCCaseLib() {
        return this._cc;
    }

    public CTLocation location(String string) throws WvcmException {
        return CTLocation.valueOf(string);
    }

    public CTResource lookup(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        if (genericLocation == null) {
            return null;
        }
        CTLocation loc = (CTLocation)genericLocation;
        CTLocation.Kind locKind = loc.getKind();
        CTResource result = null;
        if (this.isCachingEnabled()) {
            if (feedback != null && (result = ((CTFeedback)feedback).lookupCTResourceCache((Location)loc)) != null) {
                this.logDebug("Cache hit on kind: " + (Object)((Object)locKind));
                return result;
            }
            result = this.lookupLocationInPersistentProxyCache(loc);
            if (result != null) {
                if (feedback != null) {
                    ((CTFeedback)feedback).setCTResourceCache((Location)loc, result);
                }
                return result;
            }
        }
        CCaseObjInfo info = null;
        String locationPathname = loc.getDisplayName();
        try {
            if (locKind != null) {
                switch (locKind) {
                    case WORKSPACE: {
                        result = new CTUcmView((Location)loc, this);
                        break;
                    }
                    case CONFIGURATION: 
                    case WORKSPACE_CONFIGURATION: {
                        result = new CTWvcmConfiguration((Location)loc, this);
                        break;
                    }
                    case FOLDER: {
                        result = new CTFolder((Location)loc, this);
                        break;
                    }
                    case BRANCH: {
                        result = new CTBranch((Location)loc, this);
                        break;
                    }
                    case BASE_CC_VIEW: {
                        result = new CTBaseCCView((Location)loc, this);
                        break;
                    }
                    case BASE_CC_BASELINE: {
                        result = new CTBranchBaseline((Location)loc, this);
                        break;
                    }
                    case VOBCOMPONENT: {
                        result = CTVOB.lookup(loc, this);
                        break;
                    }
                    case VERSION_IN_SVC: {
                        result = CTVersion.lookupInSVC(loc, this, feedback);
                        break;
                    }
                    case ELEMENT_IN_SVC: {
                        result = CTElement.lookupInSVC(loc, this, feedback);
                    }
                }
                if (result != null) {
                    ((CTFeedback)feedback).setCTResourceCache((Location)loc, result);
                    return result;
                }
            }
            if (CTLocation.Kind.VERSION.equals((Object)locKind)) {
                info = CCaseVerInfo.lookupVerInfo(this._cc, locationPathname, feedback);
            }
            if (info == null) {
                info = CCaseObjInfo.lookupObjInfo(this._cc, locationPathname, feedback);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            this.getCCaseLib().logIgnoredExceptionAsNotAlwaysVisible("CTProvider.lookup", Messages.CCaseLib_IGNORED_EXCEPTION_LOCATION_LOOKUP, (Exception)((Object)e));
            return null;
        }
        return this.createAndCacheCTResource(loc, info, feedback);
    }

    public CTResource createAndCacheCTResource(CTLocation loc, CCaseObjInfo info, SrvcFeedback feedback) throws WvcmException {
        if (info == null) {
            return null;
        }
        CTResource result = this.createProxyForLocation(loc, info.getMtype());
        if (result == null) {
            return null;
        }
        result.setObjInfo(info);
        if (feedback != null) {
            ((CTFeedback)feedback).setCTResourceCache((Location)loc, result);
        }
        this.persistProxyIfImmutable(result, feedback);
        return result;
    }

    private CTResource createProxyForLocation(CTLocation loc, String mtype) throws WvcmException {
        CTResource result = null;
        if (mtype.equals("activity")) {
            result = loc.hasKind(CTLocation.Kind.TASK) ? new CTTask((Location)loc, this) : (loc.hasKind(CTLocation.Kind.CQTASK) ? new CQTask((Location)loc, this) : new CTActivity((Location)loc, this));
        } else if (mtype.equals("baseline")) {
            result = new CTBaseline((Location)loc, this);
        } else if (mtype.equals("component")) {
            result = new CTComponent((Location)loc, this);
        } else if (mtype.equals("directory version")) {
            result = loc.hasKind(CTLocation.Kind.VERSION_IN_SVC) || this.isVersionSelector(loc) ? new CTFolderVersion((Location)loc, this) : new CTControllableFolder((Location)loc, this);
        } else if (loc.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE)) {
            String pathName;
            File folder;
            result = mtype.equals("directory element") ? new CTControllableFolder((Location)loc, this) : (mtype.equals("symbolic link") ? new CTSymbolicLink((Location)loc, this) : (mtype.equals("**null meta type**") ? ((folder = new File(pathName = (pathName = loc.getDisplayName()).startsWith("vob:") ? pathName.substring("vob:".length()) : pathName)).isDirectory() ? new CTControllableFolder((Location)loc, this) : new CTControllableResource((Location)loc, this)) : new CTControllableResource((Location)loc, this)));
        } else if (mtype.equals("stream")) {
            result = new CTStream((Location)loc, this);
        } else if (mtype.equals("version") || mtype.equals("derived object version")) {
            result = loc.hasKind(CTLocation.Kind.VOBCOMPONENT) ? new CTVOB((Location)loc, this) : (loc.hasKind(CTLocation.Kind.VERSION_IN_SVC) || this.isVersionSelector(loc) ? new CTVersion((Location)loc, this) : new CTControllableResource((Location)loc, this));
        } else if (mtype.endsWith("element")) {
            result = new CTElement((Location)loc, this);
        } else if (mtype.equals("symbolic link")) {
            result = loc.lookupContextLocation(CTLocation.Kind.SYMBOLIC_LINK_VERSION) != null ? new CTSymbolicLinkVersion((Location)loc, this) : new CTElement((Location)loc, this);
        }
        if (mtype.equals("versioned object base")) {
            result = new CTVOB((Location)loc, this);
        }
        return result;
    }

    private boolean isVersionSelector(CTLocation loc) {
        String displayName = loc.getDisplayName();
        return displayName != null && (ObjSelUtils.isUniversalSelector(displayName) || !loc.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE) && displayName.contains("@@"));
    }

    public CTResource get(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        CTResource result = this.lookup(genericLocation, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_RESOURCE_NOT_FOUND_BY_LOCATION, (Object)genericLocation), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public CTLocation rootLocation() {
        return CTLocation._rootLoc;
    }

    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTResource srvcResource = this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = this.doCreateControllableResource(location, updates, updated, feedback.nest(50));
            updates.clear();
        }
        ((CTControllableResource)srvcResource).doWriteContent(content, contentIdentifier, updates, updated, feedback);
        return srvcResource;
    }

    public SrvcResource doCreateGeneratedActivity(Location locationHint, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        if (isStream) {
            return CTStream.doCreateGeneratedResource(this, (CTLocation)locationHint, updates, updated, feedback);
        }
        return CTActivity.doCreateGeneratedActivity(false, this, (CTLocation)locationHint, updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return CTTask.doCreateGeneratedActivity(true, this, (CTLocation)location, updates, updated, feedback);
    }

    public SrvcResource doCreateControllableFolder(Location location, SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder result = CTControllableFolder.doCreate(this, location, feedback);
        return result;
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTSymbolicLink result = CTSymbolicLink.doCreateSymbolicLink(this, location, updates, updated, feedback);
        return result;
    }

    public CTControllableResource doCreateControllableResource(Location location, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableResource.doCreate(this, location, feedback);
        return result;
    }

    public SrvcResource doFindOne(Resource query, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = query instanceof Version ? this.doFindVersionInWorkspace((Version)query, true, feedback) : super.doFindOne(query, feedback);
        return result;
    }

    public SrvcResource doFind(Resource query, SrvcFeedback feedback) throws WvcmException {
        if (query instanceof Component) {
            return this.doFindComponent((Component)query, feedback);
        }
        if (query instanceof Version) {
            return this.doFindVersionInWorkspace((Version)query, false, feedback);
        }
        if (query instanceof Stream) {
            List<SrvcResource> streams = this.doFindStreams((Stream)query, false, feedback);
            if (streams.isEmpty()) {
                return null;
            }
            return streams.get(0);
        }
        if (query instanceof Configuration) {
            return this.doFindConfigurationInView((Configuration)query, feedback);
        }
        if (query instanceof ControllableResource) {
            return this.doFindCRInView((ControllableResource)query, feedback);
        }
        List<SrvcResource> resources = this.doFindResources(query, false, feedback);
        if (resources.isEmpty()) {
            return null;
        }
        return resources.get(0);
    }

    private SrvcResource doFindComponent(Component query, SrvcFeedback feedback) throws WvcmException {
        Object compNameVal = query.lookupProperty(Component.DISPLAY_NAME);
        if (!(compNameVal instanceof String)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        String compName = (String)compNameVal;
        String compVobTagValue = this.lookupCompVobTagValue();
        if (this.isBaseCcSyncStream() && compVobTagValue != null && compVobTagValue.length() > 0) {
            return this.doFindSubVobComponent(compName, feedback);
        }
        return this.doFindUCMComponent(compName, feedback);
    }

    private SrvcResource doFindSubVobComponent(String compName, SrvcFeedback feedback) throws WvcmException {
        String compVobTag;
        CTResource result = null;
        CTBaseCCView view = this.getDefaultBaseCcView(feedback);
        String viewTag = view.getViewTag();
        BaseCcSubVobCompRootInfoMap map = CTResource.getSubVobPathMap(this, viewTag, compVobTag = this.getDefaultCompVobTag(feedback), feedback);
        String compPath = map.lookupSubVobCompPath(compName, feedback);
        if (compPath != null) {
            CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, compPath);
            result = this.lookup((Location)compLoc, feedback);
        }
        return result;
    }

    private CTBaseCCView getDefaultBaseCcView(SrvcFeedback feedback) throws WvcmException {
        String viewLocString;
        CTLocation viewLoc;
        CTResource view;
        CTBaseCCView result = null;
        String path = (String)this._initArgs.get("com.ibm.rational.wvcm.WORKSPACE_LOCATION");
        if (path != null && !path.isEmpty() && (view = this.lookup((Location)(viewLoc = this.location(viewLocString = (String)this._initArgs.get("com.ibm.rational.wvcm.WORKSPACE_LOCATION"))), feedback)) instanceof CTBaseCCView) {
            result = (CTBaseCCView)view;
        }
        if (result == null) {
            String msg = NLS.bind((String)"could not get default base ClearCase view because {0} is not set to the location string of a base CC workspace", (Object)"com.ibm.rational.wvcm.WORKSPACE_LOCATION");
            throw new IllegalStateException(msg);
        }
        return result;
    }

    private boolean isBaseCcSyncStream() {
        String pVobTag = this.getDefaultPvobTag();
        return pVobTag == null;
    }

    public List<SrvcResource> doFindAll(Resource query, SrvcFeedback feedback) throws WvcmException {
        if (query instanceof Component) {
            return this.singletonListNonNull(this.doFindComponent((Component)query, feedback));
        }
        if (query instanceof Baseline) {
            return this.doFindBaselines((Baseline)query, feedback);
        }
        if (query instanceof Version) {
            return this.singletonListNonNull(this.doFindVersionInWorkspace((Version)query, false, feedback));
        }
        if (query instanceof Stream) {
            return this.doFindStreams((Stream)query, true, feedback);
        }
        if (query instanceof Configuration) {
            return this.singletonListNonNull(this.doFindConfigurationInView((Configuration)query, feedback));
        }
        if (query instanceof ControllableResource) {
            Object value;
            if (query instanceof ControllableFolder && (value = query.lookupProperty(PN_MAXIMUM_MEMBER_COUNT)) instanceof Integer) {
                int threshold = (Integer)value;
                CTControllableFolder queryFolder = (CTControllableFolder)this.get(query.location(), feedback.nest(10));
                return queryFolder.doFindRoots(threshold, feedback.nest(90));
            }
            return this.singletonListNonNull(this.doFindCRInView((ControllableResource)query, feedback));
        }
        return this.doFindResources(query, true, feedback);
    }

    private List<SrvcResource> singletonListNonNull(SrvcResource object) {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>();
        if (object != null) {
            results.add(object);
        }
        return results;
    }

    private CTVersion doFindVersionInWorkspace(Version query, boolean expectVersionFound, SrvcFeedback feedback) throws WvcmException {
        ResourceList queryWorkspaceList = query.getInWorkspaceList();
        Workspace workspaceQuery = (Workspace)queryWorkspaceList.get(0);
        CTLocation viewLoc = (CTLocation)workspaceQuery.getPathnameLocation();
        CTView view = new CTView((Location)viewLoc, this);
        VersionHistory vh = query.getVersionHistory();
        CTLocation elemLoc = (CTLocation)vh.getPathnameLocation();
        String elemUsel = elemLoc.getDisplayName();
        CTElement element = (CTElement)this.lookup((Location)elemLoc, feedback);
        CTVersion result = null;
        String msg = null;
        if (element == null) {
            if (expectVersionFound) {
                msg = NLS.bind((String)Messages.CTProvider_ERROR_ELEMENT_NOT_FOUND_IN_VIEW, (Object)elemUsel);
            }
        } else {
            CTLocation myCRLoc = element.lookupMyControllableResourceLoc(view, feedback);
            CTControllableResource myCR = (CTControllableResource)this.lookup((Location)myCRLoc, feedback);
            CTLocation verLoc = null;
            if (myCR != null) {
                CTVersion version = (CTVersion)myCR.lookupCurrentVersion(feedback);
                if (version != null) {
                    verLoc = version.location();
                    version.setElemUSel(element.getUniversalSelector(feedback));
                }
            } else if (element.getObjInfo(feedback).getMtype().equals("symbolic link")) {
                verLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, element.location().getDisplayName());
            } else if (expectVersionFound) {
                CCaseLib cc = this.getCCaseLib();
                String rawGpath = cc.gpathDontCanonicalize(elemUsel, view.getViewTag(), feedback);
                msg = !CommandProvider.IS_WINDOWS && rawGpath != null && rawGpath.contains(CommonUtils.BACKSLASH) ? NLS.bind((String)Messages.CTProvider_ERROR_VERSION_HAS_BACKSLASH_IN_ITS_PATHNAME, (Object)rawGpath) : (rawGpath != null ? NLS.bind((String)"Error with {0}", (Object)rawGpath) : NLS.bind((String)Messages.CTProvider_ERROR_ELEMENT_NOT_FOUND_IN_VIEW, (Object)elemUsel));
            }
            if (verLoc != null) {
                result = (CTVersion)this.lookup((Location)verLoc, feedback);
            }
        }
        if (result == null && msg != null) {
            throw new WvcmException(msg, (Resource)vh, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    private List<SrvcResource> doFindResources(Resource query, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        Object streamTreeNodeNameVal = query.lookupProperty(STREAM_TREE_NODE_NAME);
        if (!(streamTreeNodeNameVal instanceof String)) {
            throw new IllegalArgumentException(STREAM_TREE_NODE_NAME + " specified in query is not a string");
        }
        String streamTreeNodeName = (String)streamTreeNodeNameVal;
        if (streamTreeNodeName.length() == 0) {
            List<String> pvobNames = this._cc.getPvobSelectors(all, feedback);
            for (String pvobName : pvobNames) {
                CTLocation folderLoc = CTLocation.valueOf(CTLocation.Kind.FOLDER, pvobName);
                CTFolder fldr = (CTFolder)this.lookup((Location)folderLoc, feedback);
                result.add(fldr);
            }
        } else {
            CTLocation folderLoc = CTLocation.valueOf(CTLocation.Kind.FOLDER, streamTreeNodeName);
            CTFolder fldr = (CTFolder)this.lookup((Location)folderLoc, feedback);
            result.add(fldr);
        }
        return result;
    }

    private List<SrvcResource> doFindStreams(Stream query, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        String querySel = null;
        try {
            querySel = query.getDisplayName();
        }
        catch (WvcmException wvcmException) {}
        if (querySel != null) {
            if (querySel.contains(BASECC_CHAR)) {
                return this.doFindBaseCCStream(querySel, result, feedback);
            }
            String[] streamTokens = this._cc.queryStream(querySel, feedback);
            if (streamTokens == null) {
                return result;
            }
            if (streamTokens.length == 2 && streamTokens[1].equals("read only")) {
                throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_READ_ONLY_STREAMS_NOT_ALLOWED, (Object)streamTokens[0]), WvcmException.ReasonCode.FORBIDDEN);
            }
            CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamTokens[0]);
            CTStream stream = (CTStream)this.lookup((Location)streamLoc, feedback);
            result.add(stream);
            return result;
        }
        String pVobTag = this.getDefaultPvobTag();
        String streamFilter = this.getDefaultStreamFilter();
        if (pVobTag == null) {
            throw new IllegalStateException("A filtered stream query requires a pvob tag");
        }
        List<String> streamNames = this._cc.findStreams(pVobTag, streamFilter, all, feedback);
        for (String streamUsel : streamNames) {
            CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamUsel);
            CTStream stream = (CTStream)this.lookup((Location)streamLoc, feedback);
            result.add(stream);
            if (!all) break;
        }
        return result;
    }

    private List<SrvcResource> doFindBaseCCStream(String querySel, List<SrvcResource> result, SrvcFeedback feedback) throws WvcmException {
        int index = querySel.indexOf(BASECC_CHAR);
        if (index == -1) {
            throw new WvcmException(Messages.CTProvider_INVALID_BASECC_STREAM_FMT_ERROR, WvcmException.ReasonCode.FORBIDDEN);
        }
        String brtype = querySel.substring(0, index);
        String lbtype = querySel.substring(index + 1, querySel.length());
        if (brtype.length() == 0 || brtype.startsWith(AT_SIGN)) {
            brtype = null;
        }
        if (lbtype.length() == 0 || lbtype.startsWith(AT_SIGN)) {
            lbtype = null;
        }
        String brtypeSel = null;
        CTLocation brtypeLocation = null;
        WvcmException brtypeEx = null;
        if (brtype != null) {
            try {
                brtypeSel = this._cc.validateBranchType(brtype, feedback);
                brtypeLocation = CTLocation.valueOf(CTLocation.Kind.BRTYPE, brtypeSel);
            }
            catch (WvcmException e) {
                brtypeEx = e;
            }
        }
        String lbtypeSel = null;
        CTLocation lbtypeLocation = null;
        if (lbtype != null) {
            try {
                lbtypeSel = this._cc.validateAndLockLabelType(lbtype, feedback);
                lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, lbtypeSel);
            }
            catch (WvcmException e) {
                if (brtypeEx != null) {
                    Throwable[] exs = new Throwable[]{brtypeEx, e};
                    throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_LBTYPE_AND_BRTYPE_SELECTORS_NOT_VALID, (Object)lbtype, (Object)brtype), null, WvcmException.ReasonCode.CONFLICT, exs);
                }
                throw e;
            }
        }
        if (brtypeEx != null) {
            throw brtypeEx;
        }
        CTLocation branchLocation = CTLocation.createBranchLocation(brtypeLocation, lbtypeLocation);
        CTBranch branch = (CTBranch)this.lookup((Location)branchLocation, feedback);
        result.add(branch);
        return result;
    }

    private CTWvcmConfiguration doFindConfigurationInView(Configuration query, SrvcFeedback feedback) throws WvcmException {
        if (!query.location().equals((Object)CTLocation._rootLoc)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        Workspace queryWs = query.getWorkspace();
        CTLocation viewLoc = (CTLocation)queryWs.getPathnameLocation();
        VersionHistory queryComp = query.getVersionHistory();
        CTLocation compLoc = (CTLocation)queryComp.getPathnameLocation();
        CTLocation configLoc = null;
        String compSel = compLoc.getDisplayName();
        if (viewLoc.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, compSel);
            CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.getCCaseLib(), compSel, feedback);
            BaseCcComponentInfo info = BaseCcComponentInfo.valueOf(compObjInfo, feedback);
            if (info.isSubVobComponent()) {
                CTResource resource = this.lookup((Location)viewLoc, feedback);
                if (resource == null || !(resource instanceof CTBaseCCView)) {
                    return null;
                }
                CTBaseCCView view = (CTBaseCCView)resource;
                String pathname = info.lookupBaseCcSubVobCompRootDirPathname(view, feedback);
                if (pathname == null) {
                    return null;
                }
            }
            configLoc = CTLocation.createBaseConfigurationLoc(viewLoc, compLoc);
        } else {
            compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compSel);
            configLoc = CTLocation.createConfigurationLoc(viewLoc, compLoc);
        }
        CTWvcmConfiguration result = null;
        if (configLoc != null) {
            result = (CTWvcmConfiguration)this.lookup((Location)configLoc, feedback);
        }
        return result;
    }

    private CTComponent doFindUCMComponent(String compName, SrvcFeedback feedback) throws WvcmException {
        String pVobTag = this.getDefaultPvobTag();
        if (pVobTag == null) {
            return null;
        }
        String compSel = ObjSelUtils.formatSelector("component", compName, pVobTag);
        CCaseObjInfo info = CCaseObjInfo.lookupObjInfo(this._cc, compSel, feedback);
        if (info == null) {
            return null;
        }
        CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, info.getUniversalSelector());
        CTComponent result = (CTComponent)this.lookup((Location)compLoc, feedback);
        return result;
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableResource.doCreateVersionControlledResource(this, (CTLocation)location, (CTLocation)versionLoc, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue streamValue;
        PropValue propValue = streamValue = updates != null ? updates.get(Workspace.TARGET) : null;
        if (streamValue == null) {
            streamValue = updates != null ? updates.get(Workspace.ISOLATED_TARGET) : null;
        }
        CTLocation streamLoc = streamValue != null ? (CTLocation)((Object)streamValue.get_value()) : null;
        CTView result = null;
        result = streamLoc != null && streamLoc.hasKind(CTLocation.Kind.BRANCH) ? CTBaseCCView.doCreateGeneratedResource(this, location, updates, updated, feedback) : CTUcmView.doCreateGeneratedResource(this, location, updates, updated, feedback);
        return result;
    }

    public SrvcResource doBaselineControl(Location location, SrvcFeedback feedback) throws WvcmException {
        CTLocation lastLocation = (CTLocation)location;
        if (lastLocation.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE)) {
            CTLocation parentLocation = lastLocation.parent();
            while (parentLocation != null && !parentLocation.equals((Object)CTLocation._rootLoc)) {
                lastLocation = parentLocation;
                parentLocation = parentLocation.parent();
            }
            if (lastLocation.hasKind(CTLocation.Kind.WORKSPACE)) {
                String viewTag = lastLocation.getDisplayName();
                if (this._cc.isBaseCCView(viewTag, feedback)) {
                    String compVobTagValue = this.lookupCompVobTagValue();
                    if (compVobTagValue != null && compVobTagValue.length() > 0) {
                        return CTControllableFolder.doCreateBaseCcSubVobComponent(this, viewTag, (CTLocation)location, feedback);
                    }
                    throw new WvcmException(NLS.bind((String)Messages.CTProvider_UNSUPPORTED_MKCOMP_ERROR, (Object)location.lastSegment()), WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
                }
                return CTControllableFolder.doCreateComponentAndRoot(this, location, feedback);
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.CTProvider_UNSUPPORTED_FOR_LOCATION, (Object)location));
    }

    public String getDefaultPvobTag() {
        String pVobTag = CTInitArgUtils.getPvobTag(this._initArgs);
        if (pVobTag.length() == 0) {
            return null;
        }
        return pVobTag;
    }

    public String getDefaultCompVobTag(SrvcFeedback feedback) throws WvcmException {
        String compVobTag = this.lookupCompVobTagValue();
        if (compVobTag == null) {
            throw new IllegalStateException("CTProvider's compVob tag initial argument is null");
        }
        if (compVobTag.length() == 0) {
            String msg = feedback.format(Messages.CTProvider_MUST_DEFINE_COMPVOBTAG, new Object[]{"COMPONENT_VOB_TAG"});
            throw new WvcmException(msg, WvcmException.ReasonCode.CONFLICT);
        }
        if (!(compVobTag = CommonUtils.canonicalizePathname(compVobTag)).startsWith(CommonUtils.FWDSLASH)) {
            throw new WvcmException(feedback.format(Messages.CTProvider_COMPVOBTAG_MUST_BE_ABSOLUTE, new Object[]{"COMPONENT_VOB_TAG", compVobTag}), WvcmException.ReasonCode.FORBIDDEN);
        }
        return compVobTag;
    }

    public String lookupCompVobTagValue() {
        return CTInitArgUtils.getCompVobTag(this._initArgs);
    }

    public String getDefaultCompVobTagPrefix(SrvcFeedback feedback) throws WvcmException {
        String compVobTagPrefix = this.lookupCompVobTagPrefixValue();
        if (compVobTagPrefix == null) {
            throw new IllegalStateException("CTProvider's compVob tag prefix initial argument is null");
        }
        if (compVobTagPrefix.length() == 0) {
            return null;
        }
        if (!(compVobTagPrefix = compVobTagPrefix.trim()).startsWith(CommonUtils.FWDSLASH)) {
            throw new WvcmException(feedback.format(Messages.CTProvider_COMPVOBTAGPREFIX_MUST_BE_ABSOLUTE, new Object[]{"COMPONENT_VOB_TAG_PREFIX", compVobTagPrefix}), WvcmException.ReasonCode.FORBIDDEN);
        }
        return compVobTagPrefix;
    }

    public String lookupCompVobTagPrefixValue() {
        return CTInitArgUtils.getCompVobTagPrefix(this._initArgs);
    }

    private String getDefaultStreamFilter() {
        String streamFilter = CTInitArgUtils.getStreamFilter(this._initArgs);
        return streamFilter;
    }

    private boolean isCachingEnabled() {
        return IS_CACHING_ENABLED;
    }

    public List<CTResource> getResources(List<CTLocation> locations, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CTResource> result = new ArrayList<CTResource>();
        for (CTLocation loc : locations) {
            CTResource r = this.get((Location)loc, feedback);
            result.add(r);
        }
        return result;
    }

    private synchronized void persistProxyIfImmutable(CTResource resource, SrvcFeedback feedback) {
        try {
            if (this.isCachingEnabled() && resource.isImmutable()) {
                if (this.persistentObjectCache == null) {
                    this.persistentObjectCache = new HashMap<String, CTResource>();
                }
                this.persistentObjectCache.put(resource.getUniversalSelector(feedback), resource);
            }
        }
        catch (WvcmException e) {
            this.getCCaseLib().logIgnoredExceptionAsAlwaysVisible("CTProvider.persistProxyIfImmutable", Messages.CCaseLib_IGNORED_EXCEPTION_PERFORM_MAP_WRITE, (Exception)((Object)e));
        }
    }

    synchronized CTResource lookupLocationInPersistentProxyCache(CTLocation loc) {
        String dn;
        CTResource result = null;
        CTLocation.Kind kind = loc.getKind();
        if (!_uncachedKinds.contains((Object)kind) && (dn = loc.getDisplayName()) != null && ObjSelUtils.isUniversalSelector(dn) && this.persistentObjectCache != null) {
            result = this.persistentObjectCache.get(dn);
        }
        return result;
    }

    public void flushPathnameCacheEntries(SrvcFeedback feedback) {
        this.persistentObjectCache = null;
        if (feedback != null) {
            ((CTFeedback)feedback).flushCache();
        }
    }

    public void clearCache(Feedback feedback) {
        if (this.persistentObjectCache != null && this.persistentObjectCache.size() > CTInitArgUtils.getProviderCacheMaxSize(this.initArgs())) {
            CTFeedback sfb = this.srvcFeedback(feedback);
            sfb.notifyCompleted(NLS.bind((String)Messages.CTProvider_MSG_CLEARED_CACHE_WITH_COUNT, (Object)String.valueOf(this.persistentObjectCache.size())));
            this.persistentObjectCache = null;
        }
    }

    public void validate(SrvcFeedback feedback) throws WvcmException {
        feedback.notifyActive(Messages.CTProvider_REPORT_MVFS_CASE_CHECK);
        boolean isCasePreserving = this._cc.isCasePreservingMVFS(feedback);
        if (!isCasePreserving) {
            feedback.notifyWarning(Messages.CTProvider_WARN_MUST_PRESERVE_CASE);
        }
    }

    public String getDefaultCharacterSet() {
        return (String)this._initArgs.get("com.ibm.team.connector.scm.CHARACTER_SET");
    }

    private List<SrvcResource> doFindBaselines(Baseline query, SrvcFeedback feedback) throws WvcmException {
        String componentSelector;
        List<Object> result = null;
        Object componentValue = query.lookupProperty(Baseline.VERSION_HISTORY);
        Stream stream = (Stream)query.getProperty(Baseline.ACTIVITY);
        Location streamLocation = stream.getPathnameLocation();
        CTResource resource = this.lookup(streamLocation, feedback);
        Component component = componentValue instanceof Component ? (Component)componentValue : null;
        String string = componentSelector = component != null ? ((CTLocation)component.getPathnameLocation()).getDisplayName() : null;
        if (resource instanceof CTBranch) {
            CTBranch branch = (CTBranch)resource;
            if (componentSelector != null) {
                CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.getCCaseLib(), componentSelector, feedback);
                BaseCcComponentInfo info = BaseCcComponentInfo.valueOf(compObjInfo, feedback);
                result = branch.doFindAllBaseCcBaselines(componentSelector, info, feedback);
            } else {
                feedback.notifyActive(Messages.CTProvider_ERROR_COMPOSITE_BASELINE_NOT_SUPPORTED);
                result = new ArrayList<SrvcResource>();
            }
        } else {
            CTBaseline initialBaseline = null;
            String streamSelector = ((CTLocation)streamLocation).getDisplayName();
            if (componentSelector != null) {
                String initialFoundationBaseline = this._cc.getInitialFoundationBaseline(streamSelector, componentSelector, feedback);
                if (initialFoundationBaseline != null) {
                    initialBaseline = CTBaseline.valueOf(this, initialFoundationBaseline, feedback);
                }
                List<String> baselines = this._cc.getAllBaselines(streamSelector, componentSelector, feedback);
                result = new ArrayList(baselines.size() + 1);
                if (initialBaseline != null) {
                    result.add((SrvcResource)initialBaseline);
                }
                for (String bl : baselines) {
                    CTBaseline baseline = CTBaseline.valueOf(this, bl, feedback);
                    result.add((Object)baseline);
                }
            } else {
                CTBaseline[] foundBlArg;
                CTStream ctStream = CTStream.valueOf(this, streamSelector, feedback);
                CTComponent compositeComponent = ctStream.lookupSingleCompositeInitialFoundationBaseline(foundBlArg = new CTBaseline[1], feedback);
                if (compositeComponent == null) {
                    result = Collections.emptyList();
                } else {
                    LinkedHashMap<String, List<String>> baselineInfos = this._cc.getAllCompositeBaselines(ctStream.getSelector(feedback), compositeComponent.getKindSelector(feedback), feedback);
                    result = new ArrayList(baselineInfos.size());
                    for (Map.Entry<String, List<String>> entry : baselineInfos.entrySet()) {
                        String baselineUSel = entry.getKey();
                        CTBaseline composite = CTBaseline.valueOf(this, baselineUSel, feedback);
                        composite.setSubBaselineUniversalSelectors(entry.getValue(), feedback);
                        result.add((Object)composite);
                    }
                    CTBaseline foundBl = foundBlArg[0];
                    if (!result.contains((Object)foundBl)) {
                        List<String> subs = this._cc.getMemberBaselines(Collections.singletonList(foundBl.getUniversalSelector(feedback)), feedback);
                        foundBl.setSubBaselineUniversalSelectors(subs, feedback);
                        result.add(0, (Object)foundBl);
                    }
                }
            }
        }
        return result;
    }

    public List<Object> doFind(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        BatchedQueryKind queryKind = BatchedQueryKind.UNOPTIMIZED;
        ArrayList<ControllableResource> findCrQueries = new ArrayList<ControllableResource>(queries.size());
        for (Resource query : queries) {
            if (query instanceof ControllableResource) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_CR_IN_WORKSPACE.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_CR_IN_WORKSPACE;
                    findCrQueries.add((ControllableResource)query);
                    continue;
                }
                throw new IllegalStateException("found ControllableResource query after finding query kind : " + queryKind.name());
            }
            if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind)) continue;
            throw new IllegalStateException("found unoptimized query after finding query kind : " + queryKind.name());
        }
        List results = null;
        switch (queryKind) {
            case FIND_CR_IN_WORKSPACE: {
                results = this.doFindCrsInView(queries, feedback);
                break;
            }
            default: {
                results = super.doFind(queries, feedback);
            }
        }
        return results;
    }

    private SrvcResource doFindCRInView(ControllableResource query, SrvcFeedback feedback) throws WvcmException {
        if (!query.location().equals((Object)CTLocation._rootLoc)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        Workspace queryWs = query.getWorkspace();
        Location viewLoc = queryWs.getPathnameLocation();
        CTView view = new CTView(viewLoc, this);
        VersionHistory vh = query.getVersionHistory();
        Location elemLoc = vh.getPathnameLocation();
        CTElement element = new CTElement(elemLoc, this);
        CTLocation myCRLoc = element.lookupMyControllableResourceLoc(view, feedback);
        CTResource result = null;
        if (myCRLoc != null) {
            result = this.lookup((Location)myCRLoc, feedback);
        }
        if (result == null) {
            String vobUuid = element.getObjInfo(feedback).lookupVobUuid();
            vobUuid = vobUuid.substring(vobUuid.indexOf(58) + 1);
            this.ensureVobMounted(vobUuid, feedback);
        }
        return result;
    }

    private List<Object> doFindCrsInView(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        boolean runUnoptimized = false;
        String firstViewLocString = null;
        Location viewLoc = null;
        ArrayList<Location> elementLocations = new ArrayList<Location>(queries.size());
        for (Object genericQuery : queries) {
            if (genericQuery instanceof ControllableResource) {
                ControllableResource query = (ControllableResource)genericQuery;
                viewLoc = query.getWorkspace().getPathnameLocation();
                String viewLocString = viewLoc.string();
                if (firstViewLocString == null) {
                    firstViewLocString = viewLocString;
                } else if (!firstViewLocString.equals(viewLocString)) {
                    runUnoptimized = true;
                    break;
                }
                VersionHistory vh = query.getVersionHistory();
                Location elemLoc = vh.getPathnameLocation();
                elementLocations.add(elemLoc);
                continue;
            }
            runUnoptimized = true;
            break;
        }
        CTView view = (CTView)this.getSrvcRes(viewLoc, feedback);
        if (runUnoptimized) {
            return super.doFind(queries, feedback);
        }
        List<Object> crLocs = CTElement.lookupControlledResourceLocs(view, elementLocations, feedback);
        ArrayList<Object> results = new ArrayList<Object>(crLocs.size());
        for (Object entry : crLocs) {
            if (entry == null || entry instanceof Exception) {
                results.add(entry);
                continue;
            }
            if (entry instanceof Location) {
                results.add((Object)this.lookup((Location)entry, feedback));
                continue;
            }
            IllegalStateException result = new IllegalStateException("unknown resource type found in computed resourceList: " + entry.getClass().getName());
            results.add(result);
        }
        return results;
    }

    private void ensureVobMounted(String vobUuid, SrvcFeedback feedback) throws WvcmException {
        String vobTag = this._cc.computeVobTagFromVobFamilyUuid(vobUuid, feedback);
        if (this._cc.isVobValid(vobTag, feedback) && !this._cc.isVobMounted(vobTag, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_VOB_NOT_MOUNTED, (Object)vobTag), WvcmException.ReasonCode.FORBIDDEN);
        }
    }

    public void validateBaselineFilter(String baselineFilter) throws WvcmException {
        this._cc.validateType(ObjSelUtils.formatSelector("attype", baselineFilter));
    }

    public void validateBranchType(String sel) throws WvcmException {
        this._cc.validateType(ObjSelUtils.formatSelector("brtype", sel));
    }

    public void validateLabelType(String sel) throws WvcmException {
        this._cc.validateType(ObjSelUtils.formatSelector("lbtype", sel));
    }

    public BaseCcSubVobCompRootInfoMap lookupMap(String key) {
        return this.CachedMapsByViewVobPath.get(key);
    }

    public void setMap(String key, BaseCcSubVobCompRootInfoMap map) {
        this.CachedMapsByViewVobPath.put(key, map);
    }

    public boolean alreadyNotified(String notification) {
        return this.notifications.contains(notification);
    }

    public void notified(String notification) {
        this.notifications.add(notification);
    }

    public static enum BatchedQueryKind {
        UNOPTIMIZED,
        FIND_CR_IN_WORKSPACE;

    }

    public static class CTFeedback
    extends SrvcFeedback {
        private final Map<Location, CTResource> _CTResourceCache;

        public CTFeedback(Feedback feedback) {
            super(feedback);
            this._CTResourceCache = new HashMap<Location, CTResource>();
        }

        protected CTFeedback(CTFeedback ctFeedback, Feedback feedback) {
            super((SrvcFeedback)ctFeedback, feedback);
            this._CTResourceCache = ctFeedback._CTResourceCache;
        }

        public CTFeedback nest(int percentCompleted) {
            Feedback f = this.get_feedback();
            Feedback nestedFeedback = f.nest(this.get_feedback().getPropertyRequestForResult(), percentCompleted);
            if (nestedFeedback == f) {
                return this;
            }
            return new CTFeedback(this, nestedFeedback);
        }

        public void setCTResourceCache(Location key, CTResource value) {
            this._CTResourceCache.put(key, value);
        }

        public CTResource lookupCTResourceCache(Location key) {
            return this._CTResourceCache.get(key);
        }

        public void flushCache() {
            this._CTResourceCache.clear();
        }
    }
}

