/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.internal.ClientUtils;
import org.apache.wink.client.internal.handlers.AbstractConnectionHandler;
import org.apache.wink.client.internal.handlers.ClientResponseImpl;
import org.apache.wink.common.internal.WinkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpURLConnectionHandler
extends AbstractConnectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpURLConnectionHandler.class);

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        try {
            HttpURLConnection connection = this.processRequest(request, context);
            return this.processResponse(request, context, connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getBypassHostnameVerification(ClientRequest request, HttpURLConnection connection) {
        return ((ClientConfig)request.getAttribute(WinkConfiguration.class)).getBypassHostnameVerification() && connection instanceof HttpsURLConnection;
    }

    private HostnameVerifier setupHostnameVerificationBypass(HttpsURLConnection connection) {
        HttpsURLConnection https = connection;
        HostnameVerifier hv = https.getHostnameVerifier();
        https.setHostnameVerifier(new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                logger.trace("Bypassing hostname verification: URL host is {}, SSLSession host is {}", (Object)urlHostName, (Object)session.getPeerHost());
                return true;
            }
        });
        return hv;
    }

    private void teardownHostnameVerificationBypass(HttpsURLConnection connection, HostnameVerifier hv) {
        connection.setHostnameVerifier(hv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection processRequest(ClientRequest request, HandlerContext context) throws IOException {
        NonCloseableOutputStream ncos;
        HttpURLConnection connection = this.openConnection(request);
        OutputStream os = ncos = new NonCloseableOutputStream();
        this.processRequestHeaders(request, connection);
        HostnameVerifier hv = null;
        if (this.getBypassHostnameVerification(request, connection)) {
            hv = this.setupHostnameVerificationBypass((HttpsURLConnection)connection);
        }
        try {
            connection.connect();
        }
        finally {
            if (this.getBypassHostnameVerification(request, connection)) {
                this.teardownHostnameVerificationBypass((HttpsURLConnection)connection, hv);
            }
        }
        if (request.getEntity() != null) {
            ncos.setOutputStream(connection.getOutputStream());
            os = this.adaptOutputStream(ncos, request, context.getOutputStreamAdapters());
            this.writeEntity(request, os);
        }
        return connection;
    }

    private HttpURLConnection openConnection(ClientRequest request) throws IOException {
        URL url = request.getURI().toURL();
        HttpURLConnection connection = null;
        ClientConfig config = (ClientConfig)request.getAttribute(WinkConfiguration.class);
        if (config.getProxyHost() != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxyHost(), config.getProxyPort()));
            connection = (HttpURLConnection)url.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod(request.getMethod());
        connection.setConnectTimeout(config.getConnectTimeout());
        connection.setReadTimeout(config.getReadTimeout());
        connection.setInstanceFollowRedirects(config.isFollowRedirects());
        return connection;
    }

    private void processRequestHeaders(ClientRequest request, HttpURLConnection connection) {
        MultivaluedMap<String, String> headers = request.getHeaders();
        for (String header : headers.keySet()) {
            List values = (List)headers.get(header);
            for (String value : values) {
                if (value == null) continue;
                connection.addRequestProperty(header, value);
            }
        }
        if (headers.getFirst("Accept") == null) {
            connection.addRequestProperty("Accept", "*/*");
        }
    }

    private ClientResponse processResponse(ClientRequest request, HandlerContext context, HttpURLConnection connection) throws IOException {
        ClientResponse response = this.createResponse(request, connection);
        InputStream is = null;
        is = ClientUtils.isErrorCode(response.getStatusCode()) ? connection.getErrorStream() : connection.getInputStream();
        is = this.adaptInputStream(is, response, context.getInputStreamAdapters());
        response.setEntity(is);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientResponse createResponse(ClientRequest request, HttpURLConnection connection) throws IOException {
        HostnameVerifier hv = null;
        if (this.getBypassHostnameVerification(request, connection)) {
            hv = this.setupHostnameVerificationBypass((HttpsURLConnection)connection);
        }
        ClientResponseImpl response = new ClientResponseImpl();
        try {
            response.setStatusCode(connection.getResponseCode());
            response.setMessage(connection.getResponseMessage());
            response.getAttributes().putAll(request.getAttributes());
            this.processResponseHeaders(response, connection);
        }
        finally {
            if (this.getBypassHostnameVerification(request, connection)) {
                this.teardownHostnameVerificationBypass((HttpsURLConnection)connection, hv);
            }
        }
        return response;
    }

    private void processResponseHeaders(ClientResponse response, HttpURLConnection connection) {
        response.getHeaders().putAll(connection.getHeaderFields());
    }

    private static class NonCloseableOutputStream
    extends OutputStream {
        OutputStream os;

        public void setOutputStream(OutputStream os) {
            this.os = os;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.os.write(b);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }
    }
}

