/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.util.Constants;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;

public class BuildableSubsetHandle
implements IBuildableSubsetHandle,
Constants {
    private String label;
    private UUID buildDefinitionId;
    private UUID ownerId;
    private IBuildableSubset.Visibility visibility = IBuildableSubset.Visibility.PUBLIC;
    private UUID workSpaceId;

    public BuildableSubsetHandle(SelectResult selectResult) {
        for (Binding binding : selectResult.getBindings()) {
            if (binding.getName().equals("label")) {
                this.label = binding.getValue();
                continue;
            }
            if (binding.getName().equals("ownerId") && this.isValidUUID(binding.getValue())) {
                this.ownerId = UUID.valueOf((String)binding.getValue());
                continue;
            }
            if (binding.getName().equals("buildDefinitionUUID") && this.isValidUUID(binding.getValue())) {
                this.buildDefinitionId = UUID.valueOf((String)binding.getValue());
                continue;
            }
            if (binding.getName().equals("visibility")) {
                this.visibility = IBuildableSubset.Visibility.valueOf(binding.getValue());
                continue;
            }
            if (!binding.getName().equals("workspaceUUID") || !this.isValidUUID(binding.getValue())) continue;
            this.workSpaceId = UUID.valueOf((String)binding.getValue());
        }
    }

    public BuildableSubsetHandle(JSONObject obj) {
        String visibility;
        String buildDefinitionId;
        String ownerId;
        String label = (String)obj.get((Object)"label");
        if (label != null) {
            this.label = label;
        }
        if ((ownerId = (String)obj.get((Object)"ownerId")) != null) {
            this.ownerId = UUID.valueOf((String)ownerId);
        }
        if ((buildDefinitionId = (String)obj.get((Object)"buildDefinitionUUID")) != null) {
            this.buildDefinitionId = UUID.valueOf((String)buildDefinitionId);
        }
        if ((visibility = (String)obj.get((Object)"visibility")) != null) {
            this.visibility = IBuildableSubset.Visibility.valueOf(visibility);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"label", (Object)this.label);
        jsonObject.put((Object)"ownerId", (Object)this.ownerId.getUuidValue());
        jsonObject.put((Object)"buildDefinitionUUID", (Object)this.buildDefinitionId.getUuidValue());
        jsonObject.put((Object)"visibility", (Object)this.visibility.name());
        return jsonObject;
    }

    @Override
    public boolean isValid() {
        return this.label != null && this.buildDefinitionId != null && (this.visibility.equals((Object)IBuildableSubset.Visibility.PUBLIC) && this.ownerId == null || this.ownerId != null);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public UUID getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    @Override
    public void setBuildDefinitionId(UUID buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public IBuildableSubset.Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(IBuildableSubset.Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public UUID getWorkSpaceId() {
        return this.workSpaceId;
    }

    @Override
    public void setWorkSpaceId(UUID workSpaceID) {
        this.workSpaceId = workSpaceID;
    }

    @Override
    public boolean isValidOldModel() {
        return this.label != null && this.workSpaceId != null && this.ownerId == null && this.buildDefinitionId == null;
    }

    protected boolean isValidUUID(String value) {
        try {
            if (value != null && !value.equals("")) {
                UUID.valueOf((String)value);
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

