/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.util;

import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableFileDesc2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubset2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetCriteria2;
import com.ibm.team.repository.common.UUID;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class BuildableSubsetUtil {
    public static String getOldSlug(String label, String workspaceUUID) {
        StringBuffer slugBuffer = new StringBuffer("_workspaceUUID=");
        slugBuffer.append(workspaceUUID);
        slugBuffer.append("_buildableSubsetLabel=");
        slugBuffer.append(BuildableSubsetUtil.createURLEncodedName(label));
        return slugBuffer.toString();
    }

    public static String getSlug(String label, String buildDefinitionUUID) {
        StringBuffer slugBuffer = new StringBuffer("_buildDefinitionUUID=");
        slugBuffer.append(buildDefinitionUUID);
        slugBuffer.append("_buildableSubsetLabel=");
        slugBuffer.append(BuildableSubsetUtil.createURLEncodedName(label));
        return slugBuffer.toString();
    }

    public static boolean isOldSlug(String buildableSubsetSlug) {
        return buildableSubsetSlug.indexOf("_workspaceUUID=") > -1;
    }

    public static String convertToNewSlug(String oldSlug, String buildDefinitionUUID) {
        int index = oldSlug.indexOf("_buildableSubsetLabel=");
        if (index > -1) {
            String encodedLabel = oldSlug.substring(index);
            return "_buildDefinitionUUID=" + buildDefinitionUUID + encodedLabel;
        }
        return oldSlug;
    }

    public static String createURLEncodedName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return name;
        }
    }

    public static String getReferencedCriterionUUID(String reference) {
        int slash = reference.indexOf(47);
        if (slash != -1) {
            return reference.substring(0, slash);
        }
        return reference;
    }

    public static List<Object> getReferencedCriterion(IBuildableFileDesc file, List<IBuildableSubsetCriteria> criteria) {
        ArrayList<Object> result = null;
        if (file != null && criteria != null) {
            result = new ArrayList<Object>();
            for (String reference : file.getCriteriaReferences()) {
                String uuid = BuildableSubsetUtil.getReferencedCriterionUUID(reference);
                for (IBuildableSubsetCriteria criterion : criteria) {
                    Object o;
                    if (!uuid.equals(criterion.getUUID().getUuidValue()) || (o = criterion.deref(reference)) == null) continue;
                    result.add(o);
                }
            }
        }
        return result;
    }

    public static List<IBuildableFileDesc> merge(List<IBuildableFileDesc> existingFiles, Collection<IBuildableFileDesc> newFiles, boolean forceSCMPathUpdate) {
        return BuildableSubsetUtil.merge(existingFiles, newFiles, forceSCMPathUpdate, false);
    }

    public static List<IBuildableFileDesc> merge(List<IBuildableFileDesc> existingFiles, Collection<IBuildableFileDesc> newFiles, boolean forceSCMPathUpdate, boolean returnMergedFiles) {
        ArrayList<IBuildableFileDesc> result = new ArrayList<IBuildableFileDesc>();
        for (IBuildableFileDesc newFile : newFiles) {
            int existingIndex = existingFiles.indexOf(newFile);
            if (existingIndex >= 0) {
                IBuildableFileDesc existingFile = existingFiles.get(existingIndex);
                for (String reference : newFile.getCriteriaReferences()) {
                    if (existingFile.getCriteriaReferences().contains(reference)) continue;
                    existingFile.getCriteriaReferences().add(reference);
                }
                if (forceSCMPathUpdate || existingFile.getScmPath() == null || existingFile.getScmPath().isEmpty()) {
                    existingFile.setScmPath(newFile.getScmPath());
                }
                if (!returnMergedFiles) continue;
                result.add(existingFile);
                continue;
            }
            existingFiles.add(newFile);
            result.add(newFile);
        }
        return result;
    }

    public static List<IBuildableFileDesc2> merge2(List<IBuildableFileDesc2> existingFiles, Collection<IBuildableFileDesc2> newFiles, boolean updateSCMPath) {
        ArrayList<IBuildableFileDesc2> result = new ArrayList<IBuildableFileDesc2>();
        HashMap<BuildableFileDesc2Key, IBuildableFileDesc2> cachedExistingFiles = new HashMap<BuildableFileDesc2Key, IBuildableFileDesc2>(existingFiles.size() + newFiles.size());
        for (IBuildableFileDesc2 file : existingFiles) {
            cachedExistingFiles.put(new BuildableFileDesc2Key(file), file);
        }
        for (IBuildableFileDesc2 newFile : newFiles) {
            BuildableFileDesc2Key key = new BuildableFileDesc2Key(newFile);
            IBuildableFileDesc2 existingFile = (IBuildableFileDesc2)cachedExistingFiles.get(key);
            if (existingFile != null) {
                for (String reference : newFile.getCriteriaReferences()) {
                    if (existingFile.getCriteriaReferences().contains(reference)) continue;
                    existingFile.getCriteriaReferences().add(reference);
                }
                if (!updateSCMPath && existingFile.getScmPath() != null && !existingFile.getScmPath().isEmpty()) continue;
                existingFile.setScmPath(newFile.getScmPath());
                continue;
            }
            existingFiles.add(newFile);
            result.add(newFile);
            cachedExistingFiles.put(key, newFile);
        }
        return result;
    }

    public static List<IBuildableSubsetCriteria> merge(List<IBuildableSubsetCriteria> existingCriteria, Collection<IBuildableSubsetCriteria> newCriteria) {
        return BuildableSubsetUtil.mergeCriteria(existingCriteria, newCriteria, true);
    }

    public static List<IBuildableSubsetCriteria> mergeCriteria(List<IBuildableSubsetCriteria> existingCriteria, Collection<IBuildableSubsetCriteria> newCriteria, boolean updateReferences) {
        ArrayList<IBuildableSubsetCriteria> result = new ArrayList<IBuildableSubsetCriteria>();
        for (IBuildableSubsetCriteria newCriterion : newCriteria) {
            boolean isNew = true;
            if (existingCriteria != null) {
                for (IBuildableSubsetCriteria existingCriterion : existingCriteria) {
                    if (existingCriterion.isDynamic() != newCriterion.isDynamic() || !newCriterion.reconcile(existingCriterion)) continue;
                    isNew = false;
                    if (!updateReferences) continue;
                    String existingUUID = existingCriterion.getUUID().getUuidValue();
                    String newUUID = newCriterion.getUUID().getUuidValue();
                    for (IBuildableFileDesc file : newCriterion.getBuildableFileDescs()) {
                        ListIterator<String> iterator = file.getCriteriaReferences().listIterator();
                        while (iterator.hasNext()) {
                            String newRef = BuildableSubsetUtil.getUpdatedRef(iterator.next(), newUUID, existingUUID);
                            if (newRef == null || file.getCriteriaReferences().contains(newRef)) continue;
                            iterator.set(newRef);
                        }
                    }
                }
            }
            if (!isNew) continue;
            existingCriteria.add(newCriterion);
            result.add(newCriterion);
            isNew = false;
        }
        return result;
    }

    public static SubsetMergeResults merge(List<IBuildableFileDesc> files, List<IBuildableSubsetCriteria> criteria, IBuildableSubset mergeSubset) {
        SubsetMergeResults result = new SubsetMergeResults();
        if (mergeSubset != null) {
            List<IBuildableSubsetCriteria> newCriteria = mergeSubset.getCriteria();
            List<IBuildableFileDesc> newFiles = mergeSubset.getBuildableFileDescs();
            if (newCriteria != null && newCriteria.size() > 0 || newFiles != null && newFiles.size() > 0) {
                result.addedCriteria = BuildableSubsetUtil.merge(criteria, newCriteria);
                result.addedAndMergedFiles = BuildableSubsetUtil.merge(files, newFiles, true, true);
            }
        }
        return result;
    }

    public static String getUpdatedRef(String reference, String newUUID, String existingUUID) {
        String result = null;
        if (reference != null && reference.startsWith(newUUID)) {
            result = reference.replace(newUUID, existingUUID);
        }
        return result;
    }

    public static void associateFilesWithCriteria(IBuildableSubset2 subset) {
        if (subset != null) {
            for (IBuildableSubsetCriteria2 criterion : subset.getCriteria()) {
                String uuidAsString = criterion.getUUID().getUuidValue();
                block1: for (IBuildableFileDesc2 fileDesc : subset.getBuildableFileDescs()) {
                    for (String reference : fileDesc.getCriteriaReferences()) {
                        if (!reference.startsWith(uuidAsString)) continue;
                        criterion.getBuildableFileDescs().add(fileDesc);
                        continue block1;
                    }
                }
            }
        }
    }

    public static String createTransitoryFileListSlug(String subsetId) {
        return "_transitoryFileListId=" + subsetId;
    }

    public static class BuildableFileDesc2Key {
        UUID componentId;
        UUID fileItemId;

        public BuildableFileDesc2Key(IBuildableFileDesc2 desc) {
            this.componentId = desc.getComponent().getItemId();
            this.fileItemId = desc.getFileItem().getItemId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BuildableFileDesc2Key key = (BuildableFileDesc2Key)obj;
            return key.componentId.equals((Object)this.componentId) && key.fileItemId.equals((Object)this.fileItemId);
        }

        public int hashCode() {
            return 31 + (this.componentId == null ? 0 : this.componentId.hashCode()) + (this.fileItemId == null ? 0 : this.fileItemId.hashCode());
        }
    }

    public static class SubsetMergeResults {
        public List<IBuildableSubsetCriteria> addedCriteria = null;
        public List<IBuildableFileDesc> addedAndMergedFiles = null;
    }
}

