/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.HttpUtil;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.IRequestParticipant;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedOutputStream;
import com.ibm.team.repository.common.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class HttpConnection {
    protected final HttpServer server;
    protected final SocketChannel socket;
    private final Object requestLock;
    private final LinkedList<HttpRequest> reqs;
    private final LinkedList<HttpResponse> resps;
    protected final SocketInputStream socketIn;
    protected final SocketOutputStream socketOut;
    protected final InputStream input;
    protected final OutputStream output;
    protected final Object keyLock;
    protected SelectionKey sKey;
    protected boolean reachedEOF;
    protected final ByteBuffer inputBuffer;
    protected final Object writeLock;
    protected ByteBuffer outputBuffer;
    protected IOException outputException;
    protected boolean allowIOInterrupt;
    private IRequestParticipant connectParticipant;
    private boolean firstTime = true;

    HttpConnection(HttpServer httpServer, SocketChannel s) {
        this.server = httpServer;
        this.socket = s;
        this.inputBuffer = ByteBuffer.allocate(8192);
        this.writeLock = new Object();
        this.keyLock = new Object();
        this.socketIn = new SocketInputStream();
        this.socketOut = new SocketOutputStream();
        this.input = new UnsynchronizedBufferedInputStream((InputStream)this.socketIn, 8192);
        this.output = new UnsynchronizedBufferedOutputStream((OutputStream)this.socketOut, 8192);
        this.reqs = new LinkedList();
        this.resps = new LinkedList();
        this.requestLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionKey addOpsToKey(int ops) throws IOException {
        Object object = this.keyLock;
        synchronized (object) {
            SelectionKey key = this.sKey;
            Object object2 = this.server.selLock;
            synchronized (object2) {
                Selector sel = this.server.sel;
                sel.wakeup();
                if (key == null) {
                    this.sKey = key = this.socket.register(sel, ops, this);
                    return key;
                }
                int current = key.interestOps();
                ops = current | ops;
                if (ops != current) {
                    key.interestOps(ops);
                }
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOpsFromKey(int ops) throws IOException {
        Object object = this.keyLock;
        synchronized (object) {
            SelectionKey key = this.sKey;
            if (key == null) {
                return;
            }
            int toSet = key.interestOps() & ~ops;
            key.interestOps(toSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSocket() throws IOException {
        ByteBuffer byteBuffer = this.inputBuffer;
        synchronized (byteBuffer) {
            boolean stopReading;
            Object object = this.requestLock;
            synchronized (object) {
                if (this.sKey == null) {
                    return;
                }
                boolean wasEmpty = this.inputBuffer.position() == 0;
                int result = -1;
                try {
                    result = this.socket.read(this.inputBuffer);
                }
                catch (IOException iOException) {}
                if (result == -1) {
                    this.reachedEOF = true;
                    if (this.reqs.isEmpty()) {
                        this.internalClose();
                        stopReading = false;
                    } else {
                        for (HttpResponse resp : this.resps) {
                            IExternalManager man = resp.externalManager;
                            if (man == null) continue;
                            man.remoteClosed();
                        }
                        stopReading = true;
                    }
                } else {
                    boolean bl = stopReading = !this.inputBuffer.hasRemaining();
                    if (wasEmpty && (this.reqs.isEmpty() || this.reqs.getLast().finishedReading)) {
                        this.scheduleNextRequest();
                    }
                }
            }
            if (stopReading) {
                this.removeOpsFromKey(1);
            }
            this.inputBuffer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSocket() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                Object object2 = this.requestLock;
                synchronized (object2) {
                    if (this.sKey == null) {
                        return;
                    }
                    this.socket.write(this.outputBuffer);
                }
                if (this.outputBuffer.hasRemaining()) {
                    return;
                }
            }
            catch (IOException e) {
                this.outputException = e;
            }
            this.outputBuffer = null;
            this.removeOpsFromKey(4);
            this.writeLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFinished() {
        ByteBuffer byteBuffer = this.inputBuffer;
        synchronized (byteBuffer) {
            Object object = this.requestLock;
            synchronized (object) {
                if (this.reqs.isEmpty() || !this.reqs.getLast().finishedReading) {
                    return;
                }
                boolean schedule = true;
                try {
                    schedule = this.input.available() != 0;
                }
                catch (IOException e) {
                    LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                }
                if (schedule) {
                    this.scheduleNextRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleNextRequest() {
        Object object = this.requestLock;
        synchronized (object) {
            this.reqs.add(new HttpRequest(this));
        }
        Job j = new Job("Request Handler"){

            protected IStatus run(IProgressMonitor monitor) {
                HttpConnection.this.readNextRequest();
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.setUser(false);
        j.schedule();
    }

    protected void handleSocket() throws IOException {
        boolean success = false;
        try {
            try {
                SocketChannel chan = this.socket;
                chan.configureBlocking(false);
                this.sKey = chan.register(this.server.sel, 1, this);
                success = true;
            }
            catch (IOException e) {
                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                if (!success) {
                    this.internalClose();
                }
            }
        }
        finally {
            if (!success) {
                this.internalClose();
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void readNextRequest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[WHILELOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean readRequest(InputStream in, HttpRequest request) throws IOException {
        if (!this.readRequestLine(request, in)) {
            return false;
        }
        this.readHeaders(request, in);
        return true;
    }

    protected void readHeaders(HttpRequest r, InputStream in) throws IOException {
        String lastLine = null;
        while (true) {
            String line;
            if ((line = this.readLine(in, false)) == null) {
                throw new IOException("Client closed connection");
            }
            if (line.length() == 0) {
                if (lastLine != null) {
                    this.addHeader(r, lastLine);
                }
                return;
            }
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (lastLine == null) {
                    throw new IOException("Illegal continuation on 1st line");
                }
                lastLine = String.valueOf(lastLine) + line;
                continue;
            }
            if (lastLine != null) {
                this.addHeader(r, lastLine);
            }
            lastLine = line;
        }
    }

    protected void addHeader(HttpRequest r, String headerLine) throws IOException {
        String[] header = HttpUtil.parseHttpHeader(headerLine);
        if (header == null) {
            throw new IOException("Invalid header line: " + headerLine);
        }
        String key = header[0];
        String value = header[1];
        r.addHeader(key, value);
    }

    protected boolean readRequestLine(HttpRequest r, InputStream in) throws IOException {
        URI uri;
        String line = this.readLine(in, true);
        if (line == null) {
            return false;
        }
        String[] request = HttpUtil.parseHttpRequest(line);
        if (request == null) {
            throw new IOException("Invalid request " + line);
        }
        HttpMethod method = HttpMethod.valueOf(request[0]);
        try {
            uri = new URI(request[1]);
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        r.method = method;
        r.uri = uri;
        r.protocolMajor = Integer.valueOf(request[2]);
        r.protocolMinor = Integer.valueOf(request[3]);
        if (r.getMajorVersion() != 1) {
            throw new IOException("Unknown protocol version " + r.getMajorVersion() + "." + r.getMinorVersion());
        }
        return true;
    }

    protected String readLine(InputStream in, boolean allowShutdown) throws IOException {
        StringBuilder b = new StringBuilder();
        boolean lastCR = false;
        while (true) {
            int read;
            this.allowIOInterrupt = allowShutdown && b.length() == 0;
            try {
                try {
                    read = in.read();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.allowIOInterrupt = false;
                    return null;
                }
            }
            finally {
                this.allowIOInterrupt = false;
            }
            if (read == -1) {
                if (b.length() == 0 && !lastCR) {
                    return null;
                }
                throw new IOException("Client closed connection");
            }
            if (read == 10) {
                return b.toString();
            }
            if (lastCR) {
                b.append('\r');
                lastCR = false;
            }
            if (read == 13) {
                lastCR = true;
                continue;
            }
            b.append((char)read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClientConnected() {
        ByteBuffer byteBuffer = this.inputBuffer;
        synchronized (byteBuffer) {
            return !this.reachedEOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finishResponse(HttpRequest request, HttpResponse response) {
        boolean shouldDisconnect = true;
        try {
            try {
                try {
                    InputStream in = request.getRequestBody();
                    do {
                        in.skip(Long.MAX_VALUE);
                    } while (in.read() != -1);
                }
                finally {
                    response.finish();
                }
                shouldDisconnect = response.shouldDisconnect();
            }
            catch (IOException e) {
                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                Object object = this.requestLock;
                synchronized (object) {
                    while (true) {
                        if (this.reqs.getFirst() == request) {
                            this.reqs.removeFirst();
                            if (this.resps.removeFirst() != response) {
                                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " outgoing response is not top in list"));
                            }
                            this.requestLock.notifyAll();
                            if (!shouldDisconnect && !this.reachedEOF) {
                                if (!this.server.shutdown) return;
                            }
                            if (!this.reqs.isEmpty()) return;
                            this.internalClose();
                            return;
                        }
                        try {
                            this.requestLock.wait();
                        }
                        catch (InterruptedException e2) {
                            LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object object = this.requestLock;
            synchronized (object) {
                while (true) {
                    if (this.reqs.getFirst() == request) {
                        this.reqs.removeFirst();
                        if (this.resps.removeFirst() != response) {
                            LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " outgoing response is not top in list"));
                        }
                        this.requestLock.notifyAll();
                        if (!shouldDisconnect && !this.reachedEOF) {
                            if (!this.server.shutdown) throw throwable;
                        }
                        if (!this.reqs.isEmpty()) throw throwable;
                        this.internalClose();
                        throw throwable;
                    }
                    try {
                        this.requestLock.wait();
                    }
                    catch (InterruptedException e) {
                        LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        Object object = this.requestLock;
        synchronized (object) {
            while (true) {
                if (this.reqs.getFirst() == request) {
                    this.reqs.removeFirst();
                    if (this.resps.removeFirst() != response) {
                        LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " outgoing response is not top in list"));
                    }
                    this.requestLock.notifyAll();
                    if (!shouldDisconnect && !this.reachedEOF) {
                        if (!this.server.shutdown) return;
                    }
                    if (!this.reqs.isEmpty()) return;
                    this.internalClose();
                    return;
                }
                try {
                    this.requestLock.wait();
                }
                catch (InterruptedException e) {
                    LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void abortRequest(HttpRequest request) {
        try {
            try {
                HttpResponse previous;
                Object object = this.requestLock;
                synchronized (object) {
                    previous = !this.resps.isEmpty() ? this.resps.getLast() : null;
                }
                if (previous != null) {
                    previous.waitUntilFinished();
                }
            }
            catch (IOException e) {
                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                Object object = this.requestLock;
                synchronized (object) {
                    while (true) {
                        if (this.reqs.getFirst() == request) {
                            this.reqs.removeFirst();
                            this.requestLock.notifyAll();
                            if (!this.reqs.isEmpty()) {
                                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " requests following aborted request"));
                            }
                            if (!this.resps.isEmpty()) {
                                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " requests following aborted request"));
                            }
                            this.internalClose();
                            return;
                        }
                        try {
                            this.requestLock.wait();
                        }
                        catch (InterruptedException e2) {
                            LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object object = this.requestLock;
            synchronized (object) {
                while (true) {
                    if (this.reqs.getFirst() == request) {
                        this.reqs.removeFirst();
                        this.requestLock.notifyAll();
                        if (!this.reqs.isEmpty()) {
                            LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " requests following aborted request"));
                        }
                        if (!this.resps.isEmpty()) {
                            LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " requests following aborted request"));
                        }
                        this.internalClose();
                        throw throwable;
                    }
                    try {
                        this.requestLock.wait();
                    }
                    catch (InterruptedException e) {
                        LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        Object object = this.requestLock;
        synchronized (object) {
            while (true) {
                if (this.reqs.getFirst() == request) {
                    this.reqs.removeFirst();
                    this.requestLock.notifyAll();
                    if (!this.reqs.isEmpty()) {
                        LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " requests following aborted request"));
                    }
                    if (!this.resps.isEmpty()) {
                        LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)("Badness in " + this.getClass().getName() + " requests following aborted request"));
                    }
                    this.internalClose();
                    return;
                }
                try {
                    this.requestLock.wait();
                }
                catch (InterruptedException e) {
                    LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose() {
        block8: {
            try {
                try {
                    SelectionKey key = this.sKey;
                    if (key == null) break block8;
                    Object object = this.server.selLock;
                    synchronized (object) {
                        this.server.sel.wakeup();
                        key.cancel();
                    }
                    this.sKey = null;
                }
                finally {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                LogFactory.getLog((String)HttpConnection.class.getName()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.server.deregister(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() {
        Object lock;
        Object object = lock = this.inputBuffer;
        synchronized (object) {
            lock.notifyAll();
        }
        object = lock = this.writeLock;
        synchronized (object) {
            lock.notifyAll();
        }
        object = this.requestLock;
        synchronized (object) {
            if (this.reqs.isEmpty()) {
                this.internalClose();
            } else {
                for (HttpResponse rp : this.resps) {
                    IExternalManager mgr = rp.externalManager;
                    if (mgr == null) continue;
                    mgr.shutdown();
                }
            }
        }
    }

    public int getPeerPort() {
        return this.socket.socket().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequests() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.reqs.size() > 0;
        }
    }

    protected class SocketInputStream
    extends InputStream {
        protected SocketInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            int result;
            ByteBuffer byteBuffer = HttpConnection.this.inputBuffer;
            synchronized (byteBuffer) {
                while (true) {
                    if (HttpConnection.this.inputBuffer.position() != 0) {
                        boolean hasRemaining = HttpConnection.this.inputBuffer.hasRemaining();
                        HttpConnection.this.inputBuffer.flip();
                        result = HttpConnection.this.inputBuffer.get() & 0xFF;
                        HttpConnection.this.inputBuffer.compact();
                        if (!hasRemaining && !HttpConnection.this.reachedEOF) break;
                        return result;
                    }
                    if (HttpConnection.this.reachedEOF) {
                        return -1;
                    }
                    if (HttpConnection.this.allowIOInterrupt && HttpConnection.this.server.shutdown) {
                        throw new SocketTimeoutException();
                    }
                    try {
                        HttpConnection.this.inputBuffer.wait();
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
            HttpConnection.this.addOpsToKey(1);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            ByteBuffer byteBuffer = HttpConnection.this.inputBuffer;
            synchronized (byteBuffer) {
                while (true) {
                    int size;
                    if ((size = HttpConnection.this.inputBuffer.position()) != 0) {
                        boolean hasRemaining = HttpConnection.this.inputBuffer.hasRemaining();
                        HttpConnection.this.inputBuffer.flip();
                        size = Math.min(size, len);
                        HttpConnection.this.inputBuffer.get(b, off, size);
                        HttpConnection.this.inputBuffer.compact();
                        result = size;
                        if (!hasRemaining && !HttpConnection.this.reachedEOF) break;
                        return result;
                    }
                    if (HttpConnection.this.reachedEOF) {
                        return -1;
                    }
                    if (HttpConnection.this.allowIOInterrupt && HttpConnection.this.server.shutdown) {
                        throw new SocketTimeoutException();
                    }
                    try {
                        HttpConnection.this.inputBuffer.wait();
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
            HttpConnection.this.addOpsToKey(1);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long skip(long n) throws IOException {
            long result;
            if (n <= 0L) {
                return 0L;
            }
            ByteBuffer byteBuffer = HttpConnection.this.inputBuffer;
            synchronized (byteBuffer) {
                while (true) {
                    int size;
                    if ((size = HttpConnection.this.inputBuffer.position()) != 0) {
                        boolean hasRemaining = HttpConnection.this.inputBuffer.hasRemaining();
                        if ((long)size > n) {
                            HttpConnection.this.inputBuffer.flip();
                            HttpConnection.this.inputBuffer.position((int)n);
                            HttpConnection.this.inputBuffer.compact();
                            result = n;
                        } else {
                            HttpConnection.this.inputBuffer.clear();
                            result = size;
                        }
                        if (!hasRemaining && !HttpConnection.this.reachedEOF) break;
                        return result;
                    }
                    if (HttpConnection.this.reachedEOF) {
                        return 0L;
                    }
                    if (HttpConnection.this.allowIOInterrupt && HttpConnection.this.server.shutdown) {
                        throw new SocketTimeoutException();
                    }
                    try {
                        HttpConnection.this.inputBuffer.wait();
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
            HttpConnection.this.addOpsToKey(1);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ByteBuffer byteBuffer = HttpConnection.this.inputBuffer;
            synchronized (byteBuffer) {
                return HttpConnection.this.inputBuffer.position();
            }
        }
    }

    protected class SocketOutputStream
    extends OutputStream {
        protected SocketOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = HttpConnection.this.writeLock;
            synchronized (object) {
                HttpConnection.this.outputBuffer = ByteBuffer.allocate(1);
                HttpConnection.this.outputBuffer.put((byte)b);
                HttpConnection.this.outputBuffer.flip();
                HttpConnection.this.addOpsToKey(4);
                try {
                    try {
                        do {
                            HttpConnection.this.writeLock.wait();
                            if (HttpConnection.this.outputException == null) continue;
                            IOException ioe = new IOException(HttpConnection.this.outputException.getMessage());
                            ioe.initCause(HttpConnection.this.outputException);
                            throw ioe;
                        } while (HttpConnection.this.outputBuffer != null);
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                finally {
                    HttpConnection.this.outputBuffer = null;
                    HttpConnection.this.outputException = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            Object object = HttpConnection.this.writeLock;
            synchronized (object) {
                HttpConnection.this.outputBuffer = ByteBuffer.wrap(b, off, len);
                HttpConnection.this.addOpsToKey(4);
                try {
                    try {
                        do {
                            HttpConnection.this.writeLock.wait();
                            if (HttpConnection.this.outputException == null) continue;
                            IOException ioe = new IOException(HttpConnection.this.outputException.getMessage());
                            ioe.initCause(HttpConnection.this.outputException);
                            throw ioe;
                        } while (HttpConnection.this.outputBuffer != null);
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                finally {
                    HttpConnection.this.outputBuffer = null;
                    HttpConnection.this.outputException = null;
                }
            }
        }
    }
}

