/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest;

import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.IServiceDescription;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONReceiver;
import com.ibm.team.filesystem.client.internal.rest.InactivityTimingJob;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.common.internal.rest.lifecycle.core.CompatabilityDTO;
import com.ibm.team.filesystem.common.internal.rest.lifecycle.core.LifecycleRestClientDTOFactory;
import com.ibm.team.filesystem.common.internal.rest.lifecycle.core.ServiceReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;

public class LifecycleRestClient
extends JSONReceiver
implements ILifecycleRestClient {
    private IdentityHashMap<TimeoutBlocker, Object> blockers = null;
    IServerController controller;
    JSONHandler handler;
    final InactivityTimingJob shutdownJob = new InactivityTimingJob();

    public synchronized void addTimeoutBlocker(TimeoutBlocker blocker) {
        if (this.blockers == null) {
            this.blockers = new IdentityHashMap();
        }
        this.blockers.put(blocker, blocker);
    }

    public synchronized void removeTimeoutBlocker(TimeoutBlocker blocker) {
        if (this.blockers == null) {
            throw new IllegalStateException("Can't remove nonexistant TimeoutBlocker");
        }
        if (this.blockers.remove(blocker) == null) {
            throw new IllegalStateException("Can't remove unknown TimeoutBlocker");
        }
        this.shutdownJob.attemptShutdown();
    }

    public synchronized void allowTimeout(TimeoutBlocker blocker) {
        if (this.blockers == null) {
            throw new IllegalStateException("Can't remove nonexistant TimeoutBlocker");
        }
        if (!this.blockers.containsKey(blocker)) {
            throw new IllegalStateException("Unknown TimeoutBlocker may not allow a timeout");
        }
        this.shutdownJob.attemptShutdown();
    }

    protected synchronized boolean mayShutdownDueToInactivityTimeout() {
        if (this.handler.getFSDaemon().getHttpServer() == null) {
            return false;
        }
        if (this.handler.getFSDaemon().getHttpServer().isWorking()) {
            return false;
        }
        if (this.blockers == null) {
            return true;
        }
        for (TimeoutBlocker blocker : this.blockers.keySet()) {
            if (blocker.mayShutdownDueToTimeout()) continue;
            return false;
        }
        return true;
    }

    public void postShutdown() throws TeamRepositoryException {
        try {
            this.shutdown();
        }
        catch (IOException e) {
            throw new TeamRepositoryException("Could not shutdown daemon server.", (Throwable)e);
        }
    }

    @Override
    public void installationNotification(IServerController controller, JSONHandler handler) {
        this.controller = controller;
        this.handler = handler;
        this.shutdownJob.connect(this);
        handler.getHttpServer().addListener(this.shutdownJob);
    }

    public CompatabilityDTO getVerifyVersions(ILifecycleRestClient.ExpectedVersionParam param) throws TeamRepositoryException {
        Map<String, IServiceDescription> descs = this.handler.getServiceDescriptions();
        CompatabilityDTO toReturn = LifecycleRestClientDTOFactory.eINSTANCE.createCompatabilityDTO();
        for (IServiceDescription srvc : descs.values()) {
            ServiceReport aboutService = LifecycleRestClientDTOFactory.eINSTANCE.createServiceReport();
            aboutService.setCompatible(false);
            aboutService.setInstalledVersion(srvc.getVersion());
            toReturn.getServices().put(srvc.getServiceId(), aboutService);
        }
        if (param.services == null) {
            return toReturn;
        }
        ILifecycleRestClient.ServiceVersionParam[] serviceVersionParamArray = param.services;
        int n = param.services.length;
        int n2 = 0;
        while (n2 < n) {
            ILifecycleRestClient.ServiceVersionParam expected = serviceVersionParamArray[n2];
            ServiceReport serviceReport = (ServiceReport)toReturn.getServices().get(expected.interfaceId);
            if (expected.expectedVersion != null && LifecycleRestClient.isCompatible(serviceReport.getInstalledVersion(), expected.expectedVersion)) {
                serviceReport.setCompatible(true);
            }
            ++n2;
        }
        return toReturn;
    }

    public static boolean isCompatible(String inst, String req) {
        String[] reqSegments;
        if (inst.equals(req)) {
            return true;
        }
        String[] instSegments = inst.split("\\.");
        if (instSegments.length != (reqSegments = req.split("\\.")).length) {
            return false;
        }
        if (instSegments.length == 1) {
            return inst.equals(req);
        }
        int i = instSegments.length - 2;
        while (i >= 0) {
            if (!instSegments[i].equals(reqSegments[i])) {
                return false;
            }
            --i;
        }
        try {
            int LAST = instSegments.length - 1;
            int instServiceNumber = Integer.parseInt(instSegments[LAST]);
            int reqServiceNumber = Integer.parseInt(reqSegments[LAST]);
            return instServiceNumber >= reqServiceNumber;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public synchronized void postTimeout(ILifecycleRestClient.TimeoutParam param) throws TeamRepositoryException {
        this.shutdownJob.setTimeout(param.millisOfInactivityBeforeShutdown);
    }

    public void shutdown() throws IOException {
        if (this.controller != null) {
            this.controller.shutdown();
        }
    }

    public static class TimeoutBlocker {
        public boolean mayShutdownDueToTimeout() {
            return true;
        }
    }
}

