/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.daemon.Messages;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.internal.utils.IFSDaemon;
import com.ibm.team.filesystem.client.internal.utils.PropertiesLoader;
import com.ibm.team.filesystem.client.internal.utils.SandboxClaimer;
import com.ibm.team.filesystem.client.restproxy.RegistryEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DaemonRegistry
implements IDaemonRegistry {
    private static final long MAX_REGISTRY_WAIT = 20000L;
    public static final String REGISTRY_ROOT = "daemons";
    private static final String LOCK_FILE_NAME = "lock";
    private static final String SANDBOX_LIST_NAME = "sandboxes";
    public static final String ALIVELOCK_NAME = "alivelock";
    public static final String DESCRIPTION_NAME = "daemon.properties";
    public static final String PROP_DESCRIPTION = "daemon.description";
    public static final String PROP_VERSION = "version";
    public static final String PROP_PORT = "daemon.port";
    public static final String PROP_KEY = "daemon.key";
    public static final String PROP_PROCESS_UUID = "process.uuid";
    public static String DAEMON_LOCATION = "location";
    private static final String ENCODING = "UTF-8";
    private HashSet<DaemonRecord> daemons = new HashSet();
    private volatile boolean hasPurged = false;
    private final File registryLocation;
    public static final String PROPERTY_DAEMON_DIR = "fsdaemon.directory.location";
    private static final FileFilter REGISTRY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static DaemonRegistry instance = null;

    private DaemonRegistry() throws IOException {
        this.registryLocation = DaemonRegistry.getDefaultRegistryLocation();
    }

    public DaemonRegistry(File location) {
        this.registryLocation = new File(location, REGISTRY_ROOT);
    }

    private static synchronized File getDefaultRegistryLocation() throws IOException {
        String location = System.getProperty(PROPERTY_DAEMON_DIR);
        if (location == null || "".equals(location)) {
            return new File(FileSystemCore.getUserConfigDir().getConfigDirAsFile(), REGISTRY_ROOT);
        }
        return new File(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DaemonRecord findRecordAndAcquire(IFSDaemon daemon, long waitDuration, IProgressMonitor progress) throws IllegalStateException, IDaemonRegistry.DaemonRegistryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        HashSet<DaemonRecord> hashSet = this.daemons;
        synchronized (hashSet) {
            FilesystemLock registryLock = this.acquireRegistryLock(this.registryLocation, monitor.newChild(1));
            if (registryLock == null) {
                return null;
            }
            try {
                for (DaemonRecord rec : this.daemons) {
                    if (!daemon.equals(rec.daemon)) continue;
                    if (!rec.lock.acquire(waitDuration, (IProgressMonitor)monitor.newChild(1)).isOK()) throw new IDaemonRegistry.DaemonRegistryException(Messages.getString("DaemonRegistry_FAILED_TO_ACQUIRE_LOCK"));
                    DaemonRecord daemonRecord = rec;
                    return daemonRecord;
                }
            }
            finally {
                registryLock.release((IProgressMonitor)monitor.newChild(1));
            }
            return null;
        }
    }

    public File registerDaemon(FSDaemon daemon, IProgressMonitor progress) throws FileSystemException, IllegalArgumentException, IOException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)11);
        this.purgeStaleDaemonsConditionally((IProgressMonitor)monitor.newChild(1));
        DaemonRecord rec = new DaemonRecord(daemon);
        HashSet<DaemonRecord> hashSet = this.daemons;
        synchronized (hashSet) {
            File file;
            block8: {
                if (this.daemons.contains(rec)) {
                    throw new FileSystemException("Double registration of daemon");
                }
                this.daemons.add(rec);
                boolean failed = true;
                try {
                    File daemonEntryDir = this.createLockedDaemonDirFor(this.registryLocation, rec, monitor.newChild(8));
                    rec.startClaimer();
                    failed = false;
                    file = daemonEntryDir;
                    if (!failed) break block8;
                }
                catch (Throwable throwable) {
                    if (failed) {
                        this.deregisterDaemon(daemon, (IProgressMonitor)monitor.newChild(1));
                        this.daemons.remove(rec);
                    }
                    throw throwable;
                }
                this.deregisterDaemon(daemon, (IProgressMonitor)monitor.newChild(1));
                this.daemons.remove(rec);
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDaemon(FSDaemon daemon, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)12);
        this.purgeStaleDaemonsConditionally((IProgressMonitor)monitor.newChild(1));
        HashSet<DaemonRecord> hashSet = this.daemons;
        synchronized (hashSet) {
            DaemonRecord toRemove = null;
            for (DaemonRecord rec : this.daemons) {
                if (!daemon.equals(rec.daemon)) continue;
                toRemove = rec;
                break;
            }
            if (toRemove == null) {
                return;
            }
            toRemove.stopClaimer();
            FilesystemLock registryLock = this.acquireRegistryLock(this.registryLocation, monitor.newChild(5));
            try {
                toRemove.lock.release((IProgressMonitor)monitor.newChild(1));
                toRemove.aliveLock.release((IProgressMonitor)monitor.newChild(1));
                if (registryLock != null) {
                    DaemonRegistry.recursivelyDelete(toRemove.directory);
                }
            }
            finally {
                if (registryLock != null) {
                    registryLock.release((IProgressMonitor)monitor.newChild(1));
                }
            }
            this.daemons.remove(toRemove);
        }
    }

    private File createLockedDaemonDirFor(File registryDir, DaemonRecord rec, SubMonitor monitor) throws FileSystemException, IllegalArgumentException, IOException {
        FilesystemLock registryLock;
        block9: {
            monitor.beginTask(Messages.getString("DaemonRegistry_REGISTERING_STATUS"), 22);
            registryLock = this.acquireRegistryLock(registryDir, monitor.newChild(1));
            if (registryLock == null) {
                System.out.println(Messages.getString("DaemonRegistry_UNABLE_TO_LOCK"));
                return null;
            }
            File candidateDir = new File(registryDir, "D" + Integer.toHexString(Integer.reverseBytes(rec.daemon.getPort())));
            FilesystemLock dirLock = new FilesystemLock(new File(candidateDir, LOCK_FILE_NAME));
            if (!dirLock.acquire((IProgressMonitor)monitor.newChild(1)).isOK()) break block9;
            try {
                rec.directory = candidateDir;
                rec.lock = dirLock;
                rec.aliveLock = new FilesystemLock(new File(candidateDir, ALIVELOCK_NAME));
                IStatus status = rec.aliveLock.acquire((IProgressMonitor)monitor.newChild(1));
                if (!status.isOK()) {
                    System.err.println(String.valueOf(Messages.getString("DaemonRegistry_LOCK_COULD_NOT_BE_ACQUIRED")) + rec.aliveLock.toString());
                    System.err.println(status.getMessage());
                }
                rec.daemon.writeLocation(new File(candidateDir, DAEMON_LOCATION));
                File file = candidateDir;
                return file;
            }
            finally {
                dirLock.release((IProgressMonitor)monitor.newChild(1));
            }
        }
        throw new FileSystemException(Messages.getString("DaemonRegistry_COULD_NOT_CREATE_REGISTRY_DIR"));
        finally {
            registryLock.release((IProgressMonitor)monitor.newChild(1));
        }
    }

    public Collection<IDaemonRegistry.IRegistryEntry> listDaemons(IProgressMonitor progress) {
        return this.listDaemons(5000L, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IDaemonRegistry.IRegistryEntry> listDaemons(long timeout, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)11);
        this.purgeStaleDaemonsConditionally((IProgressMonitor)monitor.newChild(1));
        LinkedList<IDaemonRegistry.IRegistryEntry> toReturn = new LinkedList<IDaemonRegistry.IRegistryEntry>();
        HashSet<DaemonRecord> hashSet = this.daemons;
        synchronized (hashSet) {
            FilesystemLock registryLock = this.acquireRegistryLock(this.registryLocation, monitor.newChild(1));
            if (registryLock == null) {
                return Collections.emptyList();
            }
            try {
                File[] toVisit = this.registryLocation.listFiles(REGISTRY_FILTER);
                monitor.beginTask(Messages.getString("DaemonRegistry_SEARCH_STATUS"), toVisit.length * 3);
                File[] fileArray = toVisit;
                int n = toVisit.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FilesystemLock daemonLock = new FilesystemLock(new File(f, LOCK_FILE_NAME));
                    if (daemonLock.acquire(timeout, (IProgressMonitor)monitor.newChild(1)).isOK()) {
                        FSDaemon.ILockFile lockFile;
                        try {
                            lockFile = FSDaemon.readLock(new File(f, DAEMON_LOCATION));
                        }
                        catch (IOException iOException) {
                            daemonLock.release((IProgressMonitor)monitor.newChild(1));
                        }
                        try {
                            FilesystemLock liveLock = new FilesystemLock(new File(f, ALIVELOCK_NAME));
                            if (liveLock.acquire((IProgressMonitor)monitor.newChild(1)).isOK()) {
                                liveLock.release((IProgressMonitor)monitor.newChild(1));
                            } else {
                                Collection<String> sandboxes = this.listSandboxesInternal(f, monitor.newChild(1));
                                Map<String, String> props = this.loadDaemonPropertiesInternal(f, monitor.newChild(1));
                                toReturn.add(new RegistryEntry(this, lockFile.getKey(), lockFile.getPort(), props.get(PROP_DESCRIPTION), sandboxes, props));
                            }
                        }
                        finally {
                            daemonLock.release((IProgressMonitor)monitor.newChild(1));
                        }
                    }
                    ++n2;
                }
            }
            finally {
                registryLock.release((IProgressMonitor)monitor.newChild(1));
            }
        }
        return toReturn;
    }

    private void purgeStaleDaemonsConditionally(IProgressMonitor progress) {
        if (this.hasPurged) {
            if (progress != null) {
                progress.done();
            }
            return;
        }
        this.hasPurged = true;
        this.purgeStaleDaemons(progress);
    }

    private void purgeStaleDaemons(IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.getString("DaemonRegistry_PURGE_STATUS"), (int)5);
        FilesystemLock registryLock = this.acquireRegistryLock(this.registryLocation, monitor.newChild(1));
        if (registryLock == null) {
            return;
        }
        try {
            File[] toVisit = this.registryLocation.listFiles(REGISTRY_FILTER);
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(toVisit.length * 4));
            File[] fileArray = toVisit;
            int n = toVisit.length;
            int n2 = 0;
            while (n2 < n) {
                File daemonDir = fileArray[n2];
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (String)NLS.bind((String)Messages.getString("DaemonRegistry_PURGE_LOCAL_STATUS"), (Object)daemonDir.getName()), (int)3);
                boolean shouldDelete = false;
                FilesystemLock daemonLock = new FilesystemLock(new File(daemonDir, LOCK_FILE_NAME));
                if (daemonLock.acquire((IProgressMonitor)subMonitor.newChild(1)).isOK()) {
                    try {
                        FilesystemLock live = new FilesystemLock(new File(daemonDir, ALIVELOCK_NAME));
                        if (live.acquire((IProgressMonitor)subMonitor.newChild(1)).isOK()) {
                            live.release((IProgressMonitor)monitor.newChild(1));
                            shouldDelete = true;
                        }
                    }
                    finally {
                        daemonLock.release((IProgressMonitor)subMonitor.newChild(1));
                        if (shouldDelete) {
                            DaemonRegistry.recursivelyDelete(daemonDir);
                        }
                        subMonitor.done();
                    }
                }
                ++n2;
            }
        }
        finally {
            registryLock.release((IProgressMonitor)monitor.newChild(1));
            monitor.done();
        }
    }

    /*
     * Loose catch block
     */
    private Collection<String> listSandboxesInternal(File daemonDir, SubMonitor monitor) {
        LinkedList<String> linkedList;
        BufferedReader r;
        block12: {
            String line;
            File sandboxList = new File(daemonDir, SANDBOX_LIST_NAME);
            r = null;
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sandboxList), ENCODING));
            LinkedList<String> toReturn = new LinkedList<String>();
            while ((line = r.readLine()) != null) {
                toReturn.add(line);
            }
            linkedList = toReturn;
            if (r == null) break block12;
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return linkedList;
        catch (IOException iOException) {
            Set<String> set;
            block13: {
                try {
                    set = Collections.emptySet();
                    if (r == null) break block13;
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    r.close();
                }
                catch (IOException iOException3) {}
            }
            return set;
        }
    }

    /*
     * Loose catch block
     */
    private Map<String, String> loadDaemonPropertiesInternal(File f, SubMonitor monitor) {
        HashMap<String, String> hashMap;
        FileInputStream in;
        block11: {
            HashMap<String, String> props = new HashMap<String, String>();
            in = null;
            in = new FileInputStream(new File(f, DESCRIPTION_NAME));
            PropertiesLoader.load(props, (InputStream)in, (String)ENCODING, (long)f.length(), (IProgressMonitor)monitor);
            hashMap = props;
            if (in == null) break block11;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return hashMap;
        catch (IOException iOException) {
            Map<String, String> map;
            block12: {
                try {
                    map = Collections.emptyMap();
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException3) {}
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilesystemLock acquireRegistryLock(File registryDir, SubMonitor monitor) {
        HashSet<DaemonRecord> hashSet = this.daemons;
        synchronized (hashSet) {
            FilesystemLock registryLock;
            block4: {
                registryLock = new FilesystemLock(new File(registryDir, LOCK_FILE_NAME));
                if (registryLock.acquire(20000L, (IProgressMonitor)monitor).isOK()) break block4;
                return null;
            }
            return registryLock;
        }
    }

    private static final void recursivelyDelete(File f) {
        if (f.delete() || !f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                DaemonRegistry.recursivelyDelete(child);
                ++n2;
            }
        }
        f.delete();
    }

    public static synchronized IDaemonRegistry getInstance() throws IOException {
        if (instance == null) {
            instance = new DaemonRegistry();
        }
        return instance;
    }

    private void runInDaemonContext(IFSDaemon daemon, DaemonRunnable daemonRunnable, IProgressMonitor progress) throws IllegalStateException, IDaemonRegistry.DaemonRegistryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        DaemonRecord rec = this.findRecordAndAcquire(daemon, 5000L, progress);
        if (rec == null) {
            throw new IDaemonRegistry.DaemonRegistryException("Can't run in context of unknown daemon");
        }
        try {
            daemonRunnable.run(daemon, rec.directory, (IProgressMonitor)monitor.newChild(3));
        }
        finally {
            rec.lock.release((IProgressMonitor)monitor.newChild(1));
        }
    }

    public void writeSandboxes(IFSDaemon daemon, final Collection<ISandbox> sandboxes, IProgressMonitor progress) throws IDaemonRegistry.DaemonRegistryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        this.purgeStaleDaemonsConditionally((IProgressMonitor)monitor.newChild(1));
        this.runInDaemonContext(daemon, new DaemonRunnable(){

            @Override
            public void run(IFSDaemon daemon, File daemonRoot, IProgressMonitor progress) throws IDaemonRegistry.DaemonRegistryException {
                File sandboxList = new File(daemonRoot, DaemonRegistry.SANDBOX_LIST_NAME);
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sandboxList, false), DaemonRegistry.ENCODING));
                    try {
                        for (ISandbox sb : sandboxes) {
                            writer.write(sb.getRoot().toOSString());
                            writer.newLine();
                        }
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new IDaemonRegistry.DaemonRegistryException(Messages.getString("DaemonRegistry_FAILED_TO_STORE_STANDBOX_LIST"), (Throwable)e);
                }
            }
        }, (IProgressMonitor)monitor.newChild(2));
        monitor.done();
    }

    public List<IDaemonRegistry.IRegistryEntry> findSandboxOwner(File pathToSandbox, IProgressMonitor progress) throws FileSystemException {
        return this.findSandboxOwners(Collections.singletonList(pathToSandbox), progress).get(0);
    }

    public List<List<IDaemonRegistry.IRegistryEntry>> findSandboxOwners(List<File> sandboxes, IProgressMonitor progress) throws FileSystemException {
        Collection<IDaemonRegistry.IRegistryEntry> daemons = this.listDaemons(progress);
        ArrayList<List<IDaemonRegistry.IRegistryEntry>> toReturn = new ArrayList<List<IDaemonRegistry.IRegistryEntry>>(sandboxes.size());
        for (File sandbox : sandboxes) {
            LinkedList<IDaemonRegistry.IRegistryEntry> owners = new LinkedList<IDaemonRegistry.IRegistryEntry>();
            toReturn.add(owners);
            for (IDaemonRegistry.IRegistryEntry entry : daemons) {
                IDaemonRegistry.IDaemonSandbox[] iDaemonSandboxArray = entry.getRegisteredSandboxes();
                int n = iDaemonSandboxArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDaemonRegistry.IDaemonSandbox owned = iDaemonSandboxArray[n2];
                    if (sandbox.equals(owned.getSandboxRoot())) {
                        owners.add(entry);
                    }
                    ++n2;
                }
            }
        }
        return toReturn;
    }

    public void setDescription(final IFSDaemon fsDaemon, final String description, IProgressMonitor progress) throws IDaemonRegistry.DaemonRegistryException {
        try {
            this.runInDaemonContext(fsDaemon, new DaemonRunnable(){

                @Override
                public void run(IFSDaemon daemon, File daemonRoot, IProgressMonitor progress) throws IDaemonRegistry.DaemonRegistryException {
                    FileOutputStream toClose = null;
                    BufferedWriter out = null;
                    try {
                        try {
                            toClose = new FileOutputStream(new File(daemonRoot, DaemonRegistry.DESCRIPTION_NAME));
                            out = new BufferedWriter(new OutputStreamWriter((OutputStream)toClose, DaemonRegistry.ENCODING));
                            out.write(DaemonRegistry.PROP_VERSION);
                            out.write(": 1");
                            out.newLine();
                            if (description != null) {
                                out.write(DaemonRegistry.PROP_DESCRIPTION);
                                out.write(": ");
                                out.write(description);
                                out.newLine();
                            }
                            out.write(DaemonRegistry.PROP_PORT);
                            out.write(": ");
                            out.write(Integer.toString(fsDaemon.getPort()));
                            out.newLine();
                            out.write(DaemonRegistry.PROP_KEY);
                            out.write(": ");
                            out.write(fsDaemon.getKey());
                            out.newLine();
                            out.newLine();
                            out.write(DaemonRegistry.PROP_PROCESS_UUID);
                            out.write(": ");
                            out.write(fsDaemon.getProcessUuid());
                            out.newLine();
                        }
                        catch (IOException e) {
                            throw new IDaemonRegistry.DaemonRegistryException(Messages.getString("DaemonRegistry_DESCRIPTION_WRITE_FAILURE"), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (out == null) {
                                if (toClose != null) {
                                    toClose.close();
                                }
                            } else {
                                out.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (out == null) {
                            if (toClose != null) {
                                toClose.close();
                            }
                        } else {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }, progress);
        }
        catch (IllegalStateException e) {
            throw new IDaemonRegistry.DaemonRegistryException(Messages.getString("DaemonRegistry_UPDATE_FAILURE"), (Throwable)e);
        }
        catch (FileSystemException e) {
            throw new IDaemonRegistry.DaemonRegistryException(Messages.getString("DaemonRegistry_UPDATE_FAILURE"), (Throwable)e);
        }
    }

    public File getRegistryLocation() {
        return this.registryLocation.getParentFile();
    }

    private static class DaemonRecord {
        public final FSDaemon daemon;
        public File directory;
        public FilesystemLock lock;
        public FilesystemLock aliveLock;
        private final SandboxClaimer sandboxClaimer;

        public DaemonRecord(FSDaemon daemon) {
            this.daemon = daemon;
            this.sandboxClaimer = new SandboxClaimer((IFSDaemon)daemon);
        }

        public boolean equals(Object o) {
            if (o instanceof DaemonRecord) {
                DaemonRecord other = (DaemonRecord)o;
                return this.daemon.equals(other.daemon);
            }
            return false;
        }

        public int hashCode() {
            return this.daemon.hashCode();
        }

        protected void startClaimer() {
            SharingManager.getInstance().addListener((ICopyFileAreaListener)this.sandboxClaimer);
            this.sandboxClaimer.storeKnownSandboxes();
        }

        protected void stopClaimer() {
            SharingManager.getInstance().removeListener((ICopyFileAreaListener)this.sandboxClaimer);
        }
    }

    private static abstract class DaemonRunnable {
        private DaemonRunnable() {
        }

        public abstract void run(IFSDaemon var1, File var2, IProgressMonitor var3) throws IDaemonRegistry.DaemonRegistryException;
    }
}

