/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DependencyHandler
implements IWorkItemListener {
    private final WorkItemClient fWorkItemClient;
    private final Worker fWorker;
    private final ConcurrentLinkedQueue<WorkItemChangeEvent> fEventQueue;

    public DependencyHandler(WorkItemClient workItemClient) {
        this.fWorkItemClient = workItemClient;
        this.fEventQueue = new ConcurrentLinkedQueue();
        this.fWorker = new Worker();
    }

    @Override
    public void workItemAttributeChanged(WorkItemChangeEvent event) {
    }

    @Override
    public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        this.fEventQueue.offer(event);
        this.fWorker.schedule();
    }

    private class Worker
    extends FoundationJob {
        public Worker() {
            super("DependencyHandler");
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            WorkItemChangeEvent event = (WorkItemChangeEvent)DependencyHandler.this.fEventQueue.poll();
            while (event != null) {
                IWorkItem workItem = event.getWorkItem();
                String[] stringArray = event.getAffectedDependents();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dependentAttributeId = stringArray[n2];
                    Identifier identifier = Identifier.create(IAttribute.class, (String)dependentAttributeId);
                    String internalIdentifier = WorkItemAttributes.getAttributeId((Identifier)identifier);
                    IAttribute attribute = DependencyHandler.this.fWorkItemClient.findAttribute(workItem.getProjectArea(), internalIdentifier, monitor);
                    if (attribute != null && workItem.isAttributeSet(attribute)) {
                        Object currentValue = attribute.getValue(DependencyHandler.this.fWorkItemClient.getAuditableCommon(), workItem, monitor);
                        event.getWorkItem().setValue(attribute, currentValue);
                    }
                    ++n2;
                }
                event = (WorkItemChangeEvent)DependencyHandler.this.fEventQueue.poll();
            }
            return Status.OK_STATUS;
        }
    }
}

