/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CMVersion1ResourceUpdater
extends ResourceUpdater {
    private static final String CM_LINK_URL_ID = "rdf:resource";
    private static final String CM_LINK_LABEL_ID = "oslc_cm:label";

    @Override
    protected ResourceUpdater.ResourceContent loadExistingContent(OSLCResource resource, Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions) throws TeamRepositoryException, UnsupportedVersionException {
        ResourceUpdater.ResourceContent result = new ResourceUpdater.ResourceContent(resource);
        JSONObject jsObj = null;
        try {
            jsObj = JSONObject.parse((Reader)new StringReader(resource.getContent()));
        }
        catch (IOException ex) {
            String message = MessageFormat.format(Messages.getString("CMVersion1ResourceUpdater_ERROR_PARSING_RESOURCE_JSON"), resource.getURL());
            throw new TeamRepositoryException(message, (Throwable)ex);
        }
        for (OSLCResourceDescription.ResourcePropertyDescription desc : propertyDescriptions) {
            String linkName = this.createLinkName(desc);
            Object jsLinksObj = jsObj.get((Object)linkName);
            if (jsLinksObj == null || !(jsLinksObj instanceof JSONArray)) {
                String message = MessageFormat.format(Messages.getString("CMVersion1ResourceUpdater_ERROR_NO_LINK_IN_RESOURCE"), linkName);
                throw new TeamRepositoryException(message);
            }
            List<ResourceUpdater.LinkProperty> parsedLinks = this.parseLinks(resource, desc, (JSONArray)jsLinksObj);
            result.putLinkProperties(desc, parsedLinks);
        }
        return result;
    }

    private List<ResourceUpdater.LinkProperty> parseLinks(OSLCResource resource, OSLCResourceDescription.ResourcePropertyDescription propertyDescription, JSONArray jsLinks) throws TeamRepositoryException {
        ArrayList<ResourceUpdater.LinkProperty> result = new ArrayList<ResourceUpdater.LinkProperty>();
        int idx = 0;
        while (idx < jsLinks.size()) {
            if (jsLinks.get(idx) instanceof JSONObject) {
                JSONObject curJsObj = (JSONObject)jsLinks.get(idx);
                Object curTarget = curJsObj.get((Object)CM_LINK_URL_ID);
                Object curLabel = curJsObj.get((Object)CM_LINK_LABEL_ID);
                if (curTarget instanceof String && curLabel instanceof String) {
                    result.add(new ResourceUpdater.LinkProperty(propertyDescription.getId(), (String)curTarget, (String)curLabel));
                } else {
                    throw new TeamRepositoryException(MessageFormat.format("CMVersion1ResourceUpdater_ERROR_PARSING_RESOURCE_JSON", resource.getURL()));
                }
            }
            ++idx;
        }
        return result;
    }

    @Override
    protected String evaluateLoadParameter(Set<OSLCResourceDescription.ResourcePropertyDescription> properties) {
        StringBuilder buf = new StringBuilder("oslc_cm.properties=");
        boolean isFirst = true;
        for (OSLCResourceDescription.ResourcePropertyDescription property : properties) {
            if (!isFirst) {
                buf.append(',');
            }
            buf.append(UriUtil.encode((String)this.createLinkName(property)));
            isFirst = false;
        }
        return buf.toString();
    }

    @Override
    protected String evaluateWriteParameter(Set<OSLCResourceDescription.ResourcePropertyDescription> properties) {
        return this.evaluateLoadParameter(properties);
    }

    private String createLinkName(OSLCResourceDescription.ResourcePropertyDescription property) {
        return String.format("%s:%s", property.getPreferredNamespacePrefix(), property.getProperty().getName());
    }

    @Override
    public String storeContent(ResourceUpdater.ResourceContent updatedLinks) throws TeamRepositoryException {
        JSONObject result = new JSONObject();
        for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<ResourceUpdater.LinkProperty>> entry : updatedLinks.getLinkPropertySet()) {
            JSONArray array = new JSONArray();
            for (ResourceUpdater.LinkProperty curLink : entry.getValue()) {
                JSONObject linkItem = new JSONObject();
                linkItem.put((Object)CM_LINK_URL_ID, (Object)curLink.getLinkUri());
                linkItem.put((Object)CM_LINK_LABEL_ID, (Object)curLink.getLinkComment());
                array.add((Object)linkItem);
            }
            result.put((Object)this.createLinkName(entry.getKey()), (Object)array);
        }
        return result.toString();
    }

    @Override
    protected void performWrite(OSLCResource resource, String newContent, Set<OSLCResourceDescription.ResourcePropertyDescription> changedParameters) throws TeamRepositoryException {
        try {
            super.performWrite(resource, newContent, changedParameters);
        }
        catch (IHttpClient.HttpAccessException e) {
            Reader reader = e.getResponse().getResponseReader();
            if (reader != null) {
                try {
                    JSONObject errorObject = JSONObject.parse((Reader)reader);
                    Object message = errorObject.get((Object)"message");
                    if (message instanceof String && ((String)message).length() > 0) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("CMVersion1ResourceUpdater_ERROR_WRITE_CM10"), (Object)this.getResourceURL(), (Object[])new Object[0]));
                    }
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }
}

