/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AbstractAttributesByTypeAndStateAdvisor;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.util.AttributesAdvisorHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.Collection;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequiredAttributesByTypeAndStateAdvisor
extends AbstractAttributesByTypeAndStateAdvisor {
    public static final String ADVISOR_ID = "com.ibm.team.workitem.advisor.requiredProperties";
    private static final String ADVISOR_INFO_ID = "requiredProperties";

    @Override
    protected void processAttributes(ISaveParameter saveParameter, IWorkItem workItem, Collection<String> attributeIds, IWorkItemCommon workItemCommon, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        for (String attributeId : attributeIds) {
            IAttribute attribute = workItemCommon.findAttribute(workItem.getProjectArea(), attributeId, monitor);
            if (attribute == null) continue;
            this.processAttribute(saveParameter, workItemCommon.getAuditableCommon(), workItem, attribute, collector, monitor);
        }
    }

    private void processAttribute(ISaveParameter saveParameter, IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem.isAttributeSet(attribute) && AttributesAdvisorHelper.equals(AttributesAdvisorHelper.getValue(workItem, attribute), attribute.getNullValue(auditableCommon, monitor))) {
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute), this.getDescription(workItem, attribute, userTimeZone), ADVISOR_ID);
            info.setProblemObject((Object)workItem.getItemHandle());
            info.setData(AttributesAdvisorHelper.createData(workItem, attribute, ADVISOR_INFO_ID));
            collector.addInfo((IReportInfo)info);
        }
    }

    private String getSummary(IAttribute attribute) {
        return NLS.bind((String)Messages.getString("RequiredAttributesByTypeAndStateAdvisor.ATTRIBUTE_NOT_SET_SUMMARY"), (Object)attribute.getDisplayName(), (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("RequiredAttributesByTypeAndStateAdvisor.ATTRIBUTE_NOT_SET_DESCRIPTION"), (Object)attribute.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone)});
    }
}

