/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;

public class EditableSortColumn
implements IAdaptable {
    private final IQueryableAttribute fAttribute;
    private Direction fDirection;
    private EditableStatement fStatement;

    public EditableSortColumn(IQueryableAttribute attribute, Direction direction) {
        this.fAttribute = attribute;
        this.fDirection = direction;
    }

    public void setDirection(Direction direction) {
        this.fDirection = direction;
        if (this.fStatement != null) {
            this.fStatement.notify(new StatementChangeEvent(this.fStatement, StatementChangeEvent.Type.SORT_COLUMNS_CHANGED_ORDER, Collections.singletonList(this)));
        }
    }

    public Direction getDirection() {
        return this.fDirection;
    }

    public IQueryableAttribute getAttribute() {
        return this.fAttribute;
    }

    void setStatement(EditableStatement statement) {
        this.fStatement = statement;
    }

    public Object getAdapter(Class adapter) {
        if (IQueryableAttribute.class.equals((Object)adapter)) {
            return this.getAttribute();
        }
        return null;
    }

    public static enum Direction {
        ASCENDING(true),
        DESCENDING(false);

        private boolean fAscending;

        private Direction(boolean ascending) {
            this.fAscending = ascending;
        }

        public boolean isAscending() {
            return this.fAscending;
        }
    }
}

