/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableLinkAttribute;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.expression.AbstractQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.expression.QueryableReferenceAttribute;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import java.util.Collections;
import java.util.List;

public class QueryableLinkAttribute
extends AbstractQueryableAttribute
implements IQueryableLinkAttribute {
    private static final String LINK_PREFIX = "link";
    private static final String ID_SOURCE = "source";
    private static final String ID_TARGET = "target";
    private final IEndPointDescriptor fEndPoint;
    private String fIdentifier;
    private final QueryableReferenceAttribute fReferenceAttribute;

    public static String createIdentifier(IEndPointDescriptor endPoint) {
        return String.format("%s:%s:%s", LINK_PREFIX, endPoint.getLinkType().getLinkTypeId(), endPoint.isSource() ? ID_SOURCE : ID_TARGET);
    }

    public static boolean isLinkAttributeIdentifier(String attributeIdentifier) {
        return attributeIdentifier.startsWith("link:");
    }

    public static boolean isSourceAttributeIdentifier(String attributeIdentifier) {
        String[] path = QueryableAttributePath.createPath(attributeIdentifier);
        return path[0].endsWith(":source");
    }

    public static boolean isLinkSource(IQueryableAttribute attribute) {
        return attribute instanceof QueryableLinkAttribute && QueryableLinkAttribute.isSourceAttributeIdentifier(attribute.getIdentifier());
    }

    public static String getLinkTypeId(String attributeIdentifier) {
        if (QueryableLinkAttribute.isLinkAttributeIdentifier(attributeIdentifier)) {
            String[] path = QueryableAttributePath.createPath(attributeIdentifier);
            String[] parts = path[0].split(":");
            if (parts.length != 3) {
                return null;
            }
            return parts[1];
        }
        return null;
    }

    public static IEndPointDescriptor getEndPointDescriptor(String attributeIdentifier) {
        String[] path = QueryableAttributePath.createPath(attributeIdentifier);
        String[] parts = path[0].split(":");
        if (parts.length != 3) {
            return null;
        }
        String linkTypeId = parts[1];
        String direction = parts[2];
        if (!LinkTypeRegistry.INSTANCE.isRegistered(linkTypeId)) {
            return null;
        }
        ILinkType linkType = LinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
        if (ID_SOURCE.equals(direction)) {
            return linkType.getSourceEndPointDescriptor();
        }
        return linkType.getTargetEndPointDescriptor();
    }

    public QueryableLinkAttribute(IEndPointDescriptor endPoint) {
        this.fEndPoint = endPoint;
        this.fReferenceAttribute = this.createReferenceAttribute();
    }

    private QueryableReferenceAttribute createReferenceAttribute() {
        QueryableReferenceAttribute referenceAttribute = this.fEndPoint.isSource() ? new QueryableReferenceAttribute(new QueryableAttributeDescriptor("sourceRef", "reference", "reference"), this.fEndPoint) : new QueryableReferenceAttribute(new QueryableAttributeDescriptor("targetRef", "reference", "reference"), this.fEndPoint);
        QueryableAttribute commentAttribute = new QueryableAttribute(new QueryableAttributeDescriptor("comment", "comment", "smallString"));
        referenceAttribute.setChildAttributes(Collections.singletonList(commentAttribute));
        return referenceAttribute;
    }

    @Override
    public IEndPointDescriptor getEndPointDescriptor() {
        return this.fEndPoint;
    }

    @Override
    public String getAttributeType() {
        return "reference";
    }

    @Override
    public String getDisplayName() {
        return this.fEndPoint.getDisplayName();
    }

    @Override
    public String getIdentifier() {
        if (this.fIdentifier == null) {
            this.fIdentifier = QueryableLinkAttribute.createIdentifier(this.fEndPoint);
        }
        return this.fIdentifier;
    }

    public ILinkType getLinkType() {
        return this.fEndPoint.getLinkType();
    }

    @Override
    public Object getNullValue() {
        return null;
    }

    @Override
    public List<? extends IAttributeVariable<?>> getVariables() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasNullValue() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public boolean isStateExtension() {
        return false;
    }

    public IQueryableAttribute getReferenceQueryableAttribute() {
        return this.fReferenceAttribute.getReferenceAttribute();
    }

    @Override
    public void setChildAttributes(List<IQueryableAttribute> childAttributes) {
        super.setChildAttributes(childAttributes);
    }
}

