/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import java.net.URL;

public class ConfigurationItem
implements ILiteral {
    private final IProjectAreaHandle fProjectArea;
    private final String fIdentifier;
    private final String fName;
    private final URL fIconURL;
    private final boolean fIsDefault;
    private final boolean fIsNull;
    private final int fSequenceValue;
    private final boolean fIsArchived;

    public ConfigurationItem(IProjectAreaHandle projectArea, String identifier, String name, URL iconURL, int sequenceValue) {
        this(projectArea, identifier, name, iconURL, sequenceValue, false, false, false);
    }

    public ConfigurationItem(IProjectAreaHandle projectArea, String identifier, String name, URL iconURL, int sequenceValue, boolean isArchived) {
        this(projectArea, identifier, name, iconURL, sequenceValue, false, false, isArchived);
    }

    public ConfigurationItem(IProjectAreaHandle projectArea, String identifier, String name, URL iconURL, int sequenceValue, boolean isDefault, boolean isNull) {
        this(projectArea, identifier, name, iconURL, sequenceValue, isDefault, isNull, false);
    }

    public ConfigurationItem(IProjectAreaHandle projectArea, String identifier, String name, URL iconURL, int sequenceValue, boolean isDefault, boolean isNull, boolean isArchived) {
        this.fProjectArea = AuditablesHelper.newItemHandle(projectArea, false);
        this.fIdentifier = identifier;
        this.fName = name;
        this.fIconURL = iconURL;
        this.fSequenceValue = sequenceValue;
        this.fIsDefault = isDefault;
        this.fIsNull = isNull;
        this.fIsArchived = isArchived;
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    @Override
    public Identifier<? extends ILiteral> getIdentifier2() {
        return Identifier.create(ILiteral.class, this.fIdentifier);
    }

    public String getDisplayName() {
        return this.fName;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public URL getIconURL() {
        return this.fIconURL;
    }

    public int getSequenceValue() {
        return this.fSequenceValue;
    }

    @Override
    public int compareTo(ILiteral o) {
        if (!(o instanceof ConfigurationItem)) {
            throw new IllegalArgumentException("Cannot compare literals of two different enumerations");
        }
        return this.fSequenceValue - ((ConfigurationItem)o).fSequenceValue;
    }

    public boolean isDefault() {
        return this.fIsDefault;
    }

    public boolean isNull() {
        return this.fIsNull;
    }

    public boolean isArchived() {
        return this.fIsArchived;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConfigurationItem)) {
            return false;
        }
        ConfigurationItem other = (ConfigurationItem)obj;
        return this.equals((IItemHandle)this.getProjectArea(), (IItemHandle)other.getProjectArea()) && this.getIdentifier().equals(other.getIdentifier());
    }

    private boolean equals(IItemHandle left, IItemHandle right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.sameItemId(right);
    }

    public int hashCode() {
        return 13 * this.hashCode((IItemHandle)this.getProjectArea()) + this.getIdentifier().hashCode();
    }

    private int hashCode(IItemHandle handle) {
        return handle != null ? handle.getItemId().hashCode() : 0;
    }
}

