/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.workitem.common.internal.workflow.StateGroup;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IStateGroup;
import com.ibm.team.workitem.common.workflow.StateResolutionPair;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

class StateGroupRegistry {
    private final Map<String, StateGroup> fStateGroups = new LinkedHashMap<String, StateGroup>();

    StateGroupRegistry() {
    }

    StateGroup getStateGroup(Identifier<IState> stateId, Identifier<IResolution> resolutionId, String workflowId) {
        Assert.isNotNull(stateId);
        StateResolutionPair pair = new StateResolutionPair(stateId, resolutionId, workflowId);
        for (StateGroup stateGroup : this.fStateGroups.values()) {
            if (!stateGroup.contains(pair)) continue;
            return stateGroup;
        }
        StateResolutionPair stateOnly = new StateResolutionPair(stateId, workflowId);
        for (StateGroup stateGroup : this.fStateGroups.values()) {
            if (!stateGroup.contains(stateOnly)) continue;
            return stateGroup;
        }
        return null;
    }

    StateGroup getStateGroupById(String groupId) {
        return this.fStateGroups.get(groupId);
    }

    StateGroup removeStateGroupById(String groupId) {
        return this.fStateGroups.remove(groupId);
    }

    void add(StateGroup stateGroup) {
        this.fStateGroups.put(stateGroup.getIdentifier(), stateGroup);
    }

    Map<String, IStateGroup> getStateGroups() {
        return new LinkedHashMap<String, IStateGroup>(this.fStateGroups);
    }

    void clearMappings() {
        for (StateGroup stateGroup : this.fStateGroups.values()) {
            stateGroup.clear();
        }
    }
}

