/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util;

import com.ibm.team.repository.common.internal.content.util.CachedDiskBackedHashMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class CachedDiskBackedHashSet<E>
extends AbstractSet<E> {
    private CachedDiskBackedHashMap<E, Object> map;
    private static final Object dummyObj = new Serializable(){
        static final long serialVersionUID = 2909668147172266147L;

        private Object readResolve() {
            return dummyObj;
        }
    };

    public CachedDiskBackedHashSet(int capacity, double loadFactor) {
        this.map = new CachedDiskBackedHashMap(capacity, loadFactor);
    }

    public CachedDiskBackedHashSet(int capacity) {
        this(capacity, 0.75);
    }

    public CachedDiskBackedHashSet(Collection<? extends E> c) {
        this(Math.max(c.size() * 2 + 1, 17));
        this.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, dummyObj) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            modified |= this.remove(i.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

