/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.reports.common.util;

import com.ibm.team.reports.common.internal.dto.BooleanValueDTO;
import com.ibm.team.reports.common.internal.dto.DoubleValueDTO;
import com.ibm.team.reports.common.internal.dto.DtoFactory;
import com.ibm.team.reports.common.internal.dto.FloatValueDTO;
import com.ibm.team.reports.common.internal.dto.IntegerValueDTO;
import com.ibm.team.reports.common.internal.dto.LongValueDTO;
import com.ibm.team.reports.common.internal.dto.NullValueDTO;
import com.ibm.team.reports.common.internal.dto.StringValueDTO;
import com.ibm.team.reports.common.internal.dto.TimestampValueDTO;
import com.ibm.team.reports.common.internal.dto.UUIDValueDTO;
import com.ibm.team.reports.common.internal.dto.ValueDTO;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;

public class Util {
    private static final int IO_BUFFER_SIZE = 4096;

    public static String trim(String val) {
        if (val == null) {
            return null;
        }
        if ((val = val.trim()).startsWith("'")) {
            val = val.substring(1);
        }
        if (val.endsWith("'")) {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    public static String[] tokenize(String val) {
        if (val == null) {
            return null;
        }
        if ((val = val.trim()).length() == 0) {
            return null;
        }
        if (!val.startsWith("'") || !val.endsWith("'")) {
            return new String[]{val};
        }
        if ((val = Util.trim(val)).length() == 0) {
            return null;
        }
        return val.split("','");
    }

    public static String decode(String val) {
        if (val == null) {
            return null;
        }
        return URI.decode((String)val);
    }

    public static String[] segments(String val) {
        if (val == null) {
            return null;
        }
        return val.split("/");
    }

    public static String[] tokenizeAndDecode(String val) {
        String[] vals = Util.tokenize(val);
        if (vals == null) {
            return null;
        }
        int i = 0;
        while (i < vals.length) {
            String v;
            vals[i] = v = Util.decode(vals[i]);
            ++i;
        }
        return vals;
    }

    public static String nameToId(String name) {
        String[] tokens = name.split(" ");
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            char c = token.charAt(0);
            if (Character.toUpperCase(c) != c) {
                c = Character.toUpperCase(c);
                token = String.valueOf(c) + token.substring(1);
            }
            buffer.append(token);
            ++n2;
        }
        return "report." + buffer.toString();
    }

    public static String[] lastSegments(String[] vals) {
        if (vals == null) {
            return null;
        }
        int i = 0;
        while (i < vals.length) {
            String v;
            String[] segments = Util.segments(vals[i]);
            vals[i] = v = segments[segments.length - 1];
            ++i;
        }
        return vals;
    }

    public static String getHash(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes("UTF-8"));
            return StringCoder.encode(md.digest());
        }
        catch (Exception exception) {
            return str;
        }
    }

    public static ValueDTO object2ValueDTO(Object object) {
        if (object == null) {
            return DtoFactory.eINSTANCE.createNullValueDTO();
        }
        if (object instanceof Integer) {
            IntegerValueDTO val = DtoFactory.eINSTANCE.createIntegerValueDTO();
            val.setValue((Integer)object);
            return val;
        }
        if (object instanceof String) {
            StringValueDTO val = DtoFactory.eINSTANCE.createStringValueDTO();
            val.setValue((String)object);
            return val;
        }
        if (object instanceof Boolean) {
            BooleanValueDTO val = DtoFactory.eINSTANCE.createBooleanValueDTO();
            val.setValue((Boolean)object);
            return val;
        }
        if (object instanceof Long) {
            LongValueDTO val = DtoFactory.eINSTANCE.createLongValueDTO();
            val.setValue((Long)object);
            return val;
        }
        if (object instanceof Double) {
            DoubleValueDTO val = DtoFactory.eINSTANCE.createDoubleValueDTO();
            val.setValue((Double)object);
            return val;
        }
        if (object instanceof Float) {
            FloatValueDTO val = DtoFactory.eINSTANCE.createFloatValueDTO();
            val.setValue(((Float)object).floatValue());
            return val;
        }
        if (object instanceof Timestamp) {
            TimestampValueDTO val = DtoFactory.eINSTANCE.createTimestampValueDTO();
            val.setValue((Timestamp)object);
            return val;
        }
        if (object instanceof UUID) {
            UUIDValueDTO val = DtoFactory.eINSTANCE.createUUIDValueDTO();
            val.setValue((UUID)object);
            return val;
        }
        throw new IllegalArgumentException();
    }

    public static Object valueDTO2Object(ValueDTO val) {
        if (val instanceof NullValueDTO) {
            return null;
        }
        if (val instanceof IntegerValueDTO) {
            return ((IntegerValueDTO)val).getValue();
        }
        if (val instanceof StringValueDTO) {
            return ((StringValueDTO)val).getValue();
        }
        if (val instanceof BooleanValueDTO) {
            return ((BooleanValueDTO)val).isValue();
        }
        if (val instanceof LongValueDTO) {
            return ((LongValueDTO)val).getValue();
        }
        if (val instanceof DoubleValueDTO) {
            return ((DoubleValueDTO)val).getValue();
        }
        if (val instanceof FloatValueDTO) {
            return Float.valueOf(((FloatValueDTO)val).getValue());
        }
        if (val instanceof TimestampValueDTO) {
            return ((TimestampValueDTO)val).getValue();
        }
        if (val instanceof UUIDValueDTO) {
            return ((UUIDValueDTO)val).getValue();
        }
        throw new IllegalArgumentException();
    }

    public static ValueDTO[] objects2ValueDTOs(Object[] objects) {
        ValueDTO[] vals = new ValueDTO[objects.length];
        int i = 0;
        while (i < objects.length) {
            vals[i] = Util.object2ValueDTO(objects[i]);
            ++i;
        }
        return vals;
    }

    public static Object[] valueDTOs2Objects(ValueDTO[] vals) {
        Object[] objects = new Object[vals.length];
        int i = 0;
        while (i < vals.length) {
            objects[i] = Util.valueDTO2Object(vals[i]);
            ++i;
        }
        return objects;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int read = in.read(buffer);
        while (read != -1) {
            out.write(buffer, 0, read);
            read = in.read(buffer);
        }
    }

    public static final String utf8Encode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static IPredicate inStringList(IStringField field, List<String> values) {
        int size = values.size();
        if (size < 1000) {
            return field._in(values.toArray(new String[size]));
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<String>(values){
            private Iterator<String> i;
            {
                this.i = list.iterator();
            }

            public String next() throws TeamRepositoryException {
                return this.i.next();
            }

            public boolean hasNext() throws TeamRepositoryException {
                return this.i.hasNext();
            }
        });
    }

    public static IPredicate inStringArray(IStringField field, final String[] values) {
        int size = values.length;
        if (size < 1000) {
            return field._in(values);
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<String>(){
            private int i = 0;

            public String next() throws TeamRepositoryException {
                String v = values[this.i];
                ++this.i;
                return v;
            }

            public boolean hasNext() throws TeamRepositoryException {
                while (this.i < values.length) {
                    if (values[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }
        });
    }

    public static IPredicate inUUIDList(IUUIDField field, List<UUID> values) {
        int size = values.size();
        if (size < 1000) {
            return field._in(values.toArray(new UUID[size]));
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(values){
            private Iterator<UUID> i;
            {
                this.i = list.iterator();
            }

            public UUID next() throws TeamRepositoryException {
                return this.i.next();
            }

            public boolean hasNext() throws TeamRepositoryException {
                return this.i.hasNext();
            }
        });
    }

    public static IPredicate inUUIDArray(IUUIDField field, final UUID[] values) {
        int size = values.length;
        if (size < 1000) {
            return field._in(values);
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(){
            private int i = 0;

            public UUID next() throws TeamRepositoryException {
                UUID v = values[this.i];
                ++this.i;
                return v;
            }

            public boolean hasNext() throws TeamRepositoryException {
                while (this.i < values.length) {
                    if (values[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }
        });
    }

    public static IPredicate inHandleList(IUUIDField field, List<IItemHandle> handles) {
        int size = handles.size();
        if (size < 1000) {
            UUID[] values = new UUID[handles.size()];
            int i = 0;
            for (IItemHandle h : handles) {
                values[i] = h.getItemId();
                ++i;
            }
            return field._in(values);
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(handles){
            private Iterator<IItemHandle> i;
            {
                this.i = list.iterator();
            }

            public UUID next() throws TeamRepositoryException {
                return this.i.next().getItemId();
            }

            public boolean hasNext() throws TeamRepositoryException {
                return this.i.hasNext();
            }
        });
    }

    public static IPredicate inHandleArray(IUUIDField field, final IItemHandle[] handles) {
        int size = handles.length;
        if (size < 1000) {
            UUID[] values = new UUID[handles.length];
            int i = 0;
            IItemHandle[] iItemHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                IItemHandle h = iItemHandleArray[n2];
                values[i] = h.getItemId();
                ++i;
                ++n2;
            }
            return field._in(values);
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(){
            private int i = 0;

            public UUID next() throws TeamRepositoryException {
                IItemHandle v = handles[this.i];
                ++this.i;
                return v.getItemId();
            }

            public boolean hasNext() throws TeamRepositoryException {
                while (this.i < handles.length) {
                    if (handles[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }
        });
    }

    public static IPredicate inHandleList(IUUIDField field, List<IItemHandle> handles, ISingleItemQueryModel model, IQuery query, List<Object> queryArgs) {
        int size = handles.size();
        if (size < 1000) {
            IItemHandleInputArg[] args = new IItemHandleInputArg[handles.size()];
            int i = 0;
            for (IItemHandle h : handles) {
                args[i] = query.newItemHandleArg();
                queryArgs.add(h);
                ++i;
            }
            return model._in(args);
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(handles){
            private Iterator<IItemHandle> i;
            {
                this.i = list.iterator();
            }

            public UUID next() throws TeamRepositoryException {
                return this.i.next().getItemId();
            }

            public boolean hasNext() throws TeamRepositoryException {
                return this.i.hasNext();
            }
        });
    }

    public static IPredicate inHandleArray(IUUIDField field, final IItemHandle[] handles, ISingleItemQueryModel model, IQuery query, List<Object> queryArgs) {
        int size = handles.length;
        if (size < 1000) {
            IItemHandleInputArg[] args = new IItemHandleInputArg[handles.length];
            int i = 0;
            IItemHandle[] iItemHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                IItemHandle h = iItemHandleArray[n2];
                args[i] = query.newItemHandleArg();
                queryArgs.add(h);
                ++i;
                ++n2;
            }
            return model._in(args);
        }
        return field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(){
            private int i = 0;

            public UUID next() throws TeamRepositoryException {
                IItemHandle v = handles[this.i];
                ++this.i;
                return v.getItemId();
            }

            public boolean hasNext() throws TeamRepositoryException {
                while (this.i < handles.length) {
                    if (handles[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }
        });
    }

    public static class StringCoder {
        static final char[] digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        static final int[] inverse_map = new int[128];

        static {
            Arrays.fill(inverse_map, -1);
            int i = digits.length;
            while (i != 0) {
                StringCoder.inverse_map[StringCoder.digits[--i]] = i;
            }
        }

        public static String encode(byte[] data) {
            int j;
            if (data == null) {
                throw new IllegalArgumentException();
            }
            int sourceChunks = data.length / 3;
            int len = (data.length * 4 + 2) / 3;
            char[] result = new char[len];
            int dataIndex = 0;
            int resultIndex = 0;
            int allBits = 0;
            int i = 0;
            while (i < sourceChunks) {
                allBits = 0;
                j = 3;
                while (j != 0) {
                    allBits = allBits << 8 | data[dataIndex++] & 0xFF;
                    --j;
                }
                j = resultIndex + 3;
                while (j >= resultIndex) {
                    result[j] = digits[allBits & 0x3F];
                    allBits >>>= 6;
                    --j;
                }
                resultIndex += 4;
                ++i;
            }
            int extraBytes = data.length - dataIndex;
            switch (extraBytes) {
                case 1: {
                    allBits = data[dataIndex++];
                    allBits <<= 4;
                    j = resultIndex + 1;
                    while (j >= resultIndex) {
                        result[j] = digits[allBits & 0x3F];
                        allBits >>>= 6;
                        --j;
                    }
                    break;
                }
                case 2: {
                    allBits = data[dataIndex++];
                    allBits = allBits << 8 | data[dataIndex++] & 0xFF;
                    allBits <<= 2;
                    j = resultIndex + 2;
                    while (j >= resultIndex) {
                        result[j] = digits[allBits & 0x3F];
                        allBits >>>= 6;
                        --j;
                    }
                    break;
                }
            }
            return new String(result);
        }

        public static boolean isValidCode(String code) {
            if (code == null) {
                throw new IllegalArgumentException();
            }
            char[] chars = code.toCharArray();
            int max = inverse_map.length;
            int len = chars.length;
            int extra_chars = len % 4;
            int checked_chars = 0;
            switch (extra_chars) {
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    char c = chars[len - 1];
                    if (c >= max) {
                        return false;
                    }
                    int inverse_value = inverse_map[c];
                    if ((inverse_value & 0xF) != 0) {
                        return false;
                    }
                    checked_chars = 1;
                    break;
                }
                case 3: {
                    char c = chars[len - 1];
                    if (c >= max) {
                        return false;
                    }
                    int inverse_value = inverse_map[c];
                    if ((inverse_value & 3) != 0) {
                        return false;
                    }
                    checked_chars = 1;
                }
            }
            int i = len - checked_chars;
            while (i != 0) {
                char c;
                if ((c = chars[--i]) >= max) {
                    return false;
                }
                if (inverse_map[c] != -1) continue;
                return false;
            }
            return true;
        }

        public static byte[] decode(String code) {
            byte[] result;
            if (code == null) {
                throw new IllegalArgumentException();
            }
            char[] chars = code.toCharArray();
            int MAX_VALUE = inverse_map.length;
            int len = chars.length;
            int extra_chars = len % 4;
            int decoded_len = (len - extra_chars) / 4 * 3;
            switch (extra_chars) {
                case 0: {
                    result = new byte[decoded_len];
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException();
                }
                case 2: {
                    ++decoded_len;
                    char c1 = chars[len - 2];
                    char c2 = chars[len - 1];
                    if (c1 >= MAX_VALUE || c2 >= MAX_VALUE) {
                        throw new IllegalArgumentException();
                    }
                    int v1 = inverse_map[c1];
                    int v2 = inverse_map[c2];
                    if (v1 == -1) {
                        throw new IllegalArgumentException();
                    }
                    int inverse_value = v1 << 6 | v2;
                    if ((inverse_value & 0xF) != 0) {
                        throw new IllegalArgumentException();
                    }
                    result = new byte[decoded_len];
                    result[decoded_len - 1] = (byte)(inverse_value >>= 4);
                    break;
                }
                case 3: {
                    decoded_len += 2;
                    char c1 = chars[len - 3];
                    char c2 = chars[len - 2];
                    char c3 = chars[len - 1];
                    if (c1 >= MAX_VALUE || c2 >= MAX_VALUE || c3 >= MAX_VALUE) {
                        throw new IllegalArgumentException();
                    }
                    int v1 = inverse_map[c1];
                    int v2 = inverse_map[c2];
                    int v3 = inverse_map[c3];
                    if (v1 == -1 || v2 == -1) {
                        throw new IllegalArgumentException();
                    }
                    int inverse_value = v1 << 12 | v2 << 6 | v3;
                    if ((inverse_value & 3) != 0) {
                        throw new IllegalArgumentException();
                    }
                    result = new byte[decoded_len];
                    result[decoded_len - 1] = (byte)(inverse_value >>= 2);
                    result[decoded_len - 2] = (byte)(inverse_value >>= 8);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            int top = len - extra_chars;
            int j = -4;
            int i = 0;
            while (i < top) {
                int inverse_value = 0;
                int k = 4;
                while (k != 0) {
                    char c = chars[i];
                    ++i;
                    if (c >= MAX_VALUE) {
                        throw new IllegalArgumentException();
                    }
                    int v = inverse_map[c];
                    if (v == -1) {
                        throw new IllegalArgumentException();
                    }
                    inverse_value = inverse_value << 6 | v;
                    --k;
                }
                j += 6;
                k = 3;
                while (k != 0) {
                    result[j] = (byte)inverse_value;
                    inverse_value >>= 8;
                    --j;
                    --k;
                }
            }
            return result;
        }
    }
}

