/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;

public final class ParmsLoadVersionable
implements IParameterWrapper {
    public String sandboxPath;
    public String relativeLoadPath;
    public String alternativeName;
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String versionableItemType;
    public String versionableItemId;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.sandboxPath, requestName, parameterName, "sandboxPath");
        this.sandboxPath = ParmValidation.validCanonicalPath(this.sandboxPath, requestName, parameterName, "sandboxPath");
        if (this.relativeLoadPath != null && this.relativeLoadPath.trim().length() > 0) {
            this.relativeLoadPath = ParmValidation.validRelativeCanonicalPath(this.sandboxPath, this.relativeLoadPath, requestName, parameterName, "relativeLoadPath");
        }
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        ParmValidation.requiredValue(this.componentItemId, requestName, parameterName, "componentItemId");
        ParmValidation.requiredValue(this.versionableItemType, requestName, parameterName, "versionableItemType");
        ParmValidation.inEnum(this.versionableItemType, requestName, new String[]{"file", "folder", "symbolic_link"}, parameterName, "versionableItemType");
        ParmValidation.requiredValue(this.versionableItemId, requestName, parameterName, "versionableItemId");
        if (this.relativeLoadPath == null) {
            this.relativeLoadPath = "";
        }
        if (this.alternativeName == null) {
            this.alternativeName = "";
        }
    }

    public IVersionableHandle getVersionableHandle() throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        if ("folder".equals(this.versionableItemType)) {
            return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.versionableItemId), null);
        }
        if ("file".equals(this.versionableItemType)) {
            return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.versionableItemId), null);
        }
        if ("symbolic_link".equals(this.versionableItemType)) {
            return (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.versionableItemId), null);
        }
        throw new IllegalArgumentException("Invalid versionableItemType value : " + this.versionableItemType);
    }

    public IComponentHandle getComponentHandle() throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }
}

