/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;

public final class ParmsVersionable
implements IParameterWrapper {
    public String itemId;
    public String versionableItemType;

    public ParmsVersionable() {
    }

    public ParmsVersionable(IVersionableHandle versionable) {
        this.itemId = versionable.getItemId().getUuidValue();
        if (versionable instanceof IFileItemHandle) {
            this.versionableItemType = "file";
        } else if (versionable instanceof IFolderHandle) {
            this.versionableItemType = "folder";
        } else if (versionable instanceof ISymbolicLinkHandle) {
            this.versionableItemType = "symbolic_link";
        } else {
            throw new IllegalArgumentException("Unsupported versionable " + versionable.getItemType().getName());
        }
    }

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.itemId, requestName, parameterName, "itemId");
        ParmValidation.requiredValue(this.versionableItemType, requestName, parameterName, "file");
        ParmValidation.inEnum(this.versionableItemType, requestName, new String[]{"file", "folder", "symbolic_link"}, parameterName, "file");
    }

    public IVersionableHandle getVersionableHandle(ITeamRepository repo) throws TeamRepositoryException {
        if ("file".equals(this.versionableItemType)) {
            return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
        }
        if ("folder".equals(this.versionableItemType)) {
            return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
        }
        return (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
    }
}

