/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.Messages;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.internal.FoundationCommonPlugin;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class TextLinkDetectorManager {
    private static final String EXTENSION_POINT = "com.ibm.team.foundation.common.textLinkDetectors";
    private static final String ELEMENT_NAME = "textLinkDetector";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static TextLinkDetectorManager fgInstance;

    private TextLinkDetectorManager() {
    }

    public static TextLinkDetectorManager getDefault() {
        if (fgInstance == null) {
            fgInstance = new TextLinkDetectorManager();
        }
        return fgInstance;
    }

    public LinkDetector createLinkDetector() {
        return this.createLinkDetector(false);
    }

    public LinkDetector createLinkDetector(boolean isServer) {
        LinkDetector ld = new LinkDetector();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (ELEMENT_NAME.equals(element.getName())) {
                try {
                    Object linkDetector = element.createExecutableExtension(CLASS_ATTRIBUTE);
                    if (linkDetector instanceof TextLinkDetector) {
                        if (linkDetector instanceof IServerSensitiveLinkDetector) {
                            ((IServerSensitiveLinkDetector)linkDetector).setIsServer(isServer);
                        }
                        ld.addTextLinkDetector((TextLinkDetector)linkDetector);
                    }
                }
                catch (CoreException e) {
                    FoundationCommonPlugin.log(NLS.bind((String)Messages.getString("TextLinkDetectorManager.ERROR_INSTANTIATE_DETECTOR"), (Object)element.getAttribute(NAME_ATTRIBUTE), (Object[])new Object[0]), (Exception)((Object)e));
                }
            }
            ++i;
        }
        return ld;
    }

    public static interface IServerSensitiveLinkDetector {
        public void setIsServer(boolean var1);
    }
}

