/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public final class SharingMetaMetaDataProperties {
    private static final int METADATA_VERSION = 0;
    private static final String LAST_SANDBOX_LISTENER_EVENT = "lastSandboxListenerEvent";
    private PersistentDiskBackedHashMap<String, String> backingMap;

    public SharingMetaMetaDataProperties(File file) {
        this.backingMap = new PersistentDiskBackedHashMap<String, String>(file){

            protected void writeCustomMetadata(DataOutputStream out) throws IOException {
                super.writeCustomMetadata(out);
                out.writeInt(0);
            }

            protected void readCustomMetadata(DataInputStream in) throws IOException {
                super.readCustomMetadata(in);
                int v = in.readInt();
                if (v != 0) {
                    throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 0);
                }
            }
        };
    }

    public Date getLastSandboxListenerEvent() {
        String value = (String)this.backingMap.get((Object)LAST_SANDBOX_LISTENER_EVENT);
        if (value == null) {
            return new Date(0L);
        }
        long time = Long.parseLong(value);
        return new Date(time);
    }

    public void markSandboxListenerEvent(Date date) {
        this.backingMap.put((Object)LAST_SANDBOX_LISTENER_EVENT, (Object)Long.toString(date.getTime()));
    }

    public PersistentDiskBackedHashMap<?, ?> getMapToPersist() {
        return this.backingMap;
    }
}

