/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.core;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractSharingMetadata;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractSharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.ValidateMetadataOperation;
import com.ibm.team.filesystem.client.internal.core.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.operations.RebuildCFAOperation;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.IMetadataValidateOperation;
import com.ibm.team.filesystem.client.operations.MetadataRepairDilemmaHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class SharingMetadataFactory
extends AbstractSharingMetadataFactory {
    protected static final String SCM_PRIVATE = ".jazz5";
    private static final String INTERUM_METADATA_FOLDER = ".jazz4";
    private static final String OLD_METADATA_FOLDER_NAME = ".jazz3";
    public static final String[] SUPPORTED_METADATA_FOLDERS = new String[]{".jazz5", ".jazz4", ".jazz3"};

    @Override
    public AbstractSharingMetadata getSharingMetadata(ILocation root) throws FileSystemException {
        if (root.getStorageId().equals("com.ibm.team.filesystem.hfs")) {
            IPath cfaRoot = (IPath)root.getAdapter(IPath.class);
            boolean isCaseSensitive = !cfaRoot.append("a").toFile().equals(cfaRoot.append("A").toFile());
            return new SharingMetadata2(root, isCaseSensitive, SharingMetadataFactory.getMetadataRoot(root));
        }
        throw new IllegalStateException("Missing a registered sharing metadata manager that supports storage type " + root.getStorageId());
    }

    public static ILocation getMetadataRoot(ILocation root) {
        return root.append(SCM_PRIVATE);
    }

    private List<ILocation> getAllSupportedSharingMetadataRoots(ILocation root) {
        ArrayList<ILocation> allPossibleRoots = new ArrayList<ILocation>(3);
        String[] stringArray = SUPPORTED_METADATA_FOLDERS;
        int n = SUPPORTED_METADATA_FOLDERS.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            allPossibleRoots.add(root.append(folderName));
            ++n2;
        }
        return allPossibleRoots;
    }

    @Override
    public boolean hasOldSharingMetadata(ILocation root) {
        ILocation path = root.getCanonicalForm().append(OLD_METADATA_FOLDER_NAME);
        File file = (File)path.getAdapter(File.class);
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public static ILocation getOldMetadataPathForRoot(ILocation root) {
        return root.getCanonicalForm().append(OLD_METADATA_FOLDER_NAME);
    }

    @Override
    public boolean hasInterumSharingMetadata(ILocation root) {
        ILocation path = root.getCanonicalForm().append(INTERUM_METADATA_FOLDER);
        File file = (File)path.getAdapter(File.class);
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public static ILocation getInterimMetadataPathForRoot(ILocation root) {
        return root.getCanonicalForm().append(INTERUM_METADATA_FOLDER);
    }

    @Override
    public boolean hasAnySharingMetadata(ILocation root) {
        for (ILocation metadataLocation : this.getAllSupportedSharingMetadataRoots(root)) {
            File file = (File)metadataLocation.getAdapter(File.class);
            if (file == null) continue;
            return file.exists();
        }
        return false;
    }

    @Override
    public boolean hasSharingMetadata(ILocation root) {
        File file = (File)SharingMetadataFactory.getMetadataRoot(root).getAdapter(File.class);
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    @Override
    public IMetadataRepairOperation getMetadataRepairOperation(ILocation root, MetadataRepairDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        if (!root.getStorageId().equals("com.ibm.team.filesystem.hfs")) {
            throw new IllegalStateException("Unsupported Storage type: " + root.getStorageId() + " for copy file area: " + root.toOSString());
        }
        ILocation metadataRoot = this.hasOldSharingMetadata(root) ? SharingMetadataFactory.getOldMetadataPathForRoot(root) : (this.hasInterumSharingMetadata(root) ? SharingMetadataFactory.getInterimMetadataPathForRoot(root) : SharingMetadataFactory.getMetadataRoot(root));
        return new RebuildCFAOperation(root, metadataRoot, dilemmaHandler, resolver);
    }

    @Override
    public IMetadataValidateOperation getMetadataValidateOperation(ILocation root) {
        if (!root.getStorageId().equals("com.ibm.team.filesystem.hfs")) {
            throw new IllegalStateException("Unsupported Storage type: " + root.getStorageId() + " for copy file area: " + root.toOSString());
        }
        if (this.hasOldSharingMetadata(root) || this.hasInterumSharingMetadata(root)) {
            throw new IllegalStateException("Unsupported metadata for root : " + root + " for validation");
        }
        ILocation metadataRoot = SharingMetadataFactory.getMetadataRoot(root);
        return new ValidateMetadataOperation(root, metadataRoot);
    }
}

