/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.ConflictInfo;
import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractContext
implements IItemContext {
    private ItemNamespace namespace;

    public AbstractContext(ItemNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public final ITeamRepository getRepository() {
        return this.namespace.getRepository();
    }

    @Override
    public EraDescriptor getChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    @Override
    public final ItemNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public IConfigurationWrapper getVersionableTree() {
        return null;
    }

    @Override
    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(Collection<ItemId<T>> itemIds, FetchProfile profile, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<ItemId<T>, StateId<T>> states = this.getStates(itemIds, shouldRefresh, (IProgressMonitor)mon.newChild(70));
        Map items = RepoFetcher.fetchItems((ITeamRepository)this.getRepository(), states.values(), (FetchProfile)profile, (IProgressMonitor)mon.newChild(30));
        HashMap result = NewCollection.hashMap();
        for (Map.Entry<ItemId<T>, StateId<T>> next : states.entrySet()) {
            IItem item = (IItem)items.get(next.getValue());
            if (item == null) continue;
            result.put(next.getKey(), item);
        }
        return result;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        EraCache.getDefault().flush();
    }

    @Override
    public void addHistoryListener(IChangeListener toAdd) {
    }

    @Override
    public void removeHistoryListener(IChangeListener toRemove) {
    }

    @Override
    public abstract <T extends IItem> Map<ItemId<T>, StateId<T>> getStates(Collection<ItemId<T>> var1, boolean var2, IProgressMonitor var3) throws TeamRepositoryException;

    @Override
    public ConflictInfo getConflictInfo(ItemId<?> item) throws TeamRepositoryException {
        return null;
    }
}

