/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LockAndLoadFileVisitor;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator2;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.ReplaceDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ReplaceWithRepositoryOperation
extends FileSystemOperation {
    public static final int DEPTH_INFINITY = -1;
    private final Collection<IShareable> shareablesToReplace;
    private final int depth;
    private ReplaceDilemmaHandler problemHandler;
    private final IRepositoryResolver resolver;

    public ReplaceWithRepositoryOperation(Collection<IShareable> shareablesToReplace, IRepositoryResolver resolver, int depth, ReplaceDilemmaHandler problemHandler) {
        super(problemHandler == null ? ReplaceDilemmaHandler.getDefault() : problemHandler);
        ReplaceDilemmaHandler replaceDilemmaHandler = this.problemHandler = problemHandler == null ? ReplaceDilemmaHandler.getDefault() : problemHandler;
        if (shareablesToReplace == null) {
            throw new IllegalArgumentException("shareables must not be null");
        }
        if (depth < 0 && depth != -1) {
            throw new IllegalArgumentException("depth must be greater than 0");
        }
        this.shareablesToReplace = shareablesToReplace;
        this.resolver = resolver;
        this.depth = depth;
    }

    @Override
    protected void execute(IProgressMonitor reporter) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
        final HashMap<ITeamRepository, Map<ConfigurationFacade, List<IShareable>>> toReload = new HashMap<ITeamRepository, Map<ConfigurationFacade, List<IShareable>>>();
        final ArrayList<IShareable> toDelete = new ArrayList<IShareable>();
        HashSet<RepoIdConnectionComponentTriple> affectedConfigurations = new HashSet<RepoIdConnectionComponentTriple>();
        final HashMap<ISandbox, Set<RepoIdConnectionComponentTriple>> affectedSandboxes = new HashMap<ISandbox, Set<RepoIdConnectionComponentTriple>>();
        this.getConfigurationsAffected(affectedConfigurations, affectedSandboxes, toReload, toDelete, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
                        ICopyFileAreaManager.ICopyFileAreaLockRequestFactory lockFactory = cfaManager.lockRequestFactory();
                        ArrayList<ICopyFileAreaLockRequest> lockRequests = new ArrayList<ICopyFileAreaLockRequest>();
                        for (Map.Entry entry : affectedSandboxes.entrySet()) {
                            ISandbox sandbox = (ISandbox)entry.getKey();
                            Set configurationsToLock = (Set)entry.getValue();
                            lockRequests.add(lockFactory.getLockRequest(sandbox.getRoot(), configurationsToLock, false));
                        }
                        ICopyFileAreasLock cfaLock = cfaManager.lock(lockRequests, (IProgressMonitor)progress.newChild(1));
                        try {
                            ReplaceWithRepositoryOperation.this.replace(toReload, toDelete, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(workspaceOp, Messages.ReplaceWithRepositoryOperation_0, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void getConfigurationsAffected(Set<RepoIdConnectionComponentTriple> affectedConfigurations, Map<ISandbox, Set<RepoIdConnectionComponentTriple>> affectedSandboxes, Map<ITeamRepository, Map<ConfigurationFacade, List<IShareable>>> toReload, List<IShareable> toDelete, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.shareablesToReplace.size() * 2));
        for (IShareable shareable : this.shareablesToReplace) {
            boolean needsToBeLoaded = false;
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (share != null) {
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                RepoIdConnectionComponentTriple configurationDescriptor = new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponent());
                affectedConfigurations.add(configurationDescriptor);
                Set<RepoIdConnectionComponentTriple> configurations = affectedSandboxes.get(shareable.getSandbox());
                if (configurations == null) {
                    configurations = new HashSet<RepoIdConnectionComponentTriple>();
                    affectedSandboxes.put(shareable.getSandbox(), configurations);
                }
                configurations.add(configurationDescriptor);
                IVersionableHandle remoteHandle = shareable.getRemote((IProgressMonitor)monitor.newChild(1));
                if (remoteHandle != null) {
                    List<IShareable> shareables;
                    ITeamRepository repo;
                    try {
                        repo = this.resolver.getRepoFor(null, descriptor.getRepositoryId());
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        throw new FileSystemException(NLS.bind((String)Messages.ReplaceWithRepositoryOperation_1, (Object)shareable.getLocalPath(), (Object[])new Object[]{descriptor.getConnectionName()}));
                    }
                    needsToBeLoaded = true;
                    Map<ConfigurationFacade, List<IShareable>> toReloadByRepo = toReload.get(repo);
                    ConfigurationFacade configuration = new ConfigurationFacade(repo, descriptor.getConnectionHandle(), descriptor.getComponent());
                    if (toReloadByRepo == null) {
                        toReloadByRepo = new HashMap<ConfigurationFacade, List<IShareable>>();
                        toReload.put(repo, toReloadByRepo);
                    }
                    if ((shareables = toReloadByRepo.get((Object)configuration)) == null) {
                        shareables = new ArrayList<IShareable>();
                        toReloadByRepo.put(configuration, shareables);
                    }
                    shareables.add(shareable);
                }
            }
            if (needsToBeLoaded) continue;
            toDelete.add(shareable);
        }
    }

    protected void replace(Map<ITeamRepository, Map<ConfigurationFacade, List<IShareable>>> toReload, List<IShareable> toDelete, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        monitor.subTask(Messages.ReplaceWithRepositoryOperation_ProgressMessage);
        int numShareables = this.shareablesToReplace.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(numShareables * 10 + 10));
        int processed = 0;
        HashSet<UUID> ids = new HashSet<UUID>();
        ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>();
        LockAndLoadFileVisitor loadedFileVisitor = new LockAndLoadFileVisitor();
        for (Map.Entry<ITeamRepository, Map<ConfigurationFacade, List<IShareable>>> toReloadEntry : toReload.entrySet()) {
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler);
            ITeamRepository repo = toReloadEntry.getKey();
            Map<ConfigurationFacade, List<IShareable>> toReloadByRepo = toReloadEntry.getValue();
            Iterator<Map.Entry<ConfigurationFacade, List<IShareable>>> iToReloadByRepo = toReloadByRepo.entrySet().iterator();
            while (iToReloadByRepo.hasNext()) {
                IShare share;
                Object shareable;
                Map.Entry<ConfigurationFacade, List<IShareable>> entry = iToReloadByRepo.next();
                ConfigurationFacade configuration = entry.getKey();
                List<IShareable> shareables = entry.getValue();
                IConnection connection = configuration.getConnection((IProgressMonitor)progress.newChild(1));
                if (connection == null) {
                    IStatus status = null;
                    shareable = (IShareable)shareables.get(0);
                    if (shareable != null && (share = shareable.getShare((IProgressMonitor)progress.newChild(1))) != null) {
                        String workspaceNameHint = share.getSharingDescriptor().getConnectionName();
                        status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ReplaceWithRepositoryOperation_2, (Object)shareables.size(), (Object[])new Object[]{workspaceNameHint}));
                    }
                    if (status == null) {
                        status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ReplaceWithRepositoryOperation_3, (Object)shareables.size(), (Object[])new Object[0]));
                    }
                    this.collectStatus(status);
                    iToReloadByRepo.remove();
                    continue;
                }
                shareable = shareables.iterator();
                while (shareable.hasNext()) {
                    IShareable shareable2 = (IShareable)shareable.next();
                    share = shareable2.getShare((IProgressMonitor)progress.newChild(1));
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    verifyOp.addToVerify(connection, share);
                    if (!ids.add(descriptor.getComponent().getItemId())) continue;
                    componentsToRetrieve.add(descriptor.getComponent());
                }
            }
            HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
            if (!componentsToRetrieve.isEmpty()) {
                List componentsRetrieved = repo.itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)progress.newChild(10));
                for (IComponent component : componentsRetrieved) {
                    components.put(component.getItemId(), component);
                }
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!toReloadByRepo.isEmpty() && this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
                verifyOp.run((IProgressMonitor)progress.newChild(1));
            }
            if (toReloadByRepo.isEmpty()) continue;
            FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
            int retrievalDepth = this.depth == -1 ? -1 : this.depth;
            block10: for (Map.Entry<ConfigurationFacade, List<IShareable>> entry : toReloadByRepo.entrySet()) {
                IConnection connection = entry.getKey().getConnection((IProgressMonitor)progress.newChild(1));
                List<IShareable> shareables = entry.getValue();
                for (IShareable shareable : shareables) {
                    LoadFilter loadFilter;
                    String name;
                    SubMonitor iterationProgress = progress.newChild(5);
                    iterationProgress.setWorkRemaining(100);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.setTaskName(NLS.bind((String)Messages.ReplaceWithRepositoryOperation_ProgressSubTaskMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{++processed, numShareables}));
                    IShare share = shareable.getShare((IProgressMonitor)iterationProgress.newChild(1));
                    IComponentHandle componentHandle = share.getSharingDescriptor().getComponent();
                    IComponent component = (IComponent)components.get(componentHandle.getItemId());
                    IVersionableHandle remote = shareable.getRemote((IProgressMonitor)iterationProgress.newChild(1));
                    LoadTree loadTree = fileSystemService.getFileTreeByVersionable(connection, (IComponentHandle)component, new IVersionableHandle[]{remote}, retrievalDepth, true, null, (IProgressMonitor)iterationProgress.newChild(50));
                    if (!loadTree.getInaccessible().getRequests().isEmpty()) {
                        toDelete.add(shareable);
                    }
                    if (loadTree.getFileAreaUpdates().isEmpty()) continue;
                    boolean isLoadWithAnotherName = false;
                    if (shareable.isShare((IProgressMonitor)iterationProgress.newChild(1)) && share.isLoadedWithAnotherName((IProgressMonitor)iterationProgress.newChild(1))) {
                        isLoadWithAnotherName = true;
                    }
                    LoadLocation loadLocation = null;
                    IRelativeLocation location = shareable.getLocalPath().removeLastSegments(1);
                    if (LoadFilter.include(location, name = shareable.getLocalPath().getName())) {
                        loadLocation = new LoadLocation(shareable.getSandbox(), location, name, connection, component, remote, isLoadWithAnotherName);
                    }
                    if (loadLocation == null) continue;
                    HashSet<LoadLocation> itemToLoad = new HashSet<LoadLocation>();
                    itemToLoad.add(loadLocation);
                    ILoadMutator mutator = SharingManager.getInstance().getLoadMutator(loadLocation.getSandbox(), this.problemHandler);
                    try {
                        loadFilter = LoadFilter.getFilter(share.getSharingDescriptor());
                    }
                    catch (IOException iOException) {
                        loadFilter = null;
                    }
                    mutator.configureLoad(4, connection, component, Collections.singletonList(loadLocation), loadTree, null, loadFilter);
                    if (mutator instanceof ILoadMutator2) {
                        ILoadMutator2 lm2 = (ILoadMutator2)mutator;
                        lm2.setLoadedFileVisitor(loadedFileVisitor);
                    }
                    try {
                        try {
                            SharingManager.getInstance().disableChangeMonitoring();
                            mutator.run((IProgressMonitor)iterationProgress.newChild(45));
                        }
                        catch (FileSystemException e) {
                            IStatus status = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                            this.collectStatus(status);
                            if (status.getSeverity() == 4) {
                                SharingManager.getInstance().enableChangeMonitoring();
                                continue block10;
                            }
                            SharingManager.getInstance().enableChangeMonitoring();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        SharingManager.getInstance().enableChangeMonitoring();
                        throw throwable;
                    }
                    SharingManager.getInstance().enableChangeMonitoring();
                }
            }
        }
        if (!toDelete.isEmpty()) {
            Shed shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
            for (IShareable shareable : toDelete) {
                SubMonitor iterationProgress = progress.newChild(10);
                iterationProgress.setWorkRemaining(100);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IFileStorage storage = ((Shareable)shareable).getFileStorage();
                if (shareable.exists((IProgressMonitor)iterationProgress.newChild(1))) {
                    storage.delete(shed, (IProgressMonitor)iterationProgress.newChild(75));
                }
                ((Shareable)shareable).forget((IProgressMonitor)iterationProgress.newChild(24));
            }
        }
    }
}

