/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateSnapshotDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.ICreateSnapshotOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSetCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSetGetCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSetDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselineSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselinesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.BaselineCustomAttributesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineSetResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class BaselineUtil {
    public static CreateBaselineResultDTO createBaselines(ParmsCreateBaselines parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CreateBaselineResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createCreateBaselineResultDTO();
        CreateBaselineDilemmaHandler dilemmaHandler = BaselineUtil.getCreateBaselineDilemmaHandler(parms, result.getConfigurationsWithConflicts(), result.getConfigurationsWithConflictsInSubcomponents(), result.getConfigurationsWithUncheckedInChanges(), result.getConfigurationsWithUncheckedInChangesInSubcomponents(), result.getActiveChangeSetsInSubcomponents(), result.getInaccessibleConfigurationsInSubcomponents(), result.getNotFoundConfigurationsInSubcomponents(), result.getOutOfSyncShares(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)progress.newChild(10));
        ICreateBaselineOperation op = BaselineUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)progress.newChild(10));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)progress.newChild(70));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        Collection<IBaselineConnection> baselinesCreated = op.getBaselinesCreated();
        SubMonitor subMonitor = progress.newChild(10);
        subMonitor.setWorkRemaining(baselinesCreated.size());
        for (IBaselineConnection baselineConnection : baselinesCreated) {
            Map<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedByForBaselines(baselineConnection.teamRepository(), Collections.singletonList(baselineConnection.getResolvedBaseline()), (IProgressMonitor)subMonitor.newChild(1));
            result.getBaselines().add(CoreUtil.translateBaseline(baselineConnection, contributors));
        }
        return result;
    }

    private static ICreateBaselineOperation prepareOperation(ParmsCreateBaselines parms, CreateBaselineDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)parms.requests.length);
        ICreateBaselineOperation op = IOperationFactory.instance.getCreateBaselineOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        HashMap<UUID, IWorkspaceConnection> workspaceConnectionMap = new HashMap<UUID, IWorkspaceConnection>();
        ParmsCreateBaselineRequest[] parmsCreateBaselineRequestArray = parms.requests;
        int n = parms.requests.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsCreateBaselineRequest request = parmsCreateBaselineRequestArray[n2];
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)workspaceConnectionMap.get(request.workspace.getWorkspaceHandle().getItemId());
            if (workspaceConnection == null) {
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                workspaceConnectionMap.put(request.workspace.getWorkspaceHandle().getItemId(), workspaceConnection);
            } else {
                monitor.worked(1);
            }
            IComponentHandle component = request.getComponentHandle();
            op.createBaselineRequest(workspaceConnection, component, request.name, request.comment);
            ++n2;
        }
        return op;
    }

    private static ICreateSnapshotOperation prepareOperation(ParmsCreateBaselineSet parms, CreateSnapshotDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ICreateSnapshotOperation op = IOperationFactory.instance.getCreateSnapshotOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        int flags = 0;
        if (parms.createNewBaselines.booleanValue()) {
            flags |= 1;
        }
        if (parms.forceBaselineCreation.booleanValue()) {
            flags |= 2;
        }
        op.createSnapshotRequest(parms.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(10)), parms.getExcludedComponentHandles(), flags, parms.name, parms.comment);
        return op;
    }

    private static CreateBaselineDilemmaHandler getCreateBaselineDilemmaHandler(ParmsCreateBaselines parms, final List<ConfigurationDescriptorDTO> configurationsWithConflicts, final List<ConfigurationDescriptorDTO> configurationsWithConflictsInSubcomponents, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChangesInSubcomponents, final List<ProblemChangeSetsDTO> activeChangeSetsInSubcomponents, final List<ConfigurationDescriptorDTO> inaccessibleConfigurationsInSubcomponents, final List<ConfigurationDescriptorDTO> notFoundConfigurationsInSubcomponents, List<ShareDTO> outOfSyncShares, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor monitor) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int pendingChangesInSubcomponentsInstruction = CommitUtil.getUncheckedInChangesSubcomponentsInstruction(parms.pendingChangesDilemmaHandler);
        ParmsCreateBaselineDilemmaHandler createBaselineDilemmaHandler = parms.createBaselineDilemmaHandler;
        final int conflictedConfigurationsInstruction = createBaselineDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineDilemmaHandler.conflictedConfigurationsDirection, "conflictedConfigurationsDirection");
        final int conflictedConfigurationsInSubcomponentsInstruction = createBaselineDilemmaHandler == null ? 2 : BaselineUtil.getInstructionNoContinue(createBaselineDilemmaHandler.conflictedConfigurationsInSubcomponentsDirection, "conflictedConfigurationsInSubcomponentsDirection");
        final int activeChangeSetsInSubcomponentsInstruction = createBaselineDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineDilemmaHandler.activeChangeSetsInSubcomponentsDirection, "activeChangeSetsInSubcomponentsDirection");
        final int inaccessibleConfigurationsInSubcomponentsInstruction = createBaselineDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineDilemmaHandler.inaccessibleConfigurationsInSubcomponentsDirection, "inaccessibleConfigurationsInSubcomponentsDirection");
        final int notFoundConfigurationsInSubcomponentsInstruction = createBaselineDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineDilemmaHandler.notFoundConfigurationsInSubcomponentsDirection, "notFoundConfigurationsInSubcomponentsDirection");
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, monitor);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        CreateBaselineDilemmaHandler dilemmaHandler = new CreateBaselineDilemmaHandler(){

            @Override
            public int conflictedConfigurations(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
                if (configurationsWithConflicts != null) {
                    for (ConfigurationFacade descriptor : conflictedConfigurations) {
                        configurationsWithConflicts.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return conflictedConfigurationsInstruction;
            }

            @Override
            public int conflictedConfigurationsInSubcomponents(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
                if (configurationsWithConflicts != null) {
                    for (ConfigurationFacade descriptor : conflictedConfigurations) {
                        configurationsWithConflictsInSubcomponents.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return conflictedConfigurationsInSubcomponentsInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                }
                return pendingChangesInstruction;
            }

            @Override
            public int uncheckedInChangesInSubcomponents(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap, IProgressMonitor monitor) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChangesInSubcomponents.add(uncheckedInChanges);
                }
                return pendingChangesInSubcomponentsInstruction;
            }

            @Override
            public int activeChangeSetsInSubcomponents(Map<ConfigurationFacade, Collection<IChangeSetHandle>> activeChangeSets, IProgressMonitor monitor) {
                if (activeChangeSets != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<IChangeSetHandle>> entry : activeChangeSets.entrySet()) {
                        activeChangeSetsInSubcomponents.add(CoreUtil.translateProblemChangeSetsDTO(entry.getKey(), entry.getValue()));
                    }
                }
                return activeChangeSetsInSubcomponentsInstruction;
            }

            @Override
            public int inaccessibleSubcomponents(Set<ConfigurationFacade> inaccessibleConfigurations, IProgressMonitor monitor) {
                if (inaccessibleConfigurations != null) {
                    for (ConfigurationFacade descriptor : inaccessibleConfigurations) {
                        inaccessibleConfigurationsInSubcomponents.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return inaccessibleConfigurationsInSubcomponentsInstruction;
            }

            @Override
            public int subcomponentsNotInWorkspace(Set<ConfigurationFacade> configurationsNotInWorkspace, IProgressMonitor monitor) {
                if (configurationsNotInWorkspace != null) {
                    for (ConfigurationFacade descriptor : configurationsNotInWorkspace) {
                        notFoundConfigurationsInSubcomponents.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return notFoundConfigurationsInSubcomponentsInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    private static CreateSnapshotDilemmaHandler getCreateBaselineSetDilemmaHandler(ParmsCreateBaselineSet parms, final List<ConfigurationDescriptorDTO> configurationsWithConflicts, final List<ConfigurationDescriptorDTO> configurationsWithConflictsInSubcomponents, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChangesInSubcomponents, final List<ProblemChangeSetsDTO> activeChangeSetsInSubcomponents, final List<ProblemChangeSetsDTO> activeChangeSetsInConfigurations, final List<ConfigurationDescriptorDTO> inaccessibleConfigurationsInSubcomponents, final List<ConfigurationDescriptorDTO> notFoundConfigurationsInSubcomponents, final List<ConfigurationDescriptorDTO> entireHierarchyNotInSnapshot, List<ShareDTO> outOfSyncShares, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor monitor) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int pendingChangesInSubcomponentsInstruction = CommitUtil.getUncheckedInChangesSubcomponentsInstruction(parms.pendingChangesDilemmaHandler);
        ParmsCreateBaselineSetDilemmaHandler createBaselineSetDilemmaHandler = parms.createBaselineSetDilemmaHandler;
        final int conflictedConfigurationsInstruction = createBaselineSetDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineSetDilemmaHandler.conflictedConfigurationsDirection, "conflictedConfigurationsDirection");
        final int conflictedConfigurationsInSubcomponentsInstruction = createBaselineSetDilemmaHandler == null ? 2 : BaselineUtil.getInstructionNoContinue(createBaselineSetDilemmaHandler.conflictedConfigurationsInSubcomponentsDirection, "conflictedConfigurationsInSubcomponentsDirection");
        final int activeChangeSetsInSubcomponentsInstruction = createBaselineSetDilemmaHandler == null ? 0 : BaselineUtil.getInstruction(createBaselineSetDilemmaHandler.activeChangeSetsInSubcomponentsDirection, "activeChangeSetsInSubcomponentsDirection");
        final int activeChangeSetsInConfigurationsInstruction = createBaselineSetDilemmaHandler == null ? 0 : BaselineUtil.getInstruction(createBaselineSetDilemmaHandler.activeChangeSetsInConfigurationsDirection, "activeChangeSetsInConfigurationsDirection");
        final int inaccessibleConfigurationsInSubcomponentsInstruction = createBaselineSetDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineSetDilemmaHandler.inaccessibleConfigurationsInSubcomponentsDirection, "inaccessibleConfigurationsInSubcomponentsDirection");
        final int notFoundConfigurationsInSubcomponentsInstruction = createBaselineSetDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineSetDilemmaHandler.notFoundConfigurationsInSubcomponentsDirection, "notFoundConfigurationsInSubcomponentsDirection");
        final int entireHierarchyNotInSnapshotInstruction = createBaselineSetDilemmaHandler == null ? 2 : BaselineUtil.getInstruction(createBaselineSetDilemmaHandler.entireHierarchyNotInSnapshotDirection, "entireHierarchyNotInSnapshotDirection");
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, monitor);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        CreateSnapshotDilemmaHandler dilemmaHandler = new CreateSnapshotDilemmaHandler(){

            @Override
            public int conflictedConfigurations(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
                if (configurationsWithConflicts != null) {
                    for (ConfigurationFacade descriptor : conflictedConfigurations) {
                        configurationsWithConflicts.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return conflictedConfigurationsInstruction;
            }

            @Override
            public int conflictedConfigurationsInSubcomponents(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
                if (configurationsWithConflicts != null) {
                    for (ConfigurationFacade descriptor : conflictedConfigurations) {
                        configurationsWithConflictsInSubcomponents.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return conflictedConfigurationsInSubcomponentsInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                }
                return pendingChangesInstruction;
            }

            @Override
            public int uncheckedInChangesInSubcomponents(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap, IProgressMonitor monitor) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChangesInSubcomponents.add(uncheckedInChanges);
                }
                return pendingChangesInSubcomponentsInstruction;
            }

            @Override
            public int activeChangeSetsInSubcomponents(Map<ConfigurationFacade, Collection<IChangeSetHandle>> activeChangeSets, IProgressMonitor monitor) {
                if (activeChangeSets != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<IChangeSetHandle>> entry : activeChangeSets.entrySet()) {
                        activeChangeSetsInSubcomponents.add(CoreUtil.translateProblemChangeSetsDTO(entry.getKey(), entry.getValue()));
                    }
                }
                return activeChangeSetsInSubcomponentsInstruction;
            }

            @Override
            public int activeChangeSetsInConfiguration(Map<ConfigurationFacade, Collection<IChangeSetHandle>> activeChangeSets, IProgressMonitor monitor) {
                if (activeChangeSets != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<IChangeSetHandle>> entry : activeChangeSets.entrySet()) {
                        activeChangeSetsInConfigurations.add(CoreUtil.translateProblemChangeSetsDTO(entry.getKey(), entry.getValue()));
                    }
                }
                return activeChangeSetsInConfigurationsInstruction;
            }

            @Override
            public int inaccessibleSubcomponents(Set<ConfigurationFacade> inaccessibleConfigurations, IProgressMonitor monitor) {
                if (inaccessibleConfigurations != null) {
                    for (ConfigurationFacade descriptor : inaccessibleConfigurations) {
                        inaccessibleConfigurationsInSubcomponents.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return inaccessibleConfigurationsInSubcomponentsInstruction;
            }

            @Override
            public int subcomponentsNotInWorkspace(Set<ConfigurationFacade> configurationsNotInWorkspace, IProgressMonitor monitor) {
                if (configurationsNotInWorkspace != null) {
                    for (ConfigurationFacade descriptor : configurationsNotInWorkspace) {
                        notFoundConfigurationsInSubcomponents.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return notFoundConfigurationsInSubcomponentsInstruction;
            }

            @Override
            public int entireHierarchyNotInSnapshot(List<ConfigurationFacade> missingConfigurations) {
                if (missingConfigurations != null) {
                    for (ConfigurationFacade descriptor : missingConfigurations) {
                        entireHierarchyNotInSnapshot.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return entireHierarchyNotInSnapshotInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    private static int getInstruction(String instruction, String message) {
        int instructionValue = 2;
        if ("continue".equals(instruction)) {
            instructionValue = 0;
        } else if (instruction == null) {
            instructionValue = 2;
        } else if ("cancel".equals(instruction)) {
            instructionValue = 1;
        } else if ("fail".equals(instruction)) {
            instructionValue = 2;
        } else {
            throw new IllegalArgumentException("The value of " + message + " must be one of " + "cancel" + ", " + "continue" + " or " + "fail");
        }
        return instructionValue;
    }

    private static int getInstructionNoContinue(String instruction, String message) {
        int instructionValue = 2;
        if (instruction == null) {
            instructionValue = 2;
        } else if ("cancel".equals(instruction)) {
            instructionValue = 1;
        } else if ("fail".equals(instruction)) {
            instructionValue = 2;
        } else {
            throw new IllegalArgumentException("The value of " + message + " must be one of " + "cancel" + " or " + "fail");
        }
        return instructionValue;
    }

    public static void updateBaseline(ParmsUpdateBaseline parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBaselineConnection baselineConnection = parms.baseline.getBaselineConnection((IProgressMonitor)progress.newChild(10));
        if (parms.name != null) {
            baselineConnection.setName(parms.name, (IProgressMonitor)progress.newChild(45));
        }
        progress.setWorkRemaining(45);
        if (parms.comment != null) {
            baselineConnection.setComment(parms.comment, (IProgressMonitor)progress.newChild(45));
        }
    }

    public static CreateBaselineSetResultDTO createBaselineSet(ParmsCreateBaselineSet parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CreateBaselineSetResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createCreateBaselineSetResultDTO();
        CreateSnapshotDilemmaHandler dilemmaHandler = BaselineUtil.getCreateBaselineSetDilemmaHandler(parms, result.getConfigurationsWithConflicts(), result.getConfigurationsWithConflictsInSubcomponents(), result.getConfigurationsWithUncheckedInChanges(), result.getConfigurationsWithUncheckedInChangesInSubcomponents(), result.getActiveChangeSetsInSubcomponents(), result.getActiveChangeSetsInConfigurations(), result.getInaccessibleConfigurationsInSubcomponents(), result.getNotFoundConfigurationsInSubcomponents(), result.getEntireHierarchyNotIncludedInSnapshot(), result.getOutOfSyncShares(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)progress.newChild(10));
        ICreateSnapshotOperation op = BaselineUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)progress.newChild(10));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)progress.newChild(70));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        progress.setWorkRemaining(10);
        IBaselineSetHandle baselineSetHandle = op.getSnapshotCreated();
        if (baselineSetHandle != null) {
            IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
            IBaselineSet baselineSet = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, (IProgressMonitor)progress.newChild(5));
            result.setBaselineSet(CoreUtil.translateBaselineSet(workspaceConnection.teamRepository(), baselineSet));
        }
        progress.done();
        return result;
    }

    public static void updateBaselineSet(ParmsUpdateBaselineSet parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.baselineSet.repositoryUrl);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        if (parms.comment != null) {
            workspaceManager.setComment(baselineSet, parms.comment, (IProgressMonitor)progress.newChild(30));
        }
        progress.setWorkRemaining(70);
        if (parms.name != null) {
            workspaceManager.setName(baselineSet, parms.name, (IProgressMonitor)progress.newChild(30));
        }
        progress.setWorkRemaining(40);
        if (parms.promotionWorkspace != null) {
            IWorkspaceConnection workspaceConnection = parms.promotionWorkspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
            workspaceConnection.addBaselineSet(baselineSet, (IProgressMonitor)progress.newChild(30));
        }
        progress.done();
    }

    public static void removeBaselineSet(ParmsRemoveBaselineSet parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(20));
        workspaceConnection.removeBaselineSet(baselineSet, (IProgressMonitor)progress.newChild(80));
    }

    /*
     * Unable to fully structure code
     */
    public static GetBaselinesDTO getBaselines(ParmsGetBaselines parms, IProgressMonitor monitor) throws TeamRepositoryException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createGetBaselinesDTO();
        if (parms.baselineItemIds != null && parms.baselineItemIds.length > 0) {
            handles = new ArrayList<IBaselineHandle>();
            var9_7 = parms.baselineItemIds;
            var8_10 = parms.baselineItemIds.length;
            var7_15 = 0;
            while (var7_15 < var8_10) {
                baselineItemId = var9_7[var7_15];
                handles.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)baselineItemId), null));
                ++var7_15;
            }
            fetchedBaselines = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(10));
            baselines = new ArrayList<IBaseline>(fetchedBaselines.size());
            for (IBaseline baseline : fetchedBaselines) {
                if (baseline == null) continue;
                baselines.add(baseline);
            }
            contributors = CoreUtil.fetchCreatorAndGetModifiedByForBaselines(repo, baselines, (IProgressMonitor)progress.newChild(10));
            for (IBaseline baseline : baselines) {
                result.getBaselinesInRepository().add(CoreUtil.translateBaseline(repo, baseline, contributors));
            }
            result.setTotalEntries((long)result.getBaselinesInRepository().size());
            return result;
        }
        progress.setWorkRemaining(80);
        component = CommonUtil.createComponentHandle(repo, parms.componentItemId);
        if (parms.workspaceItemId != null) {
            block20: {
                block21: {
                    workspace = new ParmsWorkspace();
                    workspace.repositoryUrl = parms.repositoryUrl;
                    workspace.workspaceItemId = parms.workspaceItemId;
                    connection = workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
                    try {
                        numBasisInHistory = connection.getComponentInfo(component).numBasisInHistory();
                        break block20;
                    }
                    catch (TeamRepositoryException e) {
                        if (!(e instanceof ComponentNotInWorkspaceException)) break block21;
                        pastComponentInfos = connection.getPastComponentInfos((IProgressMonitor)progress.newChild(5));
                        numBasisInHistory = 0L;
                        ** for (pastInfo : pastComponentInfos)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!pastInfo.component().sameItemId((IItemHandle)component)) continue;
                        numBasisInHistory = pastInfo.numBasisInHistory();
lbl47:
                        // 2 sources

                        break block20;
                    }
                }
                throw e;
            }
            progress.setWorkRemaining(70);
            result.setTotalEntries(numBasisInHistory);
            if (numBasisInHistory > 0L) {
                baselineHandles = new ArrayList<IBaselineHandle>(parms.max);
                trail = new ArrayList<E>(parms.max);
                max = Math.min((long)parms.max.intValue(), numBasisInHistory);
                if (parms.start == null) {
                    start = Math.max(0L, numBasisInHistory - max);
                    end = start + max;
                } else {
                    start = parms.start;
                    end = Math.min(start + max, numBasisInHistory);
                }
                if (end - start > 512L) {
                    numberOfLoops = (int)(max / 512L);
                    if (max % 512L != 0L) {
                        ++numberOfLoops;
                    }
                    fromIndex = start;
                    loopProgress = SubMonitor.convert((IProgressMonitor)progress, (int)30).setWorkRemaining(numberOfLoops);
                    while (fromIndex + 512L <= end) {
                        infos = connection.getComponentAuditTrail(component, fromIndex, 512L, (IProgressMonitor)loopProgress.newChild(1));
                        trail.addAll(infos);
                        fromIndex += 512L;
                    }
                    if (fromIndex <= end) {
                        infos = connection.getComponentAuditTrail(component, fromIndex, end - fromIndex, (IProgressMonitor)progress.newChild(20));
                        trail.addAll(infos);
                    }
                } else {
                    trail = connection.getComponentAuditTrail(component, start, max, (IProgressMonitor)progress.newChild(50));
                }
                progress.setWorkRemaining(20);
                for (IComponentInfo info : trail) {
                    basis = info.basis();
                    if (basis == null) continue;
                    baselineHandles.add(basis);
                }
                baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)progress.newChild(10));
                contributors = CoreUtil.fetchCreatorAndGetModifiedByForBaselines(repo, baselines, (IProgressMonitor)progress.newChild(10));
                iBaselines = baselines.iterator();
                for (IComponentInfo info : trail) {
                    baselineEntry = FilesystemRestClientDTOsyncFactory.eINSTANCE.createBaselineHistoryEntryDTO();
                    result.getBaselineHistoryEntriesInWorkspace().add(baselineEntry);
                    baselineEntry.setDeliveredByItemId(info.deliveredBy().getItemId().getUuidValue());
                    baselineEntry.setDeliveryDate(info.deliveryDate().getTime());
                    if (info.basis() == null) continue;
                    baseline = (IBaseline)iBaselines.next();
                    baselineEntry.setBaseline(CoreUtil.translateBaseline(repo, baseline, contributors));
                }
            }
        } else {
            wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            baselineHandles = wm.findBaselines(IBaselineSearchCriteria.FACTORY.newInstance().setComponentRequired(component), 0x7FFFFFFF, (IProgressMonitor)progress.newChild(40));
            result.setTotalEntries((long)baselineHandles.size());
            baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)progress.newChild(20));
            contributors = CoreUtil.fetchCreatorAndGetModifiedByForBaselines(repo, baselines, (IProgressMonitor)progress.newChild(20));
            Collections.sort(baselines, new Comparator<IBaseline>(){

                @Override
                public int compare(IBaseline o1, IBaseline o2) {
                    return NullUtil.compare((Comparable)o1.getCreationDate(), (Comparable)o2.getCreationDate());
                }
            });
            for (IBaseline baseline : baselines) {
                if (baseline == null) continue;
                result.getBaselinesInRepository().add(CoreUtil.translateBaseline(repo, baseline, contributors));
            }
        }
        progress.done();
        return result;
    }

    public static GetBaselineSetsDTO getBaselineSets(ParmsWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IWorkspaceConnection wc = parms.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
        List handles = wc.getBaselineSets((IProgressMonitor)progress.newChild(75));
        List baselineSets = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(20));
        GetBaselineSetsDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createGetBaselineSetsDTO();
        for (IBaselineSet baselineSet : baselineSets) {
            BaselineSetDTO dto = CoreUtil.translateBaselineSet(repo, baselineSet);
            result.getBaselineSets().add(dto);
        }
        return result;
    }

    public static void putBaselineCustomAttributes(ParmsBaselineCustomAttributes parms, ISyncViewProxy syncViewProxy, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBaselineConnection bc = parms.baseline.getBaselineConnection((IProgressMonitor)progress.newChild(50));
        HashMap<String, String> setCustomAttrs = new HashMap<String, String>(parms.setCustomAttrs.length);
        ParmsProperty[] parmsPropertyArray = parms.setCustomAttrs;
        int n = parms.setCustomAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsProperty key = parmsPropertyArray[n2];
            setCustomAttrs.put(key.propertyName, key.propertyValue);
            ++n2;
        }
        String[] unsetCustomAttributes = parms.unsetCustomAttrs;
        bc.setCustomAttributes(setCustomAttrs, unsetCustomAttributes, (IProgressMonitor)progress.newChild(50));
    }

    public static BaselineCustomAttributesDTO getBaselineCustomAttributes(ParmsBaseline parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        BaselineCustomAttributesDTO customAttrs = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createBaselineCustomAttributesDTO();
        IBaselineConnection connection = parms.getBaselineConnection((IProgressMonitor)progress.newChild(100));
        Map baselineAttrs = connection.getCustomAttributes();
        customAttrs.getCustomAttributes().putAll(baselineAttrs);
        return customAttrs;
    }

    public static void putBaselineSetCustomAttributes(ParmsBaselineSetCustomAttributes parms, ISyncViewProxy syncViewProxy, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.baselineSet.repositoryUrl);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        HashMap<String, String> setCustomAttrs = new HashMap<String, String>(parms.setCustomAttrs.length);
        ParmsProperty[] parmsPropertyArray = parms.setCustomAttrs;
        int n = parms.setCustomAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsProperty key = parmsPropertyArray[n2];
            setCustomAttrs.put(key.propertyName, key.propertyValue);
            ++n2;
        }
        String[] unsetCustomAttributes = parms.unsetCustomAttrs;
        workspaceManager.setCustomAttributes(baselineSet, setCustomAttrs, unsetCustomAttributes, (IProgressMonitor)progress.newChild(100));
    }

    public static BaselineCustomAttributesDTO getBaselineSetCustomAttributes(ParmsBaselineSetGetCustomAttributes parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        BaselineCustomAttributesDTO customAttrs = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createBaselineCustomAttributesDTO();
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.baselineSet.repositoryUrl);
        IBaselineSetHandle baselineSetHandle = parms.baselineSet.getBaselineSetHandle();
        IBaselineSet baselineSet = (IBaselineSet)repo.itemManager().teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, (IProgressMonitor)progress.newChild(100));
        Map baselineAttrs = baselineSet.getCustomAttributes();
        customAttrs.getCustomAttributes().putAll(baselineAttrs);
        return customAttrs;
    }

    public static BaselineDTO getBaselineHierarchy(ParmsBaseline parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CommonUtil.getTeamRepository(parms.repositoryUrl);
        IBaselineConnection connection = parms.getBaselineConnection((IProgressMonitor)progress.newChild(50));
        return CoreUtil.translateBaselineHierarchy(connection, (IProgressMonitor)progress.newChild(50));
    }
}

