/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadRuleFactory;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.load.loadRules.SandboxExaminerDilemmaHandler;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.ISandboxExaminerOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoad;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadComponentVersionables;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadRuleSerializationInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPath;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxLoadRules;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnload;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChanges2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.CollisionDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.FilesystemRestClientDTOloadFactory;
import com.ibm.team.filesystem.common.internal.rest.client.load.InvalidLoadRequestDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadLocationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.MultipleSandboxLoadDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.OverlappedItemDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.RemovedShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.SandboxLoadRuleDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.SandboxLoadRulesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.ShareToLoadDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.UnLoadResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class LoadUtil {
    private static final String LOAD_REQUEST = "putLoadCFA";
    private static final String EVALUATE_LOAD_REQUEST = "getLoadCFA";

    public static LoadEvaluationDTO evaluateLoad(ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        final LoadEvaluationDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadEvaluationDTO();
        LoadDilemmaHandler loadDilemmaHandler = new LoadDilemmaHandler(){

            @Override
            public int loadRuleProblems(List<IStatus> problems) {
                for (IStatus problem : problems) {
                    result.getLoadRuleProblems().add(CoreUtil.translateStatus(problem));
                }
                return 0;
            }
        };
        ILoadOperation loadOperation = LoadUtil.prepareLoadRequest(EVALUATE_LOAD_REQUEST, parms, loadDilemmaHandler, result, (IProgressMonitor)monitor.newChild(10));
        loadOperation.evaluateLoadRequests((IProgressMonitor)monitor.newChild(69));
        LoadUtil.translateCollisions(result, loadOperation.getCollisions(), (IProgressMonitor)monitor.newChild(5));
        LoadUtil.translateInvalidLoadRequests(result, loadOperation.getInvalidLoadRequests());
        LoadUtil.translateOverlaps(result, loadOperation.getLoadOverlaps(), (IProgressMonitor)monitor.newChild(5));
        LoadUtil.translateNewShares(result, loadOperation.getNewSharesToLoad());
        LoadUtil.translateSharesOutOfSync(result, loadOperation.getSharesOutOfSync(), (IProgressMonitor)monitor.newChild(5));
        LoadUtil.translateSharesToBeRemoved(result, loadOperation.getSharesToBeRemoved(), (IProgressMonitor)monitor.newChild(5));
        LoadUtil.translateMultipleSandboxLoads(result, loadOperation.getMultipleSandboxLoads((IProgressMonitor)monitor.newChild(1)));
        LoadUtil.translateInvalidLoadLocations(result, loadOperation.getInvalidLoadLocations());
        return result;
    }

    private static void translateInvalidLoadLocations(LoadEvaluationDTO result, Collection<IInvalidLoadLocation> invalidLoadLocations) {
        for (IInvalidLoadLocation invalid : invalidLoadLocations) {
            InvalidLoadRequestDTO invalidRequest = FilesystemRestClientDTOloadFactory.eINSTANCE.createInvalidLoadRequestDTO();
            LoadLocationDTO location = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            ITeamRepository teamRepository = invalid.getLoadRequest().getConnection().teamRepository();
            location.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
            location.setRepositoryURL(teamRepository.getRepositoryURI());
            location.setContextItemId(invalid.getLoadRequest().getConnection().getContextHandle().getItemId().getUuidValue());
            location.setIsWorkspaceContext(invalid.getLoadRequest().getConnection().getContextHandle() instanceof IWorkspaceHandle);
            location.setComponentItemId(invalid.getLoadRequest().getComponent().getItemId().getUuidValue());
            location.setVersionableItemId(invalid.getLoadRequest().getVersionableToLoad().getItemId().getUuidValue());
            location.setVersionableItemType(CoreUtil.getVersionableItemType(invalid.getLoadRequest().getVersionableToLoad()));
            invalidRequest.setLoadLocation(location);
            LoadUtil.getReasons(invalid, invalidRequest.getReason());
            result.getInvalidLoadRequests().add(invalidRequest);
        }
    }

    private static Collection<String> getReasons(IInvalidLoadLocation invalidLoadLocation, List<String> statusList) {
        ILoadRequest loadRequest = invalidLoadLocation.getLoadRequest();
        for (ISandbox iSandbox : invalidLoadLocation.getSandboxesOverlapped()) {
            statusList.add(NLS.bind((String)Messages.LoadUtil_7, (Object)loadRequest.getSandbox().getRoot().toOSString(), (Object[])new Object[]{iSandbox.getRoot().toOSString()}));
        }
        if (!invalidLoadLocation.getLoadRequestsOverlapped().isEmpty()) {
            statusList.add(NLS.bind((String)Messages.LoadUtil_8, (Object)invalidLoadLocation.getLoadRequestsOverlapped().size(), (Object[])new Object[0]));
        }
        for (IShare iShare : invalidLoadLocation.getSharesOverlapped()) {
            statusList.add(NLS.bind((String)Messages.LoadUtil_9, (Object)loadRequest.getSandbox().getRoot().toOSString(), (Object[])new Object[]{iShare.getShareable().getLocalPath().toString()}));
        }
        IShareable iShareable = invalidLoadLocation.getPresentLoadLocation();
        if (iShareable != null) {
            statusList.add(NLS.bind((String)Messages.LoadUtil_10, (Object)loadRequest.getSandbox().getRoot().toOSString(), (Object[])new Object[]{iShareable.getLocalPath().toString()}));
        }
        return statusList;
    }

    private static void translateCollisions(LoadEvaluationDTO translation, Collection<ICollision> collisions, IProgressMonitor monitor) throws FileSystemException {
        for (ICollision collision : collisions) {
            CollisionDTO loadCollision = FilesystemRestClientDTOloadFactory.eINSTANCE.createCollisionDTO();
            loadCollision.setPath(CoreUtil.translatePath(collision.getShareable().getLocalPath()));
            loadCollision.setDetail(collision.getStatus().getMessage());
            loadCollision.setCollidedWithExistingContent(collision.collidedWithExistingContent());
            if (collision.collidedWithExistingContent() && collision.getShare() != null) {
                loadCollision.setCollidedWithExistingShare(true);
            } else {
                loadCollision.setCollidedWithExistingShare(false);
            }
            for (ILoadLocation location : collision.getLocations()) {
                LoadLocationDTO loadLocation = LoadUtil.translateLoadLocation(location);
                loadCollision.getLoadLocations().add(loadLocation);
            }
            translation.getCollisions().add(loadCollision);
        }
    }

    private static void translateInvalidLoadRequests(LoadEvaluationDTO translation, Collection<IInvalidLoadRequest> invalidLoadRequests) {
        for (IInvalidLoadRequest invalid : invalidLoadRequests) {
            InvalidLoadRequestDTO invalidRequest = FilesystemRestClientDTOloadFactory.eINSTANCE.createInvalidLoadRequestDTO();
            LoadLocationDTO location = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            ITeamRepository teamRepository = invalid.getInvalidRequest().getConnection().teamRepository();
            location.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
            location.setRepositoryURL(teamRepository.getRepositoryURI());
            location.setContextItemId(invalid.getInvalidRequest().getConnection().getContextHandle().getItemId().getUuidValue());
            location.setIsWorkspaceContext(invalid.getInvalidRequest().getConnection().getContextHandle() instanceof IWorkspaceHandle);
            location.setComponentItemId(invalid.getInvalidRequest().getComponent().getItemId().getUuidValue());
            location.setVersionableItemId(invalid.getInvalidRequest().getVersionableToLoad().getItemId().getUuidValue());
            location.setVersionableItemType(CoreUtil.getVersionableItemType(invalid.getInvalidRequest().getVersionableToLoad()));
            invalidRequest.setLoadLocation(location);
            invalidRequest.getReason().add(invalid.getStatus().getMessage());
            translation.getInvalidLoadRequests().add(invalidRequest);
        }
    }

    private static void translateOverlaps(LoadEvaluationDTO translation, Collection<ILoadOverlap> overlaps, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)overlaps.size());
        for (ILoadOverlap overlap : overlaps) {
            LoadOverlapDTO loadOverlap = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadOverlapDTO();
            LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            loadLocation.setContextItemId(overlap.getConnection().getContextHandle().getItemId().getUuidValue());
            loadLocation.setIsWorkspaceContext(overlap.getConnection().getContextHandle() instanceof IWorkspaceHandle);
            ITeamRepository teamRepository = overlap.getConnection().teamRepository();
            loadLocation.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
            loadLocation.setRepositoryURL(teamRepository.getRepositoryURI());
            loadLocation.setComponentItemId(overlap.getComponent().getItemId().getUuidValue());
            loadLocation.setVersionableItemId(overlap.getItem().getItemId().getUuidValue());
            loadLocation.setVersionableItemType(CoreUtil.getVersionableItemType(overlap.getItem()));
            loadOverlap.setLoadLocation(loadLocation);
            loadOverlap.setPath(CoreUtil.translatePath(overlap.getPath()));
            SubMonitor iterProgress = progress.newChild(1);
            iterProgress.setWorkRemaining(overlap.getOverlappingShares().size());
            for (IShare share : overlap.getOverlappingShares()) {
                ShareDTO overlappedShare = CoreUtil.translateShare(share, (IProgressMonitor)iterProgress.newChild(1));
                loadOverlap.getOverlappingShares().add(overlappedShare);
            }
            Map<IVersionableHandle, String[]> overlappingItems = overlap.getOverlappingItems();
            for (Map.Entry<IVersionableHandle, String[]> item : overlappingItems.entrySet()) {
                OverlappedItemDTO overlappedItem = FilesystemRestClientDTOloadFactory.eINSTANCE.createOverlappedItemDTO();
                overlappedItem.setVersionableHandle(item.getKey());
                overlappedItem.setPath(CoreUtil.translatePath(item.getValue()));
                loadOverlap.getOverlappingItems().add(overlappedItem);
            }
            translation.getOverlappingLoadRequests().add(loadOverlap);
        }
    }

    private static void translateNewShares(LoadEvaluationDTO translation, Collection<IShareableToLoad> newSharesToLoad) {
        for (IShareableToLoad newShare : newSharesToLoad) {
            ShareToLoadDTO newShareToLoad = FilesystemRestClientDTOloadFactory.eINSTANCE.createShareToLoadDTO();
            newShareToLoad.setPath(CoreUtil.translatePath(newShare.getShareable().getLocalPath()));
            LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            ITeamRepository teamRepository = newShare.getLoadLocation().getConnection().teamRepository();
            loadLocation.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
            loadLocation.setRepositoryURL(teamRepository.getRepositoryURI());
            loadLocation.setContextItemId(newShare.getLoadLocation().getConnection().getContextHandle().getItemId().getUuidValue());
            loadLocation.setIsWorkspaceContext(newShare.getLoadLocation().getConnection() instanceof IWorkspaceConnection);
            loadLocation.setComponentItemId(newShare.getLoadLocation().getComponent().getItemId().getUuidValue());
            loadLocation.setVersionableItemId(newShare.getLoadLocation().getRootToLoad().getItemId().getUuidValue());
            loadLocation.setVersionableItemType(CoreUtil.getVersionableItemType(newShare.getLoadLocation().getRootToLoad()));
            newShareToLoad.setLoadLocation(loadLocation);
            translation.getNewSharesToLoad().add(newShareToLoad);
        }
    }

    private static void translateSharesOutOfSync(LoadEvaluationDTO translation, Collection<IShareOutOfSync> sharesOutOfSync, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)sharesOutOfSync.size());
        for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
            ShareDTO share = CoreUtil.translateShare(shareOutOfSync.getShare(), (IProgressMonitor)progress.newChild(1));
            translation.getSharesOutOfSync().add(share);
        }
    }

    private static void translateSharesToBeRemoved(LoadEvaluationDTO translation, Collection<IRemovedShare> sharesToBeRemoved, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)sharesToBeRemoved.size());
        for (IRemovedShare shareToBeRemoved : sharesToBeRemoved) {
            ShareDTO share = CoreUtil.translateShare(shareToBeRemoved.getShare(), (IProgressMonitor)progress.newChild(1));
            RemovedShareDTO shareRemoved = FilesystemRestClientDTOloadFactory.eINSTANCE.createRemovedShareDTO();
            shareRemoved.setShare(share);
            shareRemoved.setUncommittedChangeCount(shareToBeRemoved.getUncommittedChangeCount());
            translation.getSharesToBeRemoved().add(shareRemoved);
        }
    }

    private static void translateMultipleSandboxLoads(LoadEvaluationDTO translation, Collection<IMultipleSandboxLoad> multipleSandboxLoads) {
        for (IMultipleSandboxLoad multipleSandboxLoad : multipleSandboxLoads) {
            MultipleSandboxLoadDTO multiSandbox = FilesystemRestClientDTOloadFactory.eINSTANCE.createMultipleSandboxLoadDTO();
            multiSandbox.setConfiguration(CoreUtil.translateConfigurationDescriptor(multipleSandboxLoad.getConfiguration()));
            for (ISandbox sandbox : multipleSandboxLoad.getSandboxes()) {
                multiSandbox.getSandboxes().add(sandbox.getRoot().toOSString());
            }
            for (ILoadLocation loadLocation : multipleSandboxLoad.getLoadLocations()) {
                multiSandbox.getLoadLocations().add(LoadUtil.translateLoadLocation(loadLocation));
            }
            translation.getMultipleSandboxLoads().add(multiSandbox);
        }
    }

    private static LoadLocationDTO translateLoadLocation(ILoadLocation location) {
        LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
        ITeamRepository teamRepository = location.getConnection().teamRepository();
        loadLocation.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        loadLocation.setRepositoryURL(teamRepository.getRepositoryURI());
        loadLocation.setContextItemId(location.getConnection().getContextHandle().getItemId().getUuidValue());
        loadLocation.setIsWorkspaceContext(location.getConnection() instanceof IWorkspaceConnection);
        loadLocation.setComponentItemId(location.getComponent().getItemId().getUuidValue());
        loadLocation.setVersionableItemId(location.getRootToLoad().getItemId().getUuidValue());
        loadLocation.setVersionableItemType(CoreUtil.getVersionableItemType(location.getRootToLoad()));
        return loadLocation;
    }

    public static UnLoadResultDTO unload(ParmsUnload parms, IProgressMonitor progress) throws TeamRepositoryException {
        int n;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        UnLoadResultDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createUnLoadResultDTO();
        UnshareDilemmaHandler dilemmaHandler = LoadUtil.getUnshareDilemmaHandler(parms, result.getConfigurationsWithUncheckedInChanges(), result.getOutOfSyncShares(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(10));
        IUnshareOperation op = IOperationFactory.instance.getUnshareOperation(dilemmaHandler, IRepositoryResolver.EXISTING_SHARED);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        op.setDeleteContent(parms.deleteContent);
        if (parms.fullSharePaths != null) {
            SharingManager sharingManager = SharingManager.getInstance();
            ArrayList<IShare> projects = new ArrayList<IShare>();
            SubMonitor loopProgress = monitor.newChild(5).setWorkRemaining(parms.fullSharePaths.length * 2);
            ParmsPath[] parmsPathArray = parms.fullSharePaths;
            int n2 = parms.fullSharePaths.length;
            n = 0;
            while (n < n2) {
                IShare share;
                IShareable shareable;
                ParmsPath shareName = parmsPathArray[n];
                ISandbox sandbox = sharingManager.getSandbox(new PathLocation((IPath)new Path(shareName.sandboxPath)), false);
                ILocation path = sandbox.getRoot().append(new RelativeLocation(new Path(shareName.relativePath).segments()));
                ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)loopProgress.newChild(1));
                if (resourceType != null && (shareable = sharingManager.findShareable(path, resourceType)) != null && (share = shareable.getShare((IProgressMonitor)loopProgress.newChild(1))) != null && shareable.getLocalPath().segmentCount() == share.getPath().segmentCount()) {
                    projects.add(share);
                }
                ++n;
            }
            op.requestUnshareShares(projects);
        }
        if (parms.unloadRequests != null) {
            ArrayList<ConfigurationFacade> descriptors = new ArrayList<ConfigurationFacade>();
            SubMonitor loopProgress = monitor.newChild(10).setWorkRemaining(parms.unloadRequests.length);
            ParmsWorkspaceComponent[] parmsWorkspaceComponentArray = parms.unloadRequests;
            n = parms.unloadRequests.length;
            int n3 = 0;
            while (n3 < n) {
                ParmsWorkspaceComponent component = parmsWorkspaceComponentArray[n3];
                IWorkspaceConnection workspaceConnection = component.workspace.getWorkspaceConnection((IProgressMonitor)loopProgress.newChild(1));
                IComponentHandle componentHandle = component.getComponentHandle();
                ConfigurationFacade descriptor = new ConfigurationFacade((IConnection)workspaceConnection, componentHandle);
                descriptors.add(descriptor);
                ++n3;
            }
            op.requestUnshare(descriptors);
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(100));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static UnshareDilemmaHandler getUnshareDilemmaHandler(final ParmsUnload parms, final List<ConfigurationWithUncheckedInChanges2DTO> configurationsWithUncheckedInChanges, List<ShareDTO> outOfSyncShares, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor progress) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler, 3);
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        return new UnshareDilemmaHandler(){

            @Override
            public int emptySandbox(Collection<ISandbox> emptySandboxes) {
                if (parms.deleteEmptySandboxes.booleanValue()) {
                    return 0;
                }
                return 3;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int uncheckedInChanges(Map<IConfigurationDescriptor, Collection<ILocalChange>> changes) {
                for (Map.Entry<IConfigurationDescriptor, Collection<ILocalChange>> entry : changes.entrySet()) {
                    ConfigurationWithUncheckedInChanges2DTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChanges2DTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                }
                return pendingChangesInstruction;
            }
        };
    }

    public static LoadResultDTO load(final ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        final LoadResultDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadResultDTO();
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma());
        LoadDilemmaHandler loadDilemmaHandler = new LoadDilemmaHandler(){

            @Override
            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    collision.setLoadLocation(collision.getLocations().iterator().next());
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(parms.deleteRemovedShares == null ? false : parms.deleteRemovedShares);
                }
                return 0;
            }

            @Override
            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return 2;
            }

            @Override
            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return super.newItemsToLoad(sharesToLoad);
            }

            @Override
            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return 2;
            }

            @Override
            public int invalidLoadLocations(Collection<IInvalidLoadLocation> invalidLoadLocations) {
                return 2;
            }

            @Override
            public int multipleSandboxLoad(Collection<IMultipleSandboxLoad> locations) {
                return 0;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int loadRuleProblems(List<IStatus> problems) {
                for (IStatus problem : problems) {
                    result.getLoadRuleProblems().add(CoreUtil.translateStatus(problem));
                }
                return 0;
            }
        };
        ILoadOperation loadOperation = LoadUtil.prepareLoadRequest(LOAD_REQUEST, parms, loadDilemmaHandler, null, (IProgressMonitor)monitor.newChild(5));
        loadOperation.run((IProgressMonitor)monitor.newChild(95));
        if (loadOperation.isEclipseMetadataReadFailure()) {
            result.getEclipseReadFailureMessage().addAll(loadOperation.getEclipseMetadataReadFailureMessage());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ILoadOperation prepareLoadRequest(String request, ParmsLoad parms, LoadDilemmaHandler loadDilemmaHandler, LoadEvaluationDTO evaluationResult, IProgressMonitor progress) throws TeamRepositoryException {
        RelativeLocation relativePath;
        ISandbox sandbox;
        PathLocation cfaPath;
        Object componentFolders;
        Object[] objectArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)400);
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        ILoadOperation loadOperation = null;
        if (parms.loadRule != null) {
            subMonitor = monitor.newChild(100);
            PathLocation cfaPath2 = new PathLocation((IPath)new Path(parms.loadRule.sandboxPath));
            ISandbox sandbox2 = sharingManager.getSandbox(cfaPath2, false);
            IWorkspaceConnection workspaceConnection = parms.loadRule.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
            IFileItemHandle loadRuleFileItem = parms.loadRule.getLoadRuleFileItemHandle();
            ILoadRule2 loadRule = null;
            ILoadRuleFactory factory = ILoadRuleFactory.loadRuleFactory;
            List<IComponentHandle> componentFilter = parms.loadRule.getComponentFilter();
            if (loadRuleFileItem != null) {
                IComponentHandle iComponentHandle = parms.loadRule.getComponentHandle();
                loadRule = factory.getLoadRule(workspaceConnection, iComponentHandle, loadRuleFileItem, (IProgressMonitor)subMonitor.newChild(10));
            } else {
                void var17_31;
                void var16_23;
                if (parms.loadRule.loadRuleFileContents != null) {
                    StringReader stringReader = new StringReader(parms.loadRule.loadRuleFileContents);
                    StringReader stringReader2 = new StringReader(parms.loadRule.loadRuleFileContents);
                } else {
                    try {
                        File file = new File(parms.loadRule.loadRuleFile);
                        FileInputStream fis = new FileInputStream(file);
                        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fis, decoder));
                        file = new File(parms.loadRule.loadRuleFile);
                        fis = new FileInputStream(file);
                        decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)fis, decoder));
                    }
                    catch (IOException e) {
                        throw new FileSystemException(NLS.bind((String)Messages.LoadUtil_3, (Object)parms.loadRule.loadRuleFile, (Object[])new Object[]{e.getMessage()}), e);
                    }
                }
                if (factory.isXMLLoadRule((Reader)var16_23)) {
                    loadRule = factory.getLoadRule(workspaceConnection, (Reader)var17_31, true, (IProgressMonitor)subMonitor.newChild(10));
                } else if (componentFilter.isEmpty()) {
                    if (evaluationResult == null) throw new FileSystemException(Messages.LoadUtil_4);
                    evaluationResult.setInvalidFilterForOldLoadRuleFormat(true);
                } else if (componentFilter.size() > 1) {
                    if (evaluationResult == null) throw new FileSystemException(NLS.bind((String)Messages.LoadUtil_5, (Object)componentFilter.size(), (Object[])new Object[0]));
                    evaluationResult.setInvalidFilterForOldLoadRuleFormat(true);
                } else {
                    loadRule = factory.getLoadRule(workspaceConnection, componentFilter.get(0), (Reader)var17_31, true, (IProgressMonitor)subMonitor.newChild(10));
                }
            }
            if (loadRule != null) {
                loadOperation = !componentFilter.isEmpty() ? loadRule.getLoadOp(sandbox2, componentFilter, loadDilemmaHandler, (IProgressMonitor)subMonitor.newChild(10)) : loadRule.getLoadOp(sandbox2, loadDilemmaHandler, (IProgressMonitor)subMonitor.newChild(10));
            }
        }
        if (loadOperation == null) {
            loadOperation = IOperationFactory.instance.getLoadOperation(loadDilemmaHandler);
        }
        if (parms.componentVersionablesToLoad != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.componentVersionablesToLoad.length * 10);
            objectArray = parms.componentVersionablesToLoad;
            int n = parms.componentVersionablesToLoad.length;
            int n2 = 0;
            while (n2 < n) {
                Map exp;
                componentFolders = objectArray[n2];
                cfaPath = new PathLocation((IPath)new Path(((ParmsLoadComponentVersionables)componentFolders).sandboxPath));
                sandbox = sharingManager.getSandbox(cfaPath, false);
                relativePath = ((ParmsLoadComponentVersionables)componentFolders).relativeLoadPath == null ? new RelativeLocation(new String[0]) : new RelativeLocation(new Path(((ParmsLoadComponentVersionables)componentFolders).relativeLoadPath).segments());
                IWorkspaceConnection iWorkspaceConnection = ((ParmsLoadComponentVersionables)componentFolders).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IComponentHandle iComponentHandle = ((ParmsLoadComponentVersionables)componentFolders).getComponentHandle();
                ArrayList<IFolderHandle> versionablesToLoad = new ArrayList<IFolderHandle>(((ParmsLoadComponentVersionables)componentFolders).getFolderHandles());
                versionablesToLoad.addAll(((ParmsLoadComponentVersionables)componentFolders).getFileItemHandles());
                versionablesToLoad.addAll(((ParmsLoadComponentVersionables)componentFolders).getSymbolicLinkHandles());
                if (versionablesToLoad.isEmpty() && (exp = iWorkspaceConnection.configuration(iComponentHandle).childEntriesForRoot((IProgressMonitor)subMonitor.newChild(1))) != null) {
                    versionablesToLoad.addAll(exp.values());
                }
                loadOperation.requestLoad(sandbox, relativePath, iWorkspaceConnection, iComponentHandle, versionablesToLoad);
                ++n2;
            }
        }
        if (parms.versionablesToLoad == null) return loadOperation;
        subMonitor = monitor.newChild(100).setWorkRemaining(parms.componentVersionablesToLoad.length * 10);
        objectArray = parms.versionablesToLoad;
        int n = parms.versionablesToLoad.length;
        int n3 = 0;
        while (n3 < n) {
            componentFolders = objectArray[n3];
            cfaPath = new PathLocation((IPath)new Path(((ParmsLoadVersionable)componentFolders).sandboxPath));
            sandbox = sharingManager.getSandbox(cfaPath, false);
            relativePath = ((ParmsLoadVersionable)componentFolders).relativeLoadPath == null ? RelativeLocation.EMPTY_LOCATION : new RelativeLocation(new Path(((ParmsLoadVersionable)componentFolders).relativeLoadPath).segments());
            IWorkspaceConnection iWorkspaceConnection = ((ParmsLoadVersionable)componentFolders).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
            IComponentHandle iComponentHandle = ((ParmsLoadVersionable)componentFolders).getComponentHandle();
            IVersionableHandle versionableToLoad = ((ParmsLoadVersionable)componentFolders).getVersionableHandle();
            loadOperation.requestLoadAs(sandbox, relativePath, ((ParmsLoadVersionable)componentFolders).alternativeName, iWorkspaceConnection, iComponentHandle, versionableToLoad, true);
            ++n3;
        }
        return loadOperation;
    }

    public static SandboxLoadRulesResultDTO getSandboxLoadRules(ParmsSandboxLoadRules parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        SandboxLoadRulesResultDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createSandboxLoadRulesResultDTO();
        PathLocation sandboxLocation = new PathLocation((IPath)new Path(parms.sandboxPath));
        ISandbox sandbox = SharingManager.getInstance().getSandbox(sandboxLocation, true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.LoadUtil_0, (Object)sandboxLocation.toOSString(), (Object[])new Object[0]));
        }
        SandboxExaminerDilemmaHandler dilemmaHandler = LoadUtil.getSandboxExaminerDilemmaHandler(result.getOutOfSyncShares(), result.getSandboxUpdateDilemma(), parms, (IProgressMonitor)monitor.newChild(1));
        ISandboxExaminerOperation examiner = IOperationFactory.instance.getSandboxExaminerOperation(dilemmaHandler);
        if (parms.workspace != null) {
            IWorkspaceConnection workspace = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(1));
            if (parms.componentItemId != null) {
                IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.componentItemId), null);
                examiner.inspect(sandbox, workspace, componentHandle);
            } else {
                examiner.inspect(sandbox, workspace);
            }
        } else {
            examiner.inspect(sandbox, IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)monitor.newChild(1));
        }
        try {
            examiner.run((IProgressMonitor)monitor.newChild(73));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        Map<ISandbox, Collection<ILoadRule2>> rules = examiner.getLoadRules();
        LoadUtil.serializeRules(parms, rules, result, (IProgressMonitor)monitor.newChild(20));
        return result;
    }

    private static void serializeRules(final ParmsSandboxLoadRules parms, Map<ISandbox, Collection<ILoadRule2>> rules, SandboxLoadRulesResultDTO result, IProgressMonitor progress) throws TeamRepositoryException {
        ParmsLoadRuleSerializationInstructions instructions = parms.serializationInstructions;
        LoadRuleSerializationDilemmaHandler preferences = new LoadRuleSerializationDilemmaHandler(){

            @Override
            public boolean useRepositoryPath() {
                return parms.serializationInstructions.useRepositoryPath;
            }

            @Override
            public boolean useComponentName() {
                return parms.serializationInstructions.useComponentName;
            }

            @Override
            public int overrideEclipseLoadOption(int currentEclipseOption) {
                return LoadUtil.getInstruction(parms.serializationInstructions.eclipseOptionOverride, currentEclipseOption);
            }
        };
        int commentSize = 1 + (instructions.comments == null ? 0 : instructions.comments.length);
        ArrayList<String> comments = new ArrayList<String>(commentSize);
        if (instructions.comments != null) {
            String[] stringArray = instructions.comments;
            int n = instructions.comments.length;
            int n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                comments.add(comment);
                ++n2;
            }
        }
        comments.add("");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)rules.size());
        for (Map.Entry<ISandbox, Collection<ILoadRule2>> entry : rules.entrySet()) {
            SubMonitor iterProgress = monitor.newChild(1);
            iterProgress.setWorkRemaining(entry.getValue().size());
            String ourComment = NLS.bind((String)Messages.LoadUtil_1, (Object)entry.getKey().getRoot().toOSString(), (Object[])new Object[0]);
            comments.remove(commentSize - 1);
            comments.add(commentSize - 1, ourComment);
            int i = 1;
            int paranoiaCount = 3000 + entry.getValue().size();
            String path = "";
            for (ILoadRule2 rule : entry.getValue()) {
                Writer writer = null;
                if (instructions.resultFolder == null) {
                    writer = new StringWriter();
                } else {
                    File saveFolder = new File(instructions.resultFolder);
                    if (!saveFolder.exists()) {
                        saveFolder.mkdirs();
                    }
                    File saveFile = new File(instructions.resultFolder, String.valueOf(instructions.preferredFileName) + "." + "loadrule");
                    while (i < paranoiaCount) {
                        if (!saveFile.exists()) break;
                        saveFile = new File(instructions.resultFolder, String.valueOf(instructions.preferredFileName) + i + "." + "loadrule");
                        ++i;
                    }
                    if (i >= paranoiaCount) {
                        throw new TeamRepositoryException(Messages.LoadUtil_2);
                    }
                    try {
                        FileOutputStream fos = new FileOutputStream(saveFile);
                        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoder);
                        writer = new BufferedWriter(osw);
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.LoadUtil_6, (Object)saveFile.getAbsolutePath(), (Object[])new Object[0]), (Throwable)e);
                    }
                    path = saveFile.getAbsolutePath();
                }
                rule.serializeToXML(writer, comments, preferences, (IProgressMonitor)iterProgress.newChild(1));
                try {
                    ((Writer)writer).flush();
                }
                catch (IOException e) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException iOException) {}
                    throw new TeamRepositoryException(NLS.bind((String)Messages.LoadUtil_6, (Object)path, (Object[])new Object[0]), (Throwable)e);
                }
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.LoadUtil_6, (Object)path, (Object[])new Object[0]), (Throwable)e);
                }
                SandboxLoadRuleDTO sandboxRule = FilesystemRestClientDTOloadFactory.eINSTANCE.createSandboxLoadRuleDTO();
                sandboxRule.setConnection(CoreUtil.translateConnection(rule.getConnection()));
                if (writer instanceof StringWriter) {
                    sandboxRule.setRule(writer.toString());
                    result.getLoadRules().add(sandboxRule);
                    continue;
                }
                sandboxRule.setRule(path);
                result.getLoadRuleFiles().add(sandboxRule);
            }
        }
    }

    private static SandboxExaminerDilemmaHandler getSandboxExaminerDilemmaHandler(List outOfSyncShares, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, ParmsSandboxLoadRules parms, IProgressMonitor progress) {
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        SandboxExaminerDilemmaHandler result = new SandboxExaminerDilemmaHandler(){

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }
        };
        return result;
    }

    private static int getInstruction(String instruction, int currentEclipseOption) {
        if ("none".equals(instruction)) {
            return 0;
        }
        if ("import_projects".equals(instruction)) {
            return 2;
        }
        if ("create_projects".equals(instruction)) {
            return 1;
        }
        return currentEclipseOption;
    }
}

