/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.UnsynchronizedBufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class TeamContent {
    public static final String DISPOSITION_ATTATCHMENT = "attachment";
    public static final String DISPOSITION_NONE = null;
    private static final char COMMA = ',';
    private static final char FORWARD_SLASH = '/';
    private static final char SPACE = ' ';
    private InputStream inputStream;
    private int size;
    private String mediaType;
    private String characterEncoding;
    private Timestamp lastModified = new Timestamp(System.currentTimeMillis());
    private UUID contentId;
    private UUID predecessorId;
    private LineDelimiter lineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
    private HashCode contentHashCode;
    private String alternativeURI;
    private String contentDisposition = "attachment";
    public static final String CONTENT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static ThreadLocal<WeakReference<byte[]>> threadBuffer = new ThreadLocal<WeakReference<byte[]>>(){

        @Override
        protected WeakReference<byte[]> initialValue() {
            return new WeakReference<Object>(null);
        }
    };

    public TeamContent() {
    }

    public TeamContent(String uri) throws TeamRepositoryException {
        this();
        String contentIdExtracted;
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        String predecessorIdExtracted = null;
        String lineDelimiterExtracted = null;
        String hashCodeValueExtracted = null;
        int idx = uri.indexOf(47);
        if (idx == -1) {
            contentIdExtracted = uri;
        } else {
            String tail = uri.substring(idx + 1);
            contentIdExtracted = uri.substring(0, idx);
            idx = tail.indexOf(47);
            if (idx == -1) {
                hashCodeValueExtracted = tail;
            } else {
                hashCodeValueExtracted = tail.substring(0, idx);
                if ((idx = (tail = tail.substring(idx + 1)).indexOf(47)) == -1) {
                    if (this.validLineDelimiter(tail)) {
                        lineDelimiterExtracted = tail;
                    } else {
                        predecessorIdExtracted = tail;
                    }
                } else {
                    lineDelimiterExtracted = tail.substring(0, idx);
                    predecessorIdExtracted = tail.substring(idx + 1);
                }
            }
        }
        try {
            this.contentId = UUID.valueOf(contentIdExtracted);
            try {
                if (hashCodeValueExtracted != null) {
                    this.contentHashCode = new HashCode(Long.valueOf(hashCodeValueExtracted));
                }
            }
            catch (NumberFormatException e) {
                String msg = NLS.bind(Messages.getServerString("TeamContent.ErrorInvalidChecksum"), hashCodeValueExtracted, new Object[0]);
                throw new TeamRepositoryException(msg, e);
            }
            try {
                if (predecessorIdExtracted != null) {
                    this.predecessorId = UUID.valueOf(predecessorIdExtracted);
                }
            }
            catch (IllegalArgumentException e) {
                String msg = NLS.bind(Messages.getServerString("TeamContent.ErrorInvalidUUID"), predecessorIdExtracted, new Object[0]);
                throw new TeamRepositoryException(msg, e);
            }
            try {
                this.setLineDelimiter(lineDelimiterExtracted);
            }
            catch (IllegalArgumentException e) {
                String msg = NLS.bind(Messages.getServerString("TeamContent.ErrorInvalidLineEnding"), lineDelimiterExtracted, new Object[0]);
                throw new TeamRepositoryException(msg, e);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.alternativeURI = uri;
        }
    }

    private boolean validLineDelimiter(String delimiter) {
        return delimiter.equals("LF") || delimiter.equals("CRLF") || delimiter.equals("CR");
    }

    public TeamContent setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public TeamContent setMediaType(String mediaType) {
        if (mediaType != null) {
            StringBuilder typeWithoutCharset = new StringBuilder(mediaType.length());
            StringTokenizer tokenizer = new StringTokenizer(mediaType, ";");
            typeWithoutCharset.append(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String param = tokenizer.nextToken();
                if (param.trim().startsWith("charset=")) continue;
                typeWithoutCharset.append(';');
                typeWithoutCharset.append(param);
            }
            mediaType = typeWithoutCharset.toString();
        }
        this.mediaType = mediaType;
        return this;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getContentType() {
        String contentType = this.mediaType;
        if (contentType != null && this.characterEncoding != null && !this.characterEncoding.equals("")) {
            contentType = String.valueOf(contentType) + "; charset=" + this.characterEncoding;
        }
        return contentType;
    }

    public TeamContent setContentType(String contentType) {
        if (contentType != null) {
            this.characterEncoding = null;
            StringTokenizer tokenizer = new StringTokenizer(contentType, ";");
            while (tokenizer.hasMoreTokens()) {
                String param = tokenizer.nextToken();
                String trimmedParam = param.trim();
                if (!trimmedParam.startsWith("charset=")) continue;
                this.characterEncoding = trimmedParam.substring(8).trim();
                if (this.characterEncoding.length() != 0) continue;
                this.characterEncoding = null;
            }
            this.setMediaType(contentType);
        } else {
            this.mediaType = null;
            this.characterEncoding = null;
        }
        return this;
    }

    public UUID getContentId() {
        return this.contentId;
    }

    public TeamContent setContentId(UUID contentId) {
        this.contentId = contentId;
        return this;
    }

    public UUID getPredecessorContentId() {
        return this.predecessorId;
    }

    public TeamContent setPredecessorContentId(UUID predecessorContentId) {
        this.predecessorId = predecessorContentId;
        return this;
    }

    public LineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public TeamContent setLineDelimiter(LineDelimiter lineDelimiter) {
        if (lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE && lineDelimiter != LineDelimiter.LINE_DELIMITER_LF && lineDelimiter != LineDelimiter.LINE_DELIMITER_CRLF && lineDelimiter != LineDelimiter.LINE_DELIMITER_CR) {
            throw new IllegalArgumentException();
        }
        this.lineDelimiter = lineDelimiter;
        return this;
    }

    public TeamContent setLineDelimiter(String lineDelimiterString) {
        this.lineDelimiter = LineDelimiter.fromQuery(lineDelimiterString);
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public TeamContent setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public Timestamp getLastModified() {
        return this.lastModified;
    }

    public TeamContent setLastModified(Timestamp lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public TeamContent setSize(int size) {
        this.size = size;
        return this;
    }

    public TeamContent setContentHashCode(HashCode contentHashCode) {
        this.contentHashCode = contentHashCode;
        return this;
    }

    public HashCode getContentHashCode() {
        return this.contentHashCode;
    }

    public TeamContent setCharacterEncoding(String encoding) {
        if (encoding != null && (encoding = encoding.trim()).length() == 0) {
            encoding = null;
        }
        this.characterEncoding = encoding;
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getURI() throws TeamRepositoryException {
        if (this.alternativeURI != null) {
            return this.alternativeURI;
        }
        if (this.contentId == null) {
            throw new TeamRepositoryException(Messages.getServerString("TeamContent.ErrorMissingContentId"));
        }
        String uri = this.contentId.getUuidValue();
        if (this.contentHashCode == null) {
            throw new TeamRepositoryException(Messages.getServerString("TeamContent.ErrorMissingHashcode"));
        }
        uri = String.valueOf(uri) + '/';
        uri = String.valueOf(uri) + this.contentHashCode.getValue();
        if (this.lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
            uri = String.valueOf(uri) + '/';
            uri = String.valueOf(uri) + this.lineDelimiter.asQuery();
        }
        if (this.predecessorId != null) {
            uri = String.valueOf(uri) + '/' + this.predecessorId.getUuidValue();
        }
        return uri;
    }

    public TeamContent setAlternativeURI(String uri) {
        this.alternativeURI = uri;
        return this;
    }

    public void pumpBytes(OutputStream os, int bufferSize) throws IOException {
        int toRead = this.size;
        int desiredSize = bufferSize <= 0 ? (toRead < 65536 ? (toRead <= 0 ? 8192 : toRead) : 65536) : bufferSize;
        os = new UnsynchronizedBufferedOutputStream(os, desiredSize);
        byte[] buffer = (byte[])threadBuffer.get().get();
        if (buffer == null || buffer.length < desiredSize) {
            buffer = new byte[desiredSize];
            threadBuffer.set(new WeakReference<byte[]>(buffer));
        }
        try {
            while (toRead > 0) {
                int read = this.inputStream.read(buffer, 0, Math.min(toRead, buffer.length));
                if (read <= 0) {
                    break;
                }
                toRead -= read;
                os.write(buffer, 0, read);
            }
        }
        finally {
            try {
                os.flush();
            }
            finally {
                this.inputStream.close();
            }
        }
        if (toRead != 0) {
            String msg = NLS.bind(Messages.getServerString("TeamContent.ErrorSkewedStreamLength"), this.size, toRead);
            throw new IOException(msg);
        }
    }

    public String toString() {
        StringBuffer buffer;
        block3: {
            buffer = new StringBuffer(150);
            String className = TeamContent.class.getSimpleName();
            buffer.append(className);
            buffer.append('[');
            try {
                buffer.append(this.getURI());
            }
            catch (TeamRepositoryException e) {
                buffer.append(e.getMessage());
                buffer.append(',');
                buffer.append(' ');
                buffer.append(this.contentId.getUuidValue());
                if (this.lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
                    buffer.append((Object)this.lineDelimiter);
                    buffer.append(',');
                    buffer.append(' ');
                }
                if (this.predecessorId == null) break block3;
                buffer.append(this.predecessorId.getUuidValue());
                buffer.append(',');
                buffer.append(' ');
            }
        }
        buffer.append(',');
        buffer.append(' ');
        buffer.append(this.getContentType());
        buffer.append(',');
        buffer.append(' ');
        buffer.append(this.getSize());
        buffer.append(',');
        buffer.append(' ');
        buffer.append(this.getLastModified());
        buffer.append(']');
        return buffer.toString();
    }
}

