/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.IAbortableHttpRequest;
import com.ibm.team.repository.common.util.HashUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class TeamServiceCallContextImpl {
    private static Log logger = LogFactory.getLog(TeamServiceCallContextImpl.class);
    private static ThreadLocal<Stack<TeamServiceCallContextImpl>> contextStacks = new ThreadLocal();
    private static Map<Thread, SocketChannel> connectingSockets = new HashMap<Thread, SocketChannel>();
    private static Map<Thread, Socket> _ThreadSocketMap = new HashMap<Thread, Socket>();
    private IAbortableHttpRequest httpMethod;
    private final IProgressMonitor progressMonitor;
    private MonitorJob monitorJob;
    private Thread methodThread;
    private Thread pauseThread;
    private static boolean logNonCancelableServiceCalls;
    private static Set<String> stackTraces;

    static {
        _ThreadSocketMap = Collections.synchronizedMap(_ThreadSocketMap);
        logNonCancelableServiceCalls = false;
        stackTraces = new HashSet<String>();
    }

    public static Socket getSocketForThread(Thread thread) {
        return _ThreadSocketMap.get(thread);
    }

    public static void setSocketForCurrentThread(Socket socket) {
        if (socket == null) {
            _ThreadSocketMap.remove(Thread.currentThread());
        } else {
            _ThreadSocketMap.put(Thread.currentThread(), socket);
        }
    }

    public static Stack<TeamServiceCallContextImpl> getCurrentStack() {
        Stack<TeamServiceCallContextImpl> currentObject = contextStacks.get();
        if (currentObject != null) {
            return currentObject;
        }
        Stack<TeamServiceCallContextImpl> result = new Stack<TeamServiceCallContextImpl>();
        contextStacks.set(result);
        return result;
    }

    public static TeamServiceCallContextImpl getCurrent() {
        Stack<TeamServiceCallContextImpl> stack = TeamServiceCallContextImpl.getCurrentStack();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public static void pushCallContext(IProgressMonitor progressMonitor) {
        logger.debug((Object)"pushCallContext()");
        Stack<TeamServiceCallContextImpl> stack = TeamServiceCallContextImpl.getCurrentStack();
        stack.push(new TeamServiceCallContextImpl(progressMonitor));
    }

    public static void popCallContext() {
        logger.debug((Object)"popCallContext()");
        Stack<TeamServiceCallContextImpl> stack = TeamServiceCallContextImpl.getCurrentStack();
        stack.pop();
    }

    public static void setUpCall(IAbortableHttpRequest httpMethod) throws OperationCanceledException {
        logger.debug((Object)"setUpCall()");
        TeamServiceCallContextImpl callContext = TeamServiceCallContextImpl.getCurrent();
        if (callContext == null) {
            return;
        }
        if (callContext.isCanceled()) {
            throw new OperationCanceledException();
        }
        callContext.httpMethod = httpMethod;
        callContext.methodThread = Thread.currentThread();
        String jobName = httpMethod == null ? "local service method invocation" : httpMethod.getURI();
        jobName = "TeamService cancel monitor for: " + jobName;
        Job job = callContext.getMonitorJob();
        job.setName(jobName);
        if (httpMethod != null) {
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDownCall() throws OperationCanceledException {
        logger.debug((Object)"tearDownCall()");
        TeamServiceCallContextImpl callContext = TeamServiceCallContextImpl.getCurrent();
        if (callContext == null) {
            return;
        }
        callContext.finishMonitorJob();
        TeamServiceCallContextImpl teamServiceCallContextImpl = callContext;
        synchronized (teamServiceCallContextImpl) {
            callContext.httpMethod = null;
        }
        if (callContext.progressMonitor.isCanceled()) {
            Thread.interrupted();
            throw new OperationCanceledException();
        }
    }

    public static void setUpPause() throws OperationCanceledException {
        logger.debug((Object)"setUpPause()");
        TeamServiceCallContextImpl callContext = TeamServiceCallContextImpl.getCurrent();
        if (callContext == null) {
            return;
        }
        if (callContext.isCanceled()) {
            throw new OperationCanceledException();
        }
        callContext.pauseThread = Thread.currentThread();
        String jobName = "TeamService cancel monitor for: retry pause";
        Job job = callContext.getMonitorJob();
        job.setName(jobName);
        job.schedule();
    }

    public static void tearDownPause() throws OperationCanceledException {
        logger.debug((Object)"tearDownCall()");
        TeamServiceCallContextImpl callContext = TeamServiceCallContextImpl.getCurrent();
        if (callContext == null) {
            return;
        }
        callContext.finishMonitorJob();
        if (callContext.progressMonitor.isCanceled()) {
            Thread.interrupted();
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectingSocket(SocketChannel socket, Thread connectingThread) {
        Map<Thread, SocketChannel> map = connectingSockets;
        synchronized (map) {
            connectingSockets.put(connectingThread, socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConnectingSocket(Thread connectingThread) {
        Map<Thread, SocketChannel> map = connectingSockets;
        synchronized (map) {
            connectingSockets.remove(connectingThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelConnect(Thread thread) {
        if (thread == null) {
            return;
        }
        Map<Thread, SocketChannel> map = connectingSockets;
        synchronized (map) {
            SocketChannel channel = connectingSockets.get(thread);
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public TeamServiceCallContextImpl(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            throw new IllegalArgumentException("progressMonitor must not be null");
        }
        logger.debug((Object)"new TeamServiceCallContextImpl()");
        this.progressMonitor = progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelHttpMethod() {
        TeamServiceCallContextImpl teamServiceCallContextImpl = this;
        synchronized (teamServiceCallContextImpl) {
            block7: {
                if (this.httpMethod == null) break block7;
                Socket iSocket = TeamServiceCallContextImpl.getSocketForThread(this.methodThread);
                if (iSocket != null) {
                    try {
                        iSocket.close();
                    }
                    catch (IOException iOException) {}
                }
                this.httpMethod.abort();
                this.methodThread.interrupt();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelPause() {
        TeamServiceCallContextImpl teamServiceCallContextImpl = this;
        synchronized (teamServiceCallContextImpl) {
            block4: {
                if (this.pauseThread == null) break block4;
                this.pauseThread.interrupt();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getMonitorJob() {
        TeamServiceCallContextImpl teamServiceCallContextImpl = this;
        synchronized (teamServiceCallContextImpl) {
            if (this.monitorJob == null) {
                this.monitorJob = new MonitorJob(this.getClass().getName(), this);
            }
            return this.monitorJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishMonitorJob() {
        MonitorJob job = null;
        TeamServiceCallContextImpl teamServiceCallContextImpl = this;
        synchronized (teamServiceCallContextImpl) {
            if (this.monitorJob != null) {
                job = this.monitorJob;
                this.monitorJob = null;
            }
        }
        if (job != null) {
            job.setFinished();
            job.cancel();
        }
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    public static void checkCancelable() {
        if (logNonCancelableServiceCalls && TeamServiceCallContextImpl.getCurrent() == null) {
            Exception x = new Exception("Non-cancelable service call detected.  A progress monitor should be provided.");
            String hash = HashUtil.getStacktraceHash(x);
            if (stackTraces.contains(hash)) {
                logger.error((Object)(String.valueOf(x.getMessage()) + "Use the stack trace hash to locate the exception trace: " + hash));
            } else {
                stackTraces.add(hash);
                logger.error((Object)("Non-cancelable service call stack trace hash: " + hash));
                logger.error((Object)x.getMessage(), (Throwable)x);
            }
        }
    }

    public static void setLogNonCancelableServiceCalls(boolean logNonCancelableServiceCalls) {
        TeamServiceCallContextImpl.logNonCancelableServiceCalls = logNonCancelableServiceCalls;
    }

    static class MonitorJob
    extends Job {
        private final TeamServiceCallContextImpl callContext;
        private volatile boolean finished;
        private final Object semaphore;

        public MonitorJob(String name, TeamServiceCallContextImpl callContext) {
            super(name);
            logger.debug((Object)"new MonitorJob()");
            this.callContext = callContext;
            this.finished = false;
            this.semaphore = new Object();
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFinished() {
            Object object = this.semaphore;
            synchronized (object) {
                logger.debug((Object)"monitorJob.setFinished()");
                this.finished = true;
                this.semaphore.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor ignore) {
            String logPrefix = null;
            if (logger.isDebugEnabled()) {
                logPrefix = "monitorJob.run(" + (Object)((Object)this) + "): ";
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(logPrefix) + "starting"));
            }
            while (!this.callContext.isCanceled()) {
                try {
                    Object object = this.semaphore;
                    synchronized (object) {
                        if (this.finished) {
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(logPrefix) + "waiting() -->"));
                        }
                        this.semaphore.wait(250L);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(logPrefix) + "waiting() <--"));
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            if (!this.finished && this.callContext.isCanceled()) {
                TeamServiceCallContextImpl.cancelConnect(this.callContext.methodThread);
                boolean didAbort = this.callContext.cancelHttpMethod();
                if (didAbort && logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(logPrefix) + "aborted HTTP method"));
                }
                if ((didAbort = this.callContext.cancelPause()) && logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(logPrefix) + "aborted retry pause"));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(logPrefix) + "returning as canceled"));
                }
                return Status.CANCEL_STATUS;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(logPrefix) + "returning as finished"));
            }
            return Status.OK_STATUS;
        }
    }
}

