/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.IDeferredSecuredLoginInfo;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.internal.login.KerberosLoginUtils;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.Base64;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractLoginInfo
implements ILoginInfo2,
IDeferredSecuredLoginInfo {
    protected final String NONE = "";
    private String password;
    private IDeferredSecuredLoginInfo.ISecuredLoginPropertiesCallback secureCallback = null;
    private AtomicBoolean passwordFetched = new AtomicBoolean(false);

    public static boolean isKerberosPossible() {
        return KerberosLoginUtils.isKerberosPossible();
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public void initialize() throws TeamRepositoryException {
    }

    @Override
    public boolean hasPassword() {
        return true;
    }

    @Override
    public boolean isValidLoginInfo() {
        return true;
    }

    @Override
    public boolean validateLoggedInUser(String name, String userid) {
        return true;
    }

    @Override
    public void successfulLogin() {
    }

    @Override
    public Properties getLoginProperties() {
        return new Properties();
    }

    @Override
    public Properties getSecuredLoginProperties() throws SavedPasswordNotObtainedException {
        return new Properties();
    }

    @Override
    public void setSecuredLoginProperties(Properties properties) {
    }

    @Override
    public void setSecuredLoginPropertiesCallback(IDeferredSecuredLoginInfo.ISecuredLoginPropertiesCallback callback) {
        this.secureCallback = callback;
    }

    public String getPassword() throws SavedPasswordNotObtainedException {
        if (this.secureCallback != null && !this.passwordFetched.getAndSet(true)) {
            this.secureCallback.fetchSecuredLoginProperties(this);
        }
        try {
            return this.password != null ? this.decodePassword(this.password) : this.password;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(Messages.getClientString("AbstractLoginInfo.PasswordDecode.error"), ex);
        }
    }

    public void setPassword(String password) {
        try {
            this.password = password != null ? this.encodePassword(password) : "";
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(Messages.getClientString("AbstractLoginInfo.PasswordEncode.error"), ex);
        }
    }

    private String encodePassword(String clearPass) throws UnsupportedEncodingException {
        return new String(Base64.encode((byte[])clearPass.getBytes("UTF-8")), "UTF-8");
    }

    private String decodePassword(String encodedPass) throws UnsupportedEncodingException {
        return new String(Base64.decode((byte[])encodedPass.getBytes("UTF-8")), "UTF-8");
    }

    public void clearPassword() {
        this.setPassword("");
    }
}

