/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.login.AbstractLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ITeamServer;
import java.util.Properties;

public class UsernameAndPasswordLoginInfo
extends AbstractLoginInfo {
    private static final String EMPTY = "";
    public static final String USERNAME = "username";
    private String username;

    public UsernameAndPasswordLoginInfo() {
        this(EMPTY, EMPTY);
    }

    public UsernameAndPasswordLoginInfo(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public UsernameAndPasswordLoginInfo(ITeamRepository.ILoginHandler.ILoginInfo loginInfo) {
        this(loginInfo.getUserId(), loginInfo.getPassword());
    }

    @Override
    public String getId() {
        return "com.ibm.team.repository.client.internal.UserAndPassLoginInfo";
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void handleCredentials(ITeamServer teamServer) throws TeamRepositoryException {
        teamServer.setCredentials(this.getUsername(), this.getPassword());
    }

    @Override
    public boolean validateLoggedInUser(String name, String userid) {
        return userid != null && !userid.isEmpty();
    }

    @Override
    public boolean isValidLoginInfo() {
        return true;
    }

    @Override
    public Properties getLoginProperties() {
        Properties properties = super.getLoginProperties();
        properties.setProperty(USERNAME, this.username);
        return properties;
    }

    @Override
    public void setLoginProperties(Properties properties) {
        String value = properties.getProperty(USERNAME);
        if (value == null) {
            value = properties.getProperty("userId");
        }
        this.setUsername(value);
    }

    public void setUsername(String username) {
        this.username = username != null ? username : EMPTY;
    }

    @Override
    public Properties getSecuredLoginProperties() throws SavedPasswordNotObtainedException {
        Properties secureProperties = new Properties();
        secureProperties.setProperty(this.username, this.getPassword());
        return secureProperties;
    }

    @Override
    public void setSecuredLoginProperties(Properties secureProperties) {
        if (secureProperties == null) {
            return;
        }
        String value = secureProperties.getProperty(this.username, null);
        this.setPassword(value);
    }
}

