/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.core.MetadataUpdateJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ManagedFileTree
extends FileTree {
    private Map<ManagedFileStore, IFileInfo> infos = new HashMap<ManagedFileStore, IFileInfo>();
    private Map<ManagedFileStore, IFileInfo[]> children = new HashMap<ManagedFileStore, IFileInfo[]>();

    public static void refreshMetadata(ManagedFileStore store, IProgressMonitor monitor) throws FileSystemException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(store.getCfaPath(), store.getLocalPath(), false, (IProgressMonitor)progress.newChild(1));
        try {
            if (lock.code == 0) {
                ManagedFileStore.updateMetadata(store, store.fetchInfo(0, (IProgressMonitor)progress.newChild(1)), (IProgressMonitor)progress.newChild(1));
            } else if (lock.code != 1) {
                MetadataUpdateJob.queueUpdate(store, false);
            }
        }
        finally {
            CFALockUtil.endBatching(lock, progress.newChild(1));
            monitor.done();
        }
    }

    public static void refreshSubtree(ManagedFileStore root, IProgressMonitor mon) throws FileSystemException, CoreException {
        CopyFileArea existingCopyFileArea;
        Sandbox sandbox;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        progress.setTaskName(Messages.ManagedFileStore_3);
        IFileInfo info = root.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        ManagedFileStore.updateMetadata(root, info, (IProgressMonitor)progress.newChild(1));
        if (!info.exists()) {
            return;
        }
        SharingManager sm = SharingManager.getInstance();
        Shareable shareable = sm.findShareable(sandbox = new Sandbox(existingCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(root.getCfaPath())), root.getLocalPath(), info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
            return;
        }
        ArrayList<ManagedFileStore> toVisit = new ArrayList<ManagedFileStore>();
        toVisit.add(root);
        do {
            int idx = toVisit.size() - 1;
            progress.setWorkRemaining(idx + 2);
            ManagedFileStore fs = (ManagedFileStore)((Object)toVisit.remove(idx));
            IFileInfo[] children = fs.childInfos(0, (IProgressMonitor)progress.newChild(1));
            fs.updateMetadataForChildren(children, progress.newChild(1));
            progress.setWorkRemaining(idx + children.length + 2);
            IFileInfo[] iFileInfoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo child = iFileInfoArray[n2];
                shareable = sm.findShareable(sandbox, fs.getLocalPath().append(child.getName()), child.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                if (!CopyFileAreaUtil.isShareRoot(shareable.getLocalPath(), existingCopyFileArea) && !shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(1))) {
                    toVisit.add(fs.getChild(child.getName()));
                }
                ++n2;
            }
        } while (!toVisit.isEmpty());
    }

    public ManagedFileTree(ManagedFileStore root) {
        super((IFileStore)root);
    }

    public IFileInfo[] getChildInfos(IFileStore store) {
        IFileInfo[] childInfos = this.children.get(store);
        if (childInfos == null) {
            if (!(store instanceof ManagedFileStore)) {
                try {
                    return store.childInfos(0, null);
                }
                catch (CoreException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            return new IFileInfo[0];
        }
        return childInfos;
    }

    public IFileStore[] getChildStores(IFileStore store) {
        IFileInfo[] childInfos = this.children.get(store);
        if (childInfos == null) {
            if (!(store instanceof ManagedFileStore)) {
                try {
                    return store.childStores(0, null);
                }
                catch (CoreException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            return new IFileStore[0];
        }
        ArrayList<IFileStore> result = new ArrayList<IFileStore>(childInfos.length);
        IFileInfo[] iFileInfoArray = childInfos;
        int n = childInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo info = iFileInfoArray[n2];
            IFileStore childStore = store.getChild(info.getName());
            result.add(childStore);
            ++n2;
        }
        return result.toArray(new IFileStore[result.size()]);
    }

    public IFileInfo getFileInfo(IFileStore store) {
        IFileInfo info = this.infos.get(store);
        if (info == null) {
            IFileInfo[] childInfos;
            if (!(store instanceof ManagedFileStore)) {
                try {
                    return store.fetchInfo(0, null);
                }
                catch (CoreException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            IFileStore parent = store.getParent();
            IFileInfo[] iFileInfoArray = childInfos = this.getChildInfos(parent);
            int n = childInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo childInfo = iFileInfoArray[n2];
                if (childInfo.getName().equals(store.getName())) {
                    return childInfo;
                }
                ++n2;
            }
            FileInfo emptyInfo = new FileInfo(store.getName());
            emptyInfo.setExists(false);
            return emptyInfo;
        }
        return info;
    }

    public boolean populate(IProgressMonitor monitor) throws FileSystemException, CoreException {
        ManagedFileStore root = (ManagedFileStore)this.getTreeRoot();
        if (monitor == null) {
            this.populate(root, false, SubMonitor.convert((IProgressMonitor)monitor));
            return true;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean attemptMetadatUpdate = CFALockUtil.isLockedForUpdateOfChildren(root.getCfaPath(), root.getLocalPath(), (IProgressMonitor)progress.newChild(1));
        CFALockUtil.LockResult lock = attemptMetadatUpdate ? CFALockUtil.createAndLockForUpdateOfChildren(root.getCfaPath(), root.getLocalPath(), false, (IProgressMonitor)progress.newChild(1)) : null;
        try {
            if (lock == null || lock.code == 0 || lock.code == 2) {
                this.populate(root, attemptMetadatUpdate && lock.code == 0, progress.newChild(98));
                return true;
            }
        }
        finally {
            if (lock != null) {
                CFALockUtil.endBatching(lock, progress.newChild(1));
            }
            monitor.done();
        }
        return false;
    }

    private void populate(ManagedFileStore store, boolean lockHeld, SubMonitor progress) throws FileSystemException, CoreException {
        progress.setWorkRemaining(1000);
        IFileInfo info = store.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (lockHeld) {
            try {
                ManagedFileStore.updateMetadata(store, info, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                MetadataUpdateJob.queueUpdate(store, false);
            }
        } else {
            MetadataUpdateJob.queueUpdate(store, false);
        }
        HashSet<String> visitedLinks = new HashSet<String>();
        this.populate(store, info, lockHeld, visitedLinks, progress);
    }

    private void populate(ManagedFileStore store, IFileInfo info, boolean lockHeld, Set<String> visitedLinks, SubMonitor progress) throws FileSystemException, CoreException {
        progress.setWorkRemaining(1000);
        this.infos.put(store, info);
        if (info.getAttribute(32)) {
            HashSet<String> newVisitedLinks = new HashSet<String>();
            newVisitedLinks.addAll(visitedLinks);
            newVisitedLinks.add(info.getStringAttribute(64));
            visitedLinks = newVisitedLinks;
        }
        this.populateChildren(store, lockHeld, visitedLinks, progress);
    }

    private void populateChildren(ManagedFileStore store, boolean lockHeld, Set<String> visitedLinks, SubMonitor progress) throws FileSystemException, CoreException {
        IFileInfo info = store.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (!info.isDirectory()) {
            this.children.remove((Object)store);
            return;
        }
        IFileInfo[] childInfos = store.childInfos(0, (IProgressMonitor)progress.newChild(1));
        if (childInfos.length != 0) {
            this.children.put(store, childInfos);
        }
        if (lockHeld) {
            try {
                store.updateMetadataForChildren(childInfos, progress.newChild(1));
            }
            catch (CoreException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                MetadataUpdateJob.queueUpdate(store, true);
            }
        } else {
            MetadataUpdateJob.queueUpdate(store, true);
        }
        IFileInfo[] iFileInfoArray = childInfos;
        int n = childInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo childInfo = iFileInfoArray[n2];
            ManagedFileStore childStore = store.getChild(childInfo.getName());
            if (childInfo.getAttribute(32)) {
                String linkTarget = childInfo.getStringAttribute(64);
                if (!visitedLinks.contains(linkTarget)) {
                    this.populate(childStore, childInfo, lockHeld, visitedLinks, progress);
                }
            } else {
                this.populate(childStore, childInfo, lockHeld, visitedLinks, progress);
            }
            ++n2;
        }
    }
}

