/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.process.AbstractShareableAdvisor;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.process.serialization.RequiredContentAdvisorData;
import com.ibm.team.filesystem.common.internal.util.StreamSearchUtil;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequiredContentAdvisor
extends AbstractShareableAdvisor {
    private static final String TAG_REQUIRED_TEXT = "requiredText";
    private static final String TAG_INSERT_TEXT = "insertText";
    private static final String ATTR_TEXT = "text";
    private static final String TAG_FILE_PATTERN = "filePattern";
    private static final String ATTR_PATTERN = "pattern";
    public static final String DATA_ATTR_REQUIRED_CONTENT = "requiredContent";
    public static final String DATA_ATTR_INSERT_TEXT = "insertText";
    public static final String ID_REQUIRED_CONTENT_PROBLEM = "com.ibm.team.process.internal.definitions.requiredContentProblem";
    public static final String ID_REQUIRED_CONTENT = "com.ibm.team.process.deliver.requiredContent";
    private String fFilePattern;
    private String fRequiredText;
    private String fInsertText;
    private Map<UUIDPair, RequiredContentAdvisorData> dataMap = new HashMap<UUIDPair, RequiredContentAdvisorData>();

    @Override
    protected void initialize(IProcessConfigurationElement advisorConfig) {
        super.initialize(advisorConfig);
        IProcessConfigurationElement[] children = advisorConfig.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String elementName = child.getName();
            if (elementName.equals(TAG_FILE_PATTERN)) {
                this.fFilePattern = child.getAttribute(ATTR_PATTERN);
            } else if (elementName.equals(TAG_REQUIRED_TEXT)) {
                this.fRequiredText = child.getAttribute(ATTR_TEXT);
            } else if (elementName.equals("insertText")) {
                this.fInsertText = child.getAttribute(ATTR_TEXT);
            }
            ++i;
        }
    }

    public String getFilePattern() {
        return this.fFilePattern;
    }

    public String getRequiredText() {
        return this.fRequiredText;
    }

    @Override
    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        super.run(operation, advisorConfiguration, collector, monitor);
        for (RequiredContentAdvisorData data : this.dataMap.values()) {
            String text;
            try {
                text = data.toAML();
            }
            catch (TeamRepositoryException e) {
                IAdvisorInfo info = collector.createExceptionInfo(Messages.RequiredContentAdvisor_EXCEPTION_CREATING_AML, e.getCause());
                collector.addInfo((IReportInfo)info);
                continue;
            }
            IAdvisorInfo problem = collector.createProblemInfo(Messages.RequiredContentAdvisor_PROBLEM_TITLE, Messages.RequiredContentAdvisor_PROBLEM_DESCRIPTION, ID_REQUIRED_CONTENT_PROBLEM);
            AdvisorDataMarshaller.AdvisorData unified = new AdvisorDataMarshaller.AdvisorData();
            unified.data = data;
            unified.text = text;
            problem.setProblemObject((Object)unified);
            collector.addInfo((IReportInfo)problem);
        }
    }

    @Override
    protected IReportInfo getShareableProblem(IShareable iShareable, IVersionableHandle versionable, ITeamRepository repo, IWorkspace ctx, IComponentHandle comp, IAdvisorInfoCollector collector, SubMonitor monitor) throws FileSystemException {
        if (!(versionable instanceof IFileItemHandle)) {
            return null;
        }
        Shareable shareable = (Shareable)iShareable;
        IFileStorage storage = shareable.getFileStorage();
        if (storage.getResourceType((IProgressMonitor)monitor.newChild(1)) != ResourceType.FILE) {
            return null;
        }
        if (!storage.exists((IProgressMonitor)monitor.newChild(1))) {
            return null;
        }
        IRelativeLocation path = shareable.getLocalPath();
        if (this.fRequiredText != null && this.fFilePattern != null && path.toString().matches(this.fFilePattern)) {
            FileItemInfo fileItemInfo = shareable.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
            if (fileItemInfo == null) {
                return null;
            }
            try {
                InputStreamReader contents = new InputStreamReader(storage.getContents(new FileOptions(false, shareable, (IProgressMonitor)monitor.newChild(1))), fileItemInfo.getStoredEncoding());
                long size = fileItemInfo.getContentLength();
                monitor.beginTask(Messages.RequiredContentAdvisor_PROGRESS, 100);
                if (!StreamSearchUtil.streamContains((Reader)contents, (long)size, (String)this.fRequiredText, (IProgressMonitor)monitor.newChild(100))) {
                    UUIDPair pair = new UUIDPair((IContextHandle)ctx, comp);
                    RequiredContentAdvisorData data = this.dataMap.get(pair);
                    if (data == null) {
                        data = new RequiredContentAdvisorData();
                        data.ctx = ctx;
                        data.comp = comp;
                        data.insertText = this.fInsertText;
                        data.requiredText = this.fRequiredText;
                        data.repoRoot = repo.getId();
                        data.files = new LinkedList();
                        this.dataMap.put(pair, data);
                    }
                    data.files.add(new RequiredContentAdvisorData.RequiredContentAdvisorDataFile(path.getName(), (IFileItemHandle)versionable));
                }
            }
            catch (IOException e) {
                return collector.createExceptionInfo(NLS.bind((String)Messages.RequiredContentAdvisor_EXCEPTION_READING_FILE, (Object)path.toString()), (Throwable)e);
            }
        }
        monitor.done();
        return null;
    }

    @Override
    protected void appendToProblemData(Element dataElement, Object custom, Document doc) {
        dataElement.setAttribute(DATA_ATTR_REQUIRED_CONTENT, this.fRequiredText);
        dataElement.setAttribute("insertText", this.fInsertText);
    }

    private static class UUIDPair {
        final UUID context;
        final UUID component;

        public UUIDPair(IContextHandle ctx, IComponentHandle comp) {
            this.context = ctx.getItemId();
            this.component = comp.getItemId();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UUIDPair)) {
                return false;
            }
            UUIDPair other = (UUIDPair)o;
            return this.context.equals((Object)other.context) && this.component.equals((Object)other.component);
        }

        public int hashCode() {
            return this.context.hashCode() + this.component.hashCode();
        }
    }
}

