/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class InvalidLoadLocation
implements IInvalidLoadLocation {
    private ILoadRequest loadRequest;
    private Collection<ISandbox> sandboxesOverlapped;
    private Collection<ILoadRequest> loadRequestsOverlapped;
    private IShareable presentLoadLocation;
    private Collection<IShare> sharesOverlapped;
    private List<IStatus> failureReasons;

    public InvalidLoadLocation(ILoadRequest loadRequest) {
        this.loadRequest = loadRequest;
        this.sandboxesOverlapped = new ArrayList<ISandbox>(2);
        this.loadRequestsOverlapped = new ArrayList<ILoadRequest>(2);
        this.sharesOverlapped = new ArrayList<IShare>(2);
        this.failureReasons = new ArrayList<IStatus>(2);
    }

    public void addCopyFileAreaPaths(Collection<ISandbox> sandboxes) {
        for (ISandbox sandbox : sandboxes) {
            this.failureReasons.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.InvalidLoadLocation_1, (Object)sandbox.getRoot().toString(), (Object[])new Object[0]), null));
        }
        this.sandboxesOverlapped.addAll(sandboxes);
    }

    public void addOverlappingLoadRequests(ILoadRequest loadRequests) {
        this.failureReasons.add(FileSystemStatusUtil.getStatusFor(4, Messages.InvalidLoadLocation_2, null));
        this.loadRequestsOverlapped.add(loadRequests);
    }

    public void addOverlappingShare(IShare share) {
        this.failureReasons.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.InvalidLoadLocation_3, (Object)share.getPath().toString(), (Object[])new Object[0]), null));
        this.sharesOverlapped.add(share);
    }

    public void setPresentLoadLocation(IShareable shareable) {
        this.failureReasons.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.InvalidLoadLocation_4, (Object)shareable.getFullPath().toString(), (Object[])new Object[0]), null));
        this.presentLoadLocation = shareable;
    }

    @Override
    public Collection<ISandbox> getSandboxesOverlapped() {
        return Collections.unmodifiableCollection(this.sandboxesOverlapped);
    }

    @Override
    public ILoadRequest getLoadRequest() {
        return this.loadRequest;
    }

    @Override
    public Collection<ILoadRequest> getLoadRequestsOverlapped() {
        return Collections.unmodifiableCollection(this.loadRequestsOverlapped);
    }

    @Override
    public IShareable getPresentLoadLocation() {
        return this.presentLoadLocation;
    }

    @Override
    public Collection<IShare> getSharesOverlapped() {
        return Collections.unmodifiableCollection(this.sharesOverlapped);
    }

    public IStatus getStatus() {
        String mainReason = NLS.bind((String)Messages.InvalidLoadLocation_0, (Object)this.loadRequest.getSandbox().getRoot().append(this.loadRequest.getRelativeLoadPath()).append(this.loadRequest.getAlternativeName()), (Object[])new Object[0]);
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, mainReason, null);
        for (IStatus reason : this.failureReasons) {
            result.add(reason);
        }
        return result;
    }
}

