/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class UnshareOperation
extends FileSystemOperation
implements IUnshareOperation,
ICheckinOptions {
    private ArrayList<IShare> sharesToUnshare;
    private boolean deleteContent = false;
    private List<Shareable> shareablesToUnshare;
    private ArrayList<IConfigurationDescriptor> configurationsToUnshare;
    private UnshareDilemmaHandler unshareDilemmaHandler;
    private boolean refreshBeforeRun = false;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;
    private IRepositoryResolver resolver;
    private Comparator<Shareable> comparator = new Comparator<Shareable>(){

        @Override
        public int compare(Shareable one, Shareable two) {
            int result = two.getLocalPath().segmentCount() - one.getLocalPath().segmentCount();
            return result == 0 ? two.getLocalPath().toString().compareTo(one.getLocalPath().toString()) : result;
        }
    };

    public UnshareOperation(UnshareDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        super(dilemmaHandler == null ? UnshareDilemmaHandler.getDefault() : dilemmaHandler);
        this.unshareDilemmaHandler = (UnshareDilemmaHandler)this.getDilemmaHandler();
        this.configurationsToUnshare = new ArrayList();
        this.sharesToUnshare = new ArrayList();
        this.shareablesToUnshare = new ArrayList<Shareable>();
        this.resolver = resolver;
    }

    @Override
    public void requestUnshareShares(Collection<IShare> sharesToUnshare) {
        this.sharesToUnshare.addAll(sharesToUnshare);
    }

    @Override
    public void requestUnshare(IConnection connection, Collection<? extends IComponentHandle> components) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        for (IComponentHandle iComponentHandle : components) {
            ITeamRepository teamRepository = connection.teamRepository();
            this.configurationsToUnshare.add((IConfigurationDescriptor)new ConfigurationDescriptor(teamRepository.getId(), teamRepository.getRepositoryURI(), connection.getContextHandle(), iComponentHandle));
        }
    }

    @Override
    public void requestUnshare(Collection<? extends IConfigurationDescriptor> configurationsToUnshare) {
        if (configurationsToUnshare == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToUnshare.addAll(configurationsToUnshare);
    }

    @Override
    public void setDeleteContent(boolean deleteContentOnUnshare) {
        this.deleteContent = deleteContentOnUnshare;
    }

    private void checkinPendingChanges(Set<IConfigurationDescriptor> affectedConfigurations, UnshareDilemmaHandler problemHandler, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        HashMap<IConfigurationDescriptor, List<ILocalChange>> checkin = new HashMap<IConfigurationDescriptor, List<ILocalChange>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)150);
        Map<ISandbox, Set<IConfigurationDescriptor>> affectedAreas = this.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)monitor.newChild(1));
        if (this.getRefreshBeforeRun()) {
            monitor.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
            Refresher refresher = new Refresher();
            this.refreshLocal(refresher, affectedAreas, (IProgressMonitor)monitor.newChild(10));
            List<IShareable> shareables = ChangeSetRefreshUtils.rationalizeRefreshTree(refresher.shareables);
            monitor.setWorkRemaining(110 + shareables.size() * 2);
            for (IShareable shareable : shareables) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)monitor.newChild(shareables.size()));
            SubMonitor syncMon = monitor.newChild(10);
            syncMon.setWorkRemaining(affectedAreas.size());
            for (Map.Entry<ISandbox, Set<IConfigurationDescriptor>> area : affectedAreas.entrySet()) {
                SubMonitor descMon = syncMon.newChild(1);
                descMon.setWorkRemaining(area.getValue().size());
                for (IConfigurationDescriptor desc : area.getValue()) {
                    LocalChangeManager.getInstance().syncPendingChanges(desc.getConnectionHandle(), desc.getComponentHandle(), area.getKey(), (IProgressMonitor)descMon.newChild(1));
                }
            }
        }
        monitor.setWorkRemaining(100);
        SubMonitor iterProgress = monitor.newChild(5).setWorkRemaining(affectedAreas.size());
        for (Map.Entry<ISandbox, Set<IConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<IConfigurationDescriptor> configurationsForCFA = entry.getValue();
            SubMonitor subIterProgress = iterProgress.newChild(1).setWorkRemaining(configurationsForCFA.size());
            for (IConfigurationDescriptor descriptor : configurationsForCFA) {
                ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.syncPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox, (IProgressMonitor)subIterProgress.newChild(1));
                ILocalChange[] localChanges = lcm.getPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox);
                if (localChanges.length <= 0) continue;
                List<ILocalChange> changes = Arrays.asList(localChanges);
                changes = Collections.unmodifiableList(changes);
                checkin.put(descriptor, changes);
            }
        }
        if (!checkin.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(Collections.unmodifiableMap(checkin));
            if (result == 0) {
                SubMonitor subProgress = monitor.newChild(10).setWorkRemaining(checkin.size() * 2);
                ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler.getCommitDilemmaHandler(), this.resolver);
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                op.setRefreshBeforeRun(false);
                for (Map.Entry entry : checkin.entrySet()) {
                    Collection changesToCheckin = (Collection)entry.getValue();
                    ILocalChange[] changes = changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]);
                    if (changesToCheckin.isEmpty()) continue;
                    op.requestCheckin(changes, null, "", (IProgressMonitor)subProgress.newChild(1));
                }
                op.run((IProgressMonitor)monitor.newChild(84));
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result != 3) {
                    throw new FileSystemException(Messages.ChangeHistoryChangeSetsOperation_0);
                }
            }
        }
        monitor.done();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        final Set<IConfigurationDescriptor> affected = this.getAffectedConfigurations();
        IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress;
                block31: {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)100);
                    ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
                    try {
                        SubMonitor childMonitor;
                        ICopyFileAreaLockRequest lockRequest = cfaMgr.lockRequestFactory().getLockRequest(affected, true);
                        ICopyFileAreasLock cfaLock = cfaMgr.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        HashMap<ILocation, Sandbox> emptyCFAs = new HashMap<ILocation, Sandbox>();
                        int direction = 3;
                        HashSet<ICopyFileArea> interestingCopyFileAreas = new HashSet<ICopyFileArea>();
                        HashMap<RepoIdConnectionComponentTriple, Collection<ICopyFileArea>> componentsToUnload = new HashMap<RepoIdConnectionComponentTriple, Collection<ICopyFileArea>>();
                        int numCopyFileAreas = 0;
                        try {
                            childMonitor = progress.newChild(8);
                            if (UnshareOperation.this.configurationsToUnshare != null) {
                                childMonitor.setWorkRemaining(UnshareOperation.this.configurationsToUnshare.size());
                                for (IConfigurationDescriptor configuration : UnshareOperation.this.configurationsToUnshare) {
                                    Collection<ICopyFileArea> copyFileAreas = cfaMgr.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)childMonitor.newChild(1));
                                    interestingCopyFileAreas.addAll(copyFileAreas);
                                    RepoIdConnectionComponentTriple toUnload = new RepoIdConnectionComponentTriple(configuration.getRepositoryId(), configuration.getConnectionHandle(), configuration.getComponentHandle());
                                    componentsToUnload.put(toUnload, copyFileAreas);
                                    numCopyFileAreas += copyFileAreas.size();
                                }
                                for (ICopyFileArea cfa : interestingCopyFileAreas) {
                                    Iterator shares = cfa.allShares();
                                    Iterator<IShare> iterator = shares.iterator();
                                    while (iterator.hasNext()) {
                                        IShare share = iterator.next();
                                        ISharingDescriptor descriptor = share.getSharingDescriptor();
                                        RepoIdConnectionComponentTriple configuration = new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponent());
                                        if (!affected.contains(configuration)) continue;
                                        UnshareOperation.this.shareablesToUnshare.add((Shareable)share.getShareable());
                                    }
                                }
                            }
                            UnshareOperation.this.checkinPendingChanges(affected, UnshareOperation.this.unshareDilemmaHandler, (IProgressMonitor)progress.newChild(10));
                            childMonitor = progress.newChild(UnshareOperation.this.deleteContent ? 30 : 60);
                            childMonitor.setWorkRemaining(UnshareOperation.this.shareablesToUnshare.size());
                            int i = 1;
                            Collections.sort(UnshareOperation.this.shareablesToUnshare, UnshareOperation.this.comparator);
                            for (Shareable shareable : UnshareOperation.this.shareablesToUnshare) {
                                if (childMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                try {
                                    childMonitor.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{i, UnshareOperation.this.shareablesToUnshare.size()}));
                                    shareable.unshare((IProgressMonitor)childMonitor.newChild(1));
                                    interestingCopyFileAreas.add(cfaMgr.getCopyFileAreaForPath(shareable.getCopyFileAreaRoot()));
                                }
                                catch (FileSystemException e) {
                                    UnshareOperation.this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                }
                                ++i;
                            }
                            childMonitor.subTask("");
                            childMonitor = progress.newChild(10);
                            childMonitor.setWorkRemaining(numCopyFileAreas);
                            for (Map.Entry entry : componentsToUnload.entrySet()) {
                                RepoIdConnectionComponentTriple descriptor = (RepoIdConnectionComponentTriple)entry.getKey();
                                for (ICopyFileArea cfa : (Collection)entry.getValue()) {
                                    try {
                                        ((CopyFileAreaStore)((Object)cfa)).componentUnloaded(descriptor.getComponentHandle(), descriptor.getConnectionHandle(), (IProgressMonitor)childMonitor.newChild(1));
                                    }
                                    catch (FileSystemException e) {
                                        UnshareOperation.this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                    }
                                }
                            }
                            for (ICopyFileArea cfa : interestingCopyFileAreas) {
                                if (!cfa.allShares().isEmpty()) continue;
                                emptyCFAs.put(cfa.getRoot(), new Sandbox(cfa));
                            }
                            if (!emptyCFAs.isEmpty()) {
                                direction = UnshareOperation.this.unshareDilemmaHandler.emptySandbox(Collections.unmodifiableCollection(emptyCFAs.values()));
                            }
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                        childMonitor = progress.newChild(10);
                        if (!emptyCFAs.isEmpty() && direction == 0) {
                            childMonitor.setWorkRemaining(emptyCFAs.size() * 2 + 2);
                            ICopyFileAreaLockRequest removCFAlockRequest = cfaMgr.lockRequestFactory().getLockRequestForRemoval(emptyCFAs.keySet());
                            ICopyFileAreasLock removeCFALock = cfaMgr.lock(Collections.singleton(removCFAlockRequest), (IProgressMonitor)childMonitor.newChild(1));
                            try {
                                for (ISandbox sandbox : emptyCFAs.values()) {
                                    if (sandbox == null || sandbox.allShares((IProgressMonitor)childMonitor.newChild(1)).length != 0) continue;
                                    SharingManager.getInstance().deregister(sandbox, true, (IProgressMonitor)childMonitor.newChild(1));
                                }
                                break block31;
                            }
                            finally {
                                removeCFALock.release((IProgressMonitor)childMonitor.newChild(1));
                            }
                        }
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                if (UnshareOperation.this.deleteContent) {
                    final SubMonitor childMonitor = progress.newChild(30);
                    childMonitor.setWorkRemaining(UnshareOperation.this.shareablesToUnshare.size());
                    int i = 1;
                    for (final Shareable shareable : UnshareOperation.this.shareablesToUnshare) {
                        childMonitor.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{i + 1, UnshareOperation.this.shareablesToUnshare.size()}));
                        try {
                            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                                @Override
                                public void run() throws FileSystemException {
                                    shareable.getFileStorage().delete((IProgressMonitor)childMonitor.newChild(1));
                                }
                            });
                        }
                        catch (TeamRepositoryException e) {
                            UnshareOperation.this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                        }
                        if (childMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++i;
                    }
                }
                progress.done();
            }
        };
        this.runWithinFileSystemLock(workspaceOp, Messages.UnshareProjectsOperation_0, monitor);
    }

    private Set<IConfigurationDescriptor> getAffectedConfigurations() {
        this.shareablesToUnshare = new ArrayList<Shareable>();
        HashSet<IConfigurationDescriptor> configurations = new HashSet<IConfigurationDescriptor>();
        if (this.configurationsToUnshare != null) {
            for (IConfigurationDescriptor configurationToUnshare : this.configurationsToUnshare) {
                configurations.add(new RepoIdConnectionComponentTriple(configurationToUnshare.getRepositoryId(), configurationToUnshare.getConnectionHandle(), configurationToUnshare.getComponentHandle()));
            }
        }
        if (this.sharesToUnshare != null) {
            for (IShare share : this.sharesToUnshare) {
                IShareable shareable = share.getShareable();
                this.shareablesToUnshare.add((Shareable)shareable);
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                configurations.add(new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponent()));
            }
        }
        return configurations;
    }

    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<IConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CreateBaselineOperation_REFRESHING_LOCAL_FILESYSTEM, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<IConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            IShare[] iShareArray = entry.getKey().allShares((IProgressMonitor)monitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                refresher.addToRefresh(share.getShareable());
                ++n2;
            }
        }
    }

    protected final Map<ISandbox, Set<IConfigurationDescriptor>> getCopyFileAreasAffected(Set<IConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        HashMap<ISandbox, Set<IConfigurationDescriptor>> result = new HashMap<ISandbox, Set<IConfigurationDescriptor>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (IConfigurationDescriptor configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<IConfigurationDescriptor> configurations = (HashSet<IConfigurationDescriptor>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<IConfigurationDescriptor>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    @Override
    public final void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public final boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    private static class Refresher
    implements IFilesystemRefresher {
        private List<IShareable> shareables = new LinkedList<IShareable>();
        private Map<ISandbox, Map<UUID, Set<UUID>>> fullyRefreshedComponents = new HashMap<ISandbox, Map<UUID, Set<UUID>>>();

        private Refresher() {
        }

        @Override
        public void addToRefresh(IShareable toAdd) {
            this.shareables.add(toAdd);
        }

        @Override
        public void addToRefresh(Collection<IShareable> toAdd) {
            this.shareables.addAll(toAdd);
        }

        @Override
        public void addToRefresh(Collection<ISandbox> affectedAreas, IContextHandle contextHandle, IComponentHandle component, IProgressMonitor progress) throws FileSystemException {
            SubMonitor sbMon = SubMonitor.convert((IProgressMonitor)progress);
            sbMon.setWorkRemaining(affectedAreas.size());
            for (ISandbox sandbox : affectedAreas) {
                if (!this.shouldRefreshComponent(sandbox, contextHandle, component)) continue;
                IShare[] iShareArray = SharingManager.getInstance().allShares(sandbox.getRoot(), contextHandle, component, (IProgressMonitor)sbMon.newChild(1));
                int n = iShareArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    this.addToRefresh(share.getShareable());
                    ++n2;
                }
            }
        }

        private boolean shouldRefreshComponent(ISandbox sandbox, IContextHandle contextHandle, IComponentHandle componentHandle) {
            Set<UUID> refreshedComponents;
            Map<UUID, Set<UUID>> refreshedContexts = this.fullyRefreshedComponents.get(sandbox);
            if (refreshedContexts == null) {
                refreshedContexts = new HashMap<UUID, Set<UUID>>();
                this.fullyRefreshedComponents.put(sandbox, refreshedContexts);
            }
            if ((refreshedComponents = refreshedContexts.get(contextHandle.getItemId())) == null) {
                refreshedComponents = new HashSet<UUID>();
                refreshedContexts.put(contextHandle.getItemId(), refreshedComponents);
            }
            return refreshedComponents.add(componentHandle.getItemId());
        }
    }
}

