/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.util.Check;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

class ConnectionCleaner
extends Thread {
    private static final Logger log = Logger.getLogger(ConnectionCleaner.class);
    private final WeakReference<Object> client;
    private final long idleConnectionTimeout;

    ConnectionCleaner(Object client, long idleConnectionTimeout) {
        if (idleConnectionTimeout < 0L) {
            idleConnectionTimeout = 30000L;
        }
        Check.nonNull((Object)client);
        if (!(client instanceof DefaultHttpClient) && !(client instanceof CloseableHttpClient)) {
            throw new IllegalArgumentException("client is unsupported type: " + client.getClass().getName());
        }
        this.client = new WeakReference<Object>(client);
        this.idleConnectionTimeout = idleConnectionTimeout;
        this.setName("Idle connection cleaner [" + client + "]");
        this.setDaemon(true);
    }

    public void run() {
        try {
            while (true) {
                ClientConnectionManager mgr;
                Object client;
                Thread.sleep(10000L);
                try {
                    client = this.client.get();
                    if (client == null) {
                        return;
                    }
                    if (client instanceof CloseableHttpClient) {
                        mgr = ((CloseableHttpClient)client).getConnectionManager();
                    } else if (client instanceof DefaultHttpClient) {
                        mgr = ((DefaultHttpClient)client).getConnectionManager();
                    } else {
                        log.error("Unsupported client type: " + client.getClass().getName());
                        return;
                    }
                    if (mgr != null) {
                        mgr.closeIdleConnections(this.idleConnectionTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e) {
                    log.error("Error in cleaner thread", e);
                }
                mgr = null;
                client = null;
            }
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Terminated by interrupt", e);
            }
            return;
        }
    }
}

