/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoComponent;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;

public class RiRepoVersionHistory
extends RiRepoFolder {
    public Map<String, RiRepoVersion> labelMap = new HashMap<String, RiRepoVersion>();
    public RiRepoComponent _componentRootOf;
    private int versionCount = 0;
    private int baselineCount = 0;

    @Override
    public Class<?> get_proxyClass() {
        return VersionHistoryImpl.class;
    }

    protected RiRepoVersionHistory(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize(repo);
    }

    private void initialize(RiRepo repo) {
        this.createProperty(VersionHistory.ROOT_VERSION, null);
    }

    String createUniqueVersionLocation(boolean isFolderVersion) {
        ++this.versionCount;
        return String.valueOf(isFolderVersion ? "fv" : "v") + String.valueOf(this.versionCount);
    }

    String createUniqueBaselineLocation() {
        ++this.baselineCount;
        return "bl" + String.valueOf(this.baselineCount);
    }

    public RiRepoVersion getLatestActivityVersionReport(RiRepoActivity activity) throws WvcmException {
        RiRepoVersion ret = null;
        if (activity == null) {
            throw new WvcmException("Activity must be provided", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        List<RiRepoVersion> versions = activity.getActivityVersionList();
        int i = 0;
        while (i < versions.size()) {
            RiRepoVersion version = versions.get(i);
            RiRepoVersionHistory vh = version.getVersionHistory();
            if (vh == this) {
                ret = version;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public RiRepoVersion doLatestActivityVersionReport(Location activityLoc, SrvcFeedback feedback) throws WvcmException {
        SrvcResource activityArg = this.provider().getSrvcRes(activityLoc, feedback);
        if (!(activityArg instanceof RiRepoActivity)) {
            throw new WvcmException("Must be an activity", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        RiRepoActivity activity = (RiRepoActivity)activityArg;
        RiRepoVersion version = this.getLatestActivityVersionReport(activity);
        if (version == null) {
            return null;
        }
        return version;
    }

    public RiRepoComponent getComponentRootOf() {
        return this._componentRootOf;
    }

    public RiRepoVersion getRootVersion() {
        return (RiRepoVersion)this.getProperty(VersionHistory.ROOT_VERSION);
    }

    public List<RiRepoVersion> getChildList() {
        return this.getListProperty(Folder.CHILD_LIST);
    }
}

