/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.process;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.process.IFauxXmlNode;
import com.ibm.team.scm.common.internal.process.PCD_defaultValue;
import com.ibm.team.scm.common.internal.process.PCD_mayBeNull;
import com.ibm.team.scm.common.internal.process.PCD_serializationName;
import com.ibm.team.scm.common.internal.process.ProcessConfigDeserializer;
import com.ibm.team.scm.common.internal.process.ProcessConfigurationElementFauxXmlNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentMatchBlock {
    @PCD_serializationName(value="component")
    public List<ComponentMatchRule> components = new ArrayList<ComponentMatchRule>();
    @PCD_serializationName(value="match-all")
    @PCD_defaultValue(value="true")
    @PCD_mayBeNull
    public boolean matchAll = true;
    public static final String TAG_COMPONENT = "component";
    public static final String TAG_COMPONENTS = "components";
    public static final String ATTR_UUID = "uuid";
    public static final String ATTR_MATCH_ALL = "match-all";

    public static ComponentMatchBlock extractFromChild(IProcessConfigurationElement base) throws TeamRepositoryException {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = base.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
            if (TAG_COMPONENT.equals(child.getName())) {
                return ComponentMatchBlock.read(child);
            }
            ++n2;
        }
        return ComponentMatchBlock.matchAll();
    }

    public static ComponentMatchBlock read(IProcessConfigurationElement base) throws TeamRepositoryException {
        if (!TAG_COMPONENTS.equals(base.getName())) {
            throw new TeamRepositoryException("Must start in a \"components\" tag");
        }
        ProcessConfigDeserializer des = new ProcessConfigDeserializer();
        try {
            return (ComponentMatchBlock)des.deserialize((IFauxXmlNode)new ProcessConfigurationElementFauxXmlNode(base), ComponentMatchBlock.class);
        }
        catch (ProcessConfigDeserializer.DeserializationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static ComponentMatchBlock matchAll() {
        return new ComponentMatchBlock(){

            @Override
            public boolean matches(IComponentHandle comp) {
                return true;
            }
        };
    }

    public List<IComponentHandle> filter(ComponentEntry[] entries) {
        ArrayList<IComponentHandle> toReturn = new ArrayList<IComponentHandle>(entries.length);
        ComponentEntry[] componentEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentEntry entry = componentEntryArray[n2];
            IComponentHandle comp = entry.getComponent();
            if (this.matches(comp)) {
                toReturn.add(comp);
            }
            ++n2;
        }
        return toReturn;
    }

    public List<IComponentHandle> filter(Collection<? extends IComponentHandle> comps) {
        ArrayList<IComponentHandle> toReturn = new ArrayList<IComponentHandle>(comps.size());
        for (IComponentHandle iComponentHandle : comps) {
            if (!this.matches(iComponentHandle)) continue;
            toReturn.add(iComponentHandle);
        }
        return toReturn;
    }

    public boolean matches(IComponentHandle comp) {
        if (this.matchAll) {
            return true;
        }
        for (ComponentMatchRule rule : this.components) {
            if (!rule.uuid.equals((Object)comp.getItemId())) continue;
            return true;
        }
        return false;
    }

    public static class ComponentMatchRule {
        public UUID uuid;

        public ComponentMatchRule() {
        }

        public ComponentMatchRule(UUID itemId) {
            this.uuid = itemId;
        }
    }
}

