/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.persistence.hibernate.audit.event.EmptyAuditEventProcessor;
import com.urbancode.persistence.hibernate.audit.event.IAuditEventProcessor;
import com.urbancode.persistence.hibernate.interceptor.ChainedInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.context.ThreadLocalSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil {
    private static final Logger log = LoggerFactory.getLogger(HibernateUtil.class);
    private static final String HIBERNATE_PROPERTIES_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.properties";
    private static final String ROOT_HIBERNATE_PROPERTIES_RESOURCE = "hibernate.cfg.properties";
    private static final String HIBERNATE_CLASS_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.classes";
    private static final String HIBERNATE_LISTENERS_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.listeners";
    private static final String HIBERNATE_INTERCEPTORS_RESOURCE = "com/urbancode/persistence/hibernate/hibernate.cfg.interceptors";
    private static SessionFactory sessionFactory = null;
    private static IAuditEventProcessor auditEventProcessor = new EmptyAuditEventProcessor();

    public static void init() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        HibernateUtil.init((Properties)null);
    }

    public static synchronized void init(Properties inputProps) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        HibernateUtil.loadProperties(cfg, inputProps);
        HibernateUtil.loadAnnotatedClasses(cfg);
        HibernateUtil.loadListeners(cfg);
        HibernateUtil.loadInterceptors(cfg);
        sessionFactory = cfg.configure().buildSessionFactory();
    }

    public static synchronized void init(SessionFactory factory) {
        if (sessionFactory != null) {
            throw new IllegalStateException("HibernateUtils has already been configured. Call reset() if required.");
        }
        sessionFactory = factory;
    }

    public static synchronized void reset() {
        sessionFactory = null;
    }

    public static synchronized SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            throw new HibernateException("Initialize HibernateUtil before getting the session factory");
        }
        return sessionFactory;
    }

    public static synchronized void unbindThreadLocalSessionContext() {
        if (sessionFactory != null) {
            ThreadLocalSessionContext.unbind((SessionFactory)sessionFactory);
        }
    }

    private static void loadProperties(AnnotationConfiguration cfg, Properties inputProperties) throws IOException {
        if (cfg == null) {
            throw new IllegalArgumentException("The parameter cfg must be non-null.");
        }
        Properties props = HibernateUtil.getSessionFactoryProperties();
        cfg.addProperties(props);
        if (inputProperties != null) {
            cfg.addProperties(inputProperties);
        }
    }

    private static void loadAnnotatedClasses(AnnotationConfiguration cfg) throws IOException, ClassNotFoundException {
        if (cfg == null) {
            throw new IllegalArgumentException("The parameter cfg must be non-null.");
        }
        HashSet<Class<?>> entitites = HibernateUtil.loadClassesFromResource(HIBERNATE_CLASS_RESOURCE);
        for (Class<?> entityClass : entitites) {
            if (log.isDebugEnabled()) {
                log.debug("Adding annotated Class '" + entityClass + "'.");
            }
            cfg.addAnnotatedClass(entityClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadListeners(AnnotationConfiguration cfg) throws IOException, ClassNotFoundException {
        HashMap<String, HashSet<String>> listeners = new HashMap<String, HashSet<String>>();
        Enumeration<URL> listnUrls = HibernateUtil.class.getClassLoader().getResources(HIBERNATE_LISTENERS_RESOURCE);
        while (listnUrls.hasMoreElements()) {
            URL listnUrl = listnUrls.nextElement();
            InputStream listnStream = listnUrl.openStream();
            try {
                Properties props = new Properties();
                props.load(listnStream);
                String classPrefix = (String)props.remove("class-prefix");
                classPrefix = classPrefix == null ? "" : classPrefix.trim();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String clazz = (classPrefix + (String)entry.getKey()).trim();
                    String types = (String)entry.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug("Found listener " + clazz + " for events " + types);
                    }
                    for (String type : types.split(",")) {
                        if ((type = type.trim()).length() == 0) continue;
                        HashSet<String> classSet = (HashSet<String>)listeners.get(type);
                        if (classSet == null) {
                            classSet = new HashSet<String>();
                            listeners.put(type, classSet);
                        }
                        classSet.add(clazz);
                    }
                }
            }
            finally {
                listnStream.close();
            }
        }
        for (Map.Entry entry : listeners.entrySet()) {
            cfg.setListeners((String)entry.getKey(), ((HashSet)entry.getValue()).toArray(new String[0]));
        }
    }

    private static void loadInterceptors(AnnotationConfiguration cfg) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ChainedInterceptor chainedInterceptor = new ChainedInterceptor();
        log.debug("LOADING INTERCEPTORS");
        HashSet<Class<?>> interceptors = HibernateUtil.loadClassesFromResource(HIBERNATE_INTERCEPTORS_RESOURCE);
        for (Class<?> interceptor : interceptors) {
            if (log.isDebugEnabled()) {
                log.debug("Loading interceptor '" + interceptor.getName() + "'.");
            }
            chainedInterceptor.add((Interceptor)interceptor.newInstance());
        }
        cfg.setInterceptor((Interceptor)chainedInterceptor);
        log.debug("LOADED INTERCEPTORS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<Class<?>> loadClassesFromResource(String resourceName) throws ClassNotFoundException, IOException {
        HashSet result = new HashSet();
        Enumeration<URL> urls = HibernateUtil.class.getClassLoader().getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(url.openStream(), "UTF-8"));
            try {
                String className = null;
                while ((className = lineReader.readLine()) != null) {
                    if ((className = className.trim()).length() <= 0 || className.startsWith("#")) continue;
                    result.add(Class.forName(className));
                }
            }
            finally {
                lineReader.close();
            }
        }
        return result;
    }

    public static Properties getSessionFactoryProperties() throws IOException {
        Properties props = new Properties();
        HibernateUtil.getSessionFactoryProperties(props, HIBERNATE_PROPERTIES_RESOURCE);
        HibernateUtil.getSessionFactoryProperties(props, ROOT_HIBERNATE_PROPERTIES_RESOURCE);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getSessionFactoryProperties(Properties props, String resourceName) throws IOException {
        if (props == null) {
            throw new IllegalArgumentException("The parameter props must be non-null.");
        }
        Enumeration<URL> propUrls = HibernateUtil.class.getClassLoader().getResources(resourceName);
        while (propUrls.hasMoreElements()) {
            URL propUrl = propUrls.nextElement();
            InputStream propStream = propUrl.openStream();
            try {
                props.load(propStream);
            }
            finally {
                propStream.close();
            }
        }
        return props;
    }

    public static synchronized void closeSessionFactory() {
        if (log.isDebugEnabled()) {
            log.debug("Closing hibernate session factory.");
        }
        if (sessionFactory != null) {
            if (!sessionFactory.isClosed()) {
                sessionFactory.close();
            } else if (log.isWarnEnabled()) {
                log.warn("The hibernate session factory appears to have already been closed!");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully closed hibernate session factory.");
        }
    }

    public static Session getCurrentSession() {
        return sessionFactory.getCurrentSession();
    }

    public static void setAuditEventProcessor(IAuditEventProcessor auditEventProcessor) {
        HibernateUtil.auditEventProcessor = auditEventProcessor;
    }

    public static IAuditEventProcessor getAuditEventProcessor() {
        return auditEventProcessor;
    }
}

