/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.transaction;

import com.urbancode.persistence.PersistenceException;
import com.urbancode.transaction.TransactionBoundDataSynchronization;
import com.urbancode.transaction.TransactionUtil;
import com.urbancode.transaction.TransientPostCommitHook;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTATransactionUtil
implements TransactionUtil {
    private static final String USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private static final String TRANSACTION_MANAGER_NAME = "java:comp/TransactionManager";
    private static final Logger log = LoggerFactory.getLogger(JTATransactionUtil.class);
    private static ThreadLocal txDataMap = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };
    private final Set<Runnable> preCommitHooks = new LinkedHashSet<Runnable>();
    private final Set<Runnable> postCommitHooks = new LinkedHashSet<Runnable>();
    private TransactionManager transactionManager;
    private UserTransaction userTransaction;

    JTATransactionUtil() throws NamingException {
        InitialContext context = new InitialContext();
        this.transactionManager = (TransactionManager)context.lookup(TRANSACTION_MANAGER_NAME);
        this.userTransaction = (UserTransaction)context.lookup(USER_TRANSACTION_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreCommitHook(Runnable r) {
        Set<Runnable> set = this.preCommitHooks;
        synchronized (set) {
            this.preCommitHooks.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPostCommitHook(Runnable r) {
        Set<Runnable> set = this.postCommitHooks;
        synchronized (set) {
            this.postCommitHooks.add(r);
        }
    }

    @Override
    public void addTransientPostCommitHook(TransientPostCommitHook r) {
        throw new UnsupportedOperationException("The addTransientPostCommitHook method is not currently impelemented.");
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public boolean enlistXAResource(XAResource resource) throws PersistenceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Enlisting resource '" + resource.toString() + "' in XA transaction.");
            }
            this.begin();
            Transaction tx = this.getJTATransaction();
            return tx.enlistResource(resource);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public boolean delistXAResource(XAResource resource, int flags) throws PersistenceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Delisting resource '" + resource.toString() + "' from XA transaction.");
            }
            Transaction tx = this.getJTATransaction();
            return tx.delistResource(resource, flags);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public Transaction getJTATransaction() throws PersistenceException {
        try {
            TransactionManager txm = this.getTransactionManager();
            return txm.getTransaction();
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public int getTransactionStatus() throws PersistenceException {
        try {
            UserTransaction utx = this.getUserTransaction();
            return utx.getStatus();
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public boolean isActive() throws PersistenceException {
        try {
            return this.getTransactionStatus() == 0;
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void begin() throws PersistenceException {
        try {
            UserTransaction utx = this.getUserTransaction();
            if (utx.getStatus() == 6) {
                utx.begin();
                if (log.isDebugEnabled()) {
                    log.debug("BEGIN TRANSACTION [Thread-" + Thread.currentThread().getId() + "]");
                }
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws PersistenceException {
        Set<Runnable> set;
        try {
            set = this.preCommitHooks;
            synchronized (set) {
                for (Runnable r : this.preCommitHooks) {
                    r.run();
                }
            }
            UserTransaction utx = this.getUserTransaction();
            utx.commit();
            if (log.isDebugEnabled()) {
                log.debug("COMMIT TRANSACTION [Thread-" + Thread.currentThread().getId() + "]");
            }
            try {
                int status = utx.getStatus();
                if (status != 6) {
                    long currentTime = System.currentTimeMillis();
                    long waitTime = currentTime + 5000L;
                    do {
                        Thread.sleep(500L);
                        currentTime = System.currentTimeMillis();
                        status = this.getTransactionStatus();
                        if (!log.isDebugEnabled()) continue;
                        log.debug("TRANSACTION STATUS = '" + status + "', [Thread-" + Thread.currentThread().getId() + "].");
                    } while (!Thread.interrupted() && currentTime < waitTime && status != 6);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (log.isDebugEnabled()) {
                    log.debug("Thread interrupted while waiting for transaction to commit.");
                }
                if (log.isWarnEnabled() && this.getTransactionStatus() != 6) {
                    log.warn("Thread-" + Thread.currentThread().getId() + ", was" + "interrupted while waiting for transaction cleanup.");
                }
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        set = this.postCommitHooks;
        synchronized (set) {
            Iterator<Runnable> i$ = this.postCommitHooks.iterator();
            while (i$.hasNext()) {
                Runnable r = i$.next();
                r.run();
            }
            return;
        }
    }

    @Override
    public void rollback() throws PersistenceException {
        try {
            UserTransaction utx = this.getUserTransaction();
            utx.rollback();
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("ROLLBACK TRANSACTION [Thread-" + Thread.currentThread().getId() + "]");
        }
    }

    @Override
    public void rollback(Exception e) throws PersistenceException {
        block3: {
            try {
                this.rollback();
            }
            catch (Exception rbe) {
                if (!log.isErrorEnabled()) break block3;
                log.error("ROLLBACK TRANSACTION FAILED! [Thread-" + Thread.currentThread().getId() + "]: " + rbe.toString(), (Throwable)rbe);
            }
        }
        if (e instanceof PersistenceException) {
            throw (PersistenceException)e;
        }
        throw new PersistenceException(e);
    }

    @Override
    public void registerSychronization(Synchronization s) throws PersistenceException {
        try {
            Transaction tx = this.getJTATransaction();
            tx.registerSynchronization(s);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void bind(String key, Object value) {
        Transaction tx = this.getJTATransaction();
        TransactionBoundDataSynchronization.bind(tx, key, value);
    }

    @Override
    public Object unbind(String key) {
        Transaction tx = this.getJTATransaction();
        return TransactionBoundDataSynchronization.unbind(tx, key);
    }

    @Override
    public Object get(String key) {
        Transaction tx = this.getJTATransaction();
        return TransactionBoundDataSynchronization.get(tx, key);
    }

    @Override
    public void bindToAll(String key, Object value) {
        Map<String, Object> txData = this.getTxDataMap();
        txData.put(key, value);
        this.bind(key, value);
    }

    @Override
    public void unbindFromAll(String key) {
        Map<String, Object> txData = this.getTxDataMap();
        txData.remove(key);
        this.unbind(key);
    }

    public Map<String, Object> getTxDataMap() {
        return (Map)txDataMap.get();
    }

    @Override
    public Object getTransaction() throws PersistenceException {
        try {
            return this.getJTATransaction();
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }
}

