/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.events;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.l10n.Messages;
import com.ibm.team.repository.common.IChangeEvent;

public abstract class BuildChangeEvent
implements Comparable {
    private final IChangeEvent fChangeEvent;
    private final boolean fIsLookbackEvent;
    public static final String BUILD_RESULT_CHANGED_EVENT_CATEGORY = "com.ibm.team.build.category.BuildResultChanged";
    public static final String BUILD_RESULT_DELETED_EVENT_CATEGORY = "com.ibm.team.build.category.BuildResultDeleted";
    public static final int MAX_STATE_EXTENSION_STRING_LENGTH = 250;

    public BuildChangeEvent(IChangeEvent changeEvent, boolean isLookbackEvent) {
        ValidationHelper.validateNotNull("changeEvent", changeEvent);
        if (changeEvent.getItem() == null) {
            throw new IllegalArgumentException(Messages.getCommonString("BuildChangeEvent.0"));
        }
        this.fChangeEvent = changeEvent;
        this.fIsLookbackEvent = isLookbackEvent;
    }

    public IChangeEvent getChangeEvent() {
        return this.fChangeEvent;
    }

    public boolean isLookbackEvent() {
        return this.fIsLookbackEvent;
    }

    protected static void setStateExtension(IChangeEvent event, String key, String value) {
        ValidationHelper.validateNotNull("event", event);
        ValidationHelper.validateNotNull("key", key);
        if (value == null || value.length() == 0) {
            return;
        }
        if (value.length() >= 250) {
            return;
        }
        event.setStringExtension(key, value);
    }

    public int compareTo(Object obj) {
        BuildChangeEvent other = (BuildChangeEvent)obj;
        return this.fChangeEvent.getTime().compareTo(other.fChangeEvent.getTime());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildChangeEvent)) {
            return false;
        }
        BuildChangeEvent other = (BuildChangeEvent)obj;
        return this.fChangeEvent.getItemId().equals((Object)other.fChangeEvent.getItemId());
    }

    public int hashCode() {
        return this.fChangeEvent.getItemId().hashCode();
    }
}

