/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.ProcessClient;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.common.IBehaviorConfiguration;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IItemChangeReport;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IIterationTypeHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationConfigurationInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.ProjectOperation;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.internal.client.ArchiveProcessItemRunnable;
import com.ibm.team.process.internal.client.ContentCache;
import com.ibm.team.process.internal.client.GenerateInvitationRunnable;
import com.ibm.team.process.internal.client.IProcessInternalClientService;
import com.ibm.team.process.internal.client.ItemTrap;
import com.ibm.team.process.internal.client.Messages;
import com.ibm.team.process.internal.client.ProcessItemSaveRunnable;
import com.ibm.team.process.internal.client.ProcessItemsSaveRunnable;
import com.ibm.team.process.internal.client.ThinClientProcess;
import com.ibm.team.process.internal.client.workingcopies.WorkingCopyManager;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.ProcessDefinition;
import com.ibm.team.process.internal.common.ProcessDefinitionTranslation;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.process.internal.common.TranslationEntry;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.query.BaseProcessDefinitionQueryModel;
import com.ibm.team.process.internal.common.query.BaseProjectAreaQueryModel;
import com.ibm.team.process.internal.common.service.IBundleFileContentService;
import com.ibm.team.process.internal.common.service.IProcessDefinitionTranslationService;
import com.ibm.team.process.internal.common.service.IProcessExtensionData;
import com.ibm.team.process.internal.common.service.IProcessService;
import com.ibm.team.process.internal.common.util.XMLUtil;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.model.impl.ItemImpl;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.IQueryPage;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IPermissionService;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.transport.TeamContent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProcessClientService
implements IProcessInternalClientService {
    String OP_ID_ACCEPT_TEAM_INVITATION = "com.ibm.team.process.client.acceptTeamInvitation";
    public static final String USE_THIN_CLIENT_PROCESS = "com.ibm.team.process.thinClientProcess";
    public static final String USE_THIN_CLIENT_PROCESS_LOG = "com.ibm.team.process.thinClientProcess.log";
    private final IClientLibraryContext fContext;
    private IProcessService fProcessService;
    private IWorkingCopyManager fWorkingCopyManager;
    private IBundleFileContentService fExtensionSchemaContentService;
    private ContentCache fContentCache;
    private ItemTrap fIterationsTrap = new ItemTrap(20);
    public static final String PROCESS_PROJECT_AREAS_SEGMENT = "/process/project-areas/";
    public static final String TEAM_AREAS_SEGMENT = "team-areas";

    public ProcessClientService(IClientLibraryContext context) {
        this.fContext = context;
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fContext.teamRepository();
    }

    @Override
    public IClientProcess getClientProcess(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask("", 1000);
            IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
            IProjectArea projectArea = (IProjectArea)this.getItemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 750));
            ThinClientProcess thinClientProcess = new ThinClientProcess(projectArea, this.fContext, this);
            return thinClientProcess;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findAllProjectAreas(Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.internalFetch((IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseProjectAreaQueryModel.ProjectAreaQueryModel.ROOT), 10, properties, monitor);
    }

    @Override
    public IProjectArea createProjectArea() {
        return (IProjectArea)this.setOrigin(IProjectArea.ITEM_TYPE.createItem());
    }

    @Override
    public ITeamArea createTeamArea() {
        return (ITeamArea)this.setOrigin(ITeamArea.ITEM_TYPE.createItem());
    }

    @Override
    public IDevelopmentLine createDevelopmentLine() {
        return (IDevelopmentLine)this.setOrigin(IDevelopmentLine.ITEM_TYPE.createItem());
    }

    @Override
    public IIteration createIteration() {
        return (IIteration)this.setOrigin(IIteration.ITEM_TYPE.createItem());
    }

    @Override
    public IIterationType createIterationType() {
        return (IIterationType)this.setOrigin(IIterationType.ITEM_TYPE.createItem());
    }

    @Override
    public IProcessAttachment createProcessAttachment() {
        return (IProcessAttachment)this.setOrigin(IProcessAttachment.ITEM_TYPE.createItem());
    }

    @Override
    public IProcessItem save(IProcessItem processItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.save(processItem, false, monitor);
    }

    public IProcessItem save(IProcessItem processItem, boolean forceOverride, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItem saved;
        if (this.isItemSaveGovernedByProcess(processItem)) {
            String name = Messages.getString("ProcessClientService.0");
            String operationId = null;
            if (processItem instanceof ITeamArea) {
                name = Messages.getString("ProcessClientService.1");
            } else if (processItem instanceof IProjectArea) {
                name = Messages.getString("ProcessClientService.2");
                operationId = "com.ibm.team.process.client.saveProjectArea";
            }
            ProcessItemSaveRunnable runnable = ProcessItemSaveRunnable.newRunnable(processItem, this, forceOverride, operationId);
            this.execute(runnable, name, monitor);
            saved = runnable.getSavedItem();
        } else {
            monitor = this.getProgressMonitor(monitor);
            monitor.beginTask("", 1000);
            IItemsResponse response = this.doSaveProcessItem(processItem, false, (IProgressMonitor)new SubProgressMonitor(monitor, 999));
            saved = (IProcessItem)response.getFirstClientItem();
            try {
                IProcessAttachment attachment;
                IProcessContainerHandle container;
                if (saved instanceof IProcessDefinition) {
                    List savedDefinitions;
                    IProcessDefinition definition = (IProcessDefinition)saved;
                    String name = definition.getName();
                    String summary = definition.getDescription().getSummary();
                    if ((name != null && name.indexOf(37) != -1 || summary != null && summary.indexOf(37) != -1) && (savedDefinitions = this.fetchDefinitionsWithTranslations(Collections.singletonList(definition), (IProgressMonitor)new SubProgressMonitor(monitor, 1))).size() > 0) {
                        return (IProcessItem)savedDefinitions.get(0);
                    }
                } else if (saved instanceof IProcessAttachment && (container = (attachment = (IProcessAttachment)saved).getProcessContainer()) instanceof IProcessDefinitionHandle && attachment.getPath().matches("template.*\\.messages")) {
                    this.fetchDefinitionsWithTranslations(Collections.singletonList(container), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            catch (ServiceNotAvailableException serviceNotAvailableException) {}
        }
        return (IProcessItem)this.shareSingle((IItem)saved);
    }

    @Override
    public IProcessItem[] save(IProcessItem[] processItems, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem[] saved;
        boolean governedByProcess = false;
        int i = 0;
        while (i < processItems.length) {
            if (this.isItemSaveGovernedByProcess(processItems[i])) {
                governedByProcess = true;
                break;
            }
            ++i;
        }
        if (governedByProcess) {
            ProcessItemsSaveRunnable runnable = new ProcessItemsSaveRunnable(processItems, this);
            this.execute(runnable, Messages.getString("ProcessClientService.4"), monitor);
            saved = runnable.getSavedItems();
        } else {
            IItemsResponse response = this.doSaveProcessItems(processItems, monitor);
            saved = response.getClientItems();
        }
        List shared = this.shareList(Arrays.asList(saved));
        return shared.toArray(new IProcessItem[shared.size()]);
    }

    @Override
    public IContent createProcessDefinitionExportZip(final String processId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IContent)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IContent>(){

            public IContent run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessService service = (IProcessService)ProcessClientService.this.fContext.getServiceInterface(IProcessService.class);
                return service.exportProcessDefinitionWithParticipants(processId);
            }
        }, monitor);
    }

    @Override
    public IProcessDefinition importProcessDefinitionZip(final IContent zipFileContent, final String processId, final String processName, final boolean isOverwrite, final String owningApplicationKey, IProgressMonitor monitor) throws TeamRepositoryException {
        List definitionsWithTranslations;
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        IItemsResponse response = (IItemsResponse)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessService service = (IProcessService)ProcessClientService.this.fContext.getServiceInterface(IProcessService.class);
                return service.saveProcessDefinitionImportWithParticipants(zipFileContent, processId, processName, isOverwrite, owningApplicationKey);
            }
        }, (IProgressMonitor)new SubProgressMonitor(monitor, 800));
        IProcessDefinition definition = (IProcessDefinition)response.getFirstClientItem();
        definition = (IProcessDefinition)this.shareSingle((IItem)definition);
        IProcessDefinition translatedDefinition = null;
        String summary = definition.getDescription().getSummary();
        if ((definition.getName().indexOf(37) != -1 || summary != null && summary.indexOf(37) != -1) && (definitionsWithTranslations = this.fetchDefinitionsWithTranslations(Collections.singletonList(definition), (IProgressMonitor)new SubProgressMonitor(monitor, 200))).size() > 0) {
            translatedDefinition = (IProcessDefinition)definitionsWithTranslations.get(0);
        }
        if (translatedDefinition != null) {
            definition = translatedDefinition;
        }
        return definition;
    }

    private boolean isItemSaveGovernedByProcess(IProcessItem processItem) {
        return !(processItem instanceof IProcessDefinition || processItem instanceof IProjectArea && processItem.isNewItem() || processItem instanceof IProcessAttachment && ((IProcessAttachment)processItem).getProcessContainer() instanceof IProcessDefinitionHandle);
    }

    @Override
    public void delete(IProcessItemHandle processItemHandle, boolean recursively, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemChangeReport changeReport = this.doDeleteProcessItem(processItemHandle, recursively, monitor);
        this.processChangeReport(changeReport);
    }

    @Override
    public IProcessItem getMutableCopy(IProcessItem processItem) throws TeamRepositoryException {
        IItem item = this.getItemManager().getSharedItemIfKnown((IItemHandle)processItem);
        if (item != null) {
            processItem = (IProcessItem)this.getItemManager().getImmutableState(item);
        }
        return (IProcessItem)processItem.getWorkingCopy();
    }

    @Override
    public IIteration[] getCurrentIterations(IDevelopmentLineHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        CurrentIterationInfo[] infos = this.getCurrentIterationInfos(handle, monitor);
        int i = 0;
        while (i < infos.length) {
            CurrentIterationInfo info = infos[i];
            iterations.add(info.getIteration());
            ++i;
        }
        return iterations.toArray(new IIteration[iterations.size()]);
    }

    public CurrentIterationInfo[] getCurrentIterationInfos(final IDevelopmentLineHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handle == null) {
            return new CurrentIterationInfo[0];
        }
        CurrentIterationInfo[] shared = this.getSharedCurrents(handle);
        if (shared != null) {
            return shared;
        }
        CurrentIterationInfo[] infos = (CurrentIterationInfo[])this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().getCurrentIterationsInfo(handle);
            }
        }, monitor);
        int i = 0;
        while (i < infos.length) {
            CurrentIterationInfo info = infos[i];
            IIteration iteration = info.getIteration();
            this.fIterationsTrap.add((IItem)iteration);
            this.shareSingle((IItem)iteration);
            IIterationType type = info.getIterationType();
            if (type != null) {
                this.fIterationsTrap.add((IItem)type);
                this.shareSingle((IItem)type);
            }
            ++i;
        }
        return infos;
    }

    private CurrentIterationInfo[] getSharedCurrents(IDevelopmentLineHandle handle) {
        IIterationHandle iterationHandle;
        IDevelopmentLine line = (IDevelopmentLine)this.getItemManager().getSharedItemIfKnown((IItemHandle)handle);
        if (line != null && (iterationHandle = line.getCurrentIteration()) != null) {
            ArrayList<CurrentIterationInfo> currents = new ArrayList<CurrentIterationInfo>(3);
            while (iterationHandle != null) {
                IIteration iteration = (IIteration)this.getItemManager().getSharedItemIfKnown((IItemHandle)iterationHandle);
                if (iteration == null || !iteration.isPropertySet(ProcessCommon.getPropertyName(IIteration.class, (String)"parent"))) {
                    return null;
                }
                IIterationType type = null;
                IIterationTypeHandle typeHandle = iteration.getIterationType();
                if (typeHandle != null && (type = (IIterationType)this.getItemManager().getSharedItemIfKnown((IItemHandle)typeHandle)) == null) {
                    return null;
                }
                CurrentIterationInfo iterationInfo = ProcessPackage.eINSTANCE.getProcessFactory().createCurrentIterationInfo();
                iterationInfo.setIteration(iteration);
                iterationInfo.setIterationType(type);
                currents.add(0, iterationInfo);
                iterationHandle = iteration.getParent();
            }
            return currents.toArray(new CurrentIterationInfo[currents.size()]);
        }
        return null;
    }

    @Override
    public IProcessAttachment getProcessAttachment(final IProcessContainerHandle container, final String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IProcessAttachment)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().getProcessAttachment(container, attachmentPath);
            }
        }, monitor);
    }

    @Override
    public IDevelopmentLine getDevelopmentLine(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLineHandle handle;
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        if (processArea instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)processArea;
            IProjectArea projectArea = (IProjectArea)this.getItemManager().fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            handle = projectArea.getTeamAreaHierarchy().getDevelopmentLine((ITeamAreaHandle)teamArea);
        } else {
            handle = ((IProjectArea)processArea).getProjectDevelopmentLine();
        }
        if (handle == null) {
            return null;
        }
        return (IDevelopmentLine)this.getItemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
    }

    @Override
    public IProcessDefinition createProcessDefinition() {
        return (IProcessDefinition)this.setOrigin(IProcessDefinition.ITEM_TYPE.createItem());
    }

    @Override
    public IProcessDefinition findProcessDefinition(String processId, Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessDefinition definition = this.findProcessDefinitionInCache(processId);
        if (definition != null) {
            return definition;
        }
        return (IProcessDefinition)this.shareSingle((IItem)this.doFindProcessDefinition(processId, properties, monitor));
    }

    @Override
    public List findAllProcessDefinitions(Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            return this.findAllProcessDefinitionsWithTranslations(monitor);
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            return this.internalFetch((IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseProcessDefinitionQueryModel.ProcessDefinitionQueryModel.ROOT), 10, properties, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        }
    }

    private List findAllProcessDefinitionsWithTranslations(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IProcessDefinitionHandle> handlesToFetch = new ArrayList<IProcessDefinitionHandle>();
        ArrayList<ProcessDefinition> translatedDefinitions = new ArrayList<ProcessDefinition>();
        monitor.beginTask("", 1000);
        final IQueryService queryService = this.getQueryService();
        final IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseProcessDefinitionQueryModel.ProcessDefinitionQueryModel.ROOT);
        IItemQueryPage page = (IItemQueryPage)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, 50);
            }
        }, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        List itemHandles = page.getItemHandles();
        SubProgressMonitor pageMonitor = new SubProgressMonitor(monitor, 500);
        pageMonitor.beginTask("", (int)Math.ceil((double)(page.getResultSize() - 50) / 50.0) * 1000);
        while (page.hasNext()) {
            final UUID token = page.getToken();
            final int nextStartPosition = page.getNextStartPosition();
            page = (IItemQueryPage)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return queryService.fetchPage(token, nextStartPosition, 50);
                }
            }, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 1000));
            itemHandles.addAll(page.getItemHandles());
        }
        IItemManager itemManager = this.getItemManager();
        for (IProcessDefinitionHandle handle : itemHandles) {
            ProcessDefinition knownDefinition = (ProcessDefinition)itemManager.getSharedItemIfKnown((IItemHandle)handle);
            if (knownDefinition != null && knownDefinition.hasTranslations()) {
                translatedDefinitions.add(knownDefinition);
                continue;
            }
            handlesToFetch.add(handle);
        }
        List translated = this.fetchDefinitionsWithTranslations(handlesToFetch, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        translatedDefinitions.addAll(translated);
        return translatedDefinitions;
    }

    private List fetchDefinitionsWithTranslations(List definitionHandles, IProgressMonitor monitor) throws ServiceNotAvailableException, TeamRepositoryException {
        ArrayList<ProcessDefinition> fetched = new ArrayList<ProcessDefinition>();
        if (definitionHandles.size() > 0) {
            final IProcessDefinitionHandle[] toFetch = definitionHandles.toArray(new IProcessDefinitionHandle[0]);
            ProcessDefinitionTranslation[] translations = (ProcessDefinitionTranslation[])this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    IProcessDefinitionTranslationService translationService = (IProcessDefinitionTranslationService)ProcessClientService.this.fContext.getServiceInterface(IProcessDefinitionTranslationService.class);
                    return translationService.fetchWithTranslations(toFetch);
                }
            }, monitor);
            int i = 0;
            while (i < translations.length) {
                ProcessDefinitionTranslation translation = translations[i];
                ProcessDefinition definition = (ProcessDefinition)translation.getProcessDefinition();
                if (definition != null) {
                    definition = (ProcessDefinition)this.shareSingle((IItem)definition);
                    fetched.add(definition);
                    HashMap<String, String> names = new HashMap<String, String>();
                    HashMap<String, String> summaries = new HashMap<String, String>();
                    List entries = translation.getInternalTranslationEntries();
                    for (TranslationEntry entry : entries) {
                        String locale = entry.getLocale();
                        String name = entry.getName();
                        String summary = entry.getSummary();
                        names.put(locale, name);
                        summaries.put(locale, summary);
                    }
                    definition.setTranslatedNames(names);
                    definition.setTranslatedSummaries(summaries);
                }
                ++i;
            }
        }
        return fetched;
    }

    @Override
    public IProjectArea initialize(final IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException, TeamOperationCanceledException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getString("ProcessClientService.6"), 1000);
        final IProjectArea[] initializedProjectArea = new IProjectArea[1];
        try {
            IClientProcess clientProcess = this.getClientProcess((IProcessArea)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            clientProcess.executeInitializer(new ProjectOperation("com.ibm.team.process.client.initializeProjectArea", projectArea, projectArea){

                public IOperationReport run(IBehaviorConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
                    IItemsResponse response = ProcessClientService.this.doInitializeProjectArea(projectArea, this.getOperationConfigurationInfo(), monitor);
                    IItem[] items = response.getClientItems();
                    if (items != null && items.length == 1) {
                        initializedProjectArea[0] = (IProjectArea)ProcessClientService.this.shareSingle(items[0]);
                        if (initializedProjectArea[0].getProcessData().get("com.ibm.team.internal.process.40.compiled.xml") == null) {
                            throw new RuntimeException(Messages.getString("ProcessClientService.7"));
                        }
                    }
                    return response.getOperationReport();
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
        }
        finally {
            monitor.done();
        }
        return initializedProjectArea[0];
    }

    public void acceptTeamInvitation(final ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException, TeamOperationCanceledException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getString("ProcessClientService.8"), 1000);
        try {
            IClientProcess clientProcess = this.getClientProcess((IProcessArea)teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            clientProcess.adviseAndExecute(new AdvisableOperation(this.OP_ID_ACCEPT_TEAM_INVITATION, teamArea, (IProcessArea)teamArea){

                public IOperationReport run(IBehaviorConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
                    IItemsResponse response = (IItemsResponse)ProcessClientService.this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                        public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                            return ProcessClientService.this.getService().acceptTeamInvitation(teamArea);
                        }
                    }, monitor);
                    return response.getOperationReport();
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
        }
        finally {
            monitor.done();
        }
    }

    public void generateTeamInvitation(String subject, String message, String copies, IContributorHandle[] recipientHandles, IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException, TeamOperationCanceledException {
        GenerateInvitationRunnable generateInvitationRunnable = new GenerateInvitationRunnable(subject, message, copies, recipientHandles, processArea, this);
        this.execute(generateInvitationRunnable, Messages.getString("ProcessClientService.9"), monitor);
    }

    protected IObjectsResponse doGenerateTeamInvitation(final String subject, final String message, final String copies, final IContributorHandle[] recipientHandles, final IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException, TeamOperationCanceledException {
        IObjectsResponse response = (IObjectsResponse)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().generateTeamInvitation2(subject, message, copies, recipientHandles, processArea, true);
            }
        }, monitor);
        return response;
    }

    @Override
    public void archiveProcessItem(IProcessItem processItem, IProgressMonitor monitor) throws TeamRepositoryException {
        this.execute(new ArchiveProcessItemRunnable(processItem, this), Messages.getString("ProcessClientService.10"), monitor);
    }

    @Override
    public IOperationReport execute(ProcessRunnable runnable, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        runnable.setOrigin((Object)this.getTeamRepository());
        try {
            OperationAdviceManager manager = (OperationAdviceManager)ProcessClient.getOperationAdviceManager();
            IOperationReport iOperationReport = manager.execute(runnable, name, monitor);
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProcessArea findProcessArea(URI areaURI, Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IProcessArea)this.shareSingle((IItem)this.doFindProcessArea(areaURI, properties, monitor));
    }

    protected IItemsResponse doSaveProcessItem(final IProcessItem processItem, final boolean requestAdministrativeOverride, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IItemsResponse)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessService service = (IProcessService)ProcessClientService.this.fContext.getServiceInterface(IProcessService.class);
                return service.saveProcessItemWithOverride(processItem, requestAdministrativeOverride);
            }
        }, monitor);
    }

    protected IItemsResponse doSaveProcessItems(final IProcessItem[] processItems, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IItemsResponse)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessService service = (IProcessService)ProcessClientService.this.fContext.getServiceInterface(IProcessService.class);
                return service.saveProcessItems(processItems);
            }
        }, monitor);
    }

    private IItemChangeReport doDeleteProcessItem(final IProcessItemHandle processItemHandle, final boolean recursively, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IItemChangeReport)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().deleteProcessItem(processItemHandle, recursively);
            }
        }, monitor);
    }

    private IProcessDefinition doFindProcessDefinition(final String processId, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IProcessDefinition)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                return ProcessClientService.this.getService().findProcessDefinition(processId, null, propNames);
            }
        }, monitor);
    }

    private IProcessArea doFindProcessArea(final URI areaURI, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IProcessArea)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                return ProcessClientService.this.getService().findProcessArea(areaURI.toString(), propNames);
            }
        }, monitor);
    }

    private IItemsResponse doInitializeProjectArea(final IProjectArea projectArea, final IOperationConfigurationInfo info, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IItemsResponse)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ProcessClientService.this.getService().initializeProjectArea(projectArea, info);
                }
                catch (StaleDataException e) {
                    Object data = e.getData();
                    if (data instanceof IProjectArea) {
                        ProcessClientService.this.shareSingle((IItem)data);
                    }
                    throw e;
                }
            }
        }, monitor);
    }

    protected IObjectsResponse doArchiveProcessItem(final IProcessItem processItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IObjectsResponse response = (IObjectsResponse)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().archiveProcessItem(processItem);
            }
        }, monitor);
        IItemChangeReport changeReport = (IItemChangeReport)response.getClientObjects()[0];
        this.processChangeReport(changeReport);
        return response;
    }

    private IProcessService getService() {
        if (this.fProcessService == null) {
            this.fProcessService = (IProcessService)this.fContext.getServiceInterface(IProcessService.class);
        }
        return this.fProcessService;
    }

    private IItemManager getItemManager() {
        return this.fContext.teamRepository().itemManager();
    }

    private List processChangeReport(IItemChangeReport changeReport) throws TeamRepositoryException {
        IProcessItem[] deletedItems = changeReport.getDeletedProcessItems();
        IProcessItem[] addedItems = changeReport.getAddedProcessItems();
        IProcessItem[] updatedItems = changeReport.getUpdatedProcessItems();
        if (updatedItems != null && updatedItems.length > 0) {
            ArrayList<IProcessItem> toBeUpdated = new ArrayList<IProcessItem>(Arrays.asList(updatedItems));
            if (addedItems != null && addedItems.length > 0) {
                toBeUpdated.addAll(Arrays.asList(addedItems));
            }
            if (deletedItems != null && deletedItems.length > 0) {
                return this.getItemManager().applyItemUpdatesAndDeletes(toBeUpdated, Arrays.asList(deletedItems));
            }
            return this.shareList(toBeUpdated);
        }
        if (deletedItems != null && deletedItems.length > 0) {
            if (addedItems != null && addedItems.length > 0) {
                return this.getItemManager().applyItemUpdatesAndDeletes(Arrays.asList(addedItems), Arrays.asList(deletedItems));
            }
            this.unshareList(Arrays.asList(deletedItems));
            return Collections.EMPTY_LIST;
        }
        if (addedItems != null && addedItems.length > 0) {
            return this.shareList(Arrays.asList(addedItems));
        }
        return Collections.EMPTY_LIST;
    }

    protected IItem shareSingle(IItem item) throws TeamRepositoryException {
        if (item != null) {
            List items = this.getItemManager().applyItemUpdates(Collections.singletonList(item));
            Object shared = items.get(0);
            if (shared == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ProcessClientService.11"), (Object)item));
            }
            if (shared instanceof ITeamArea) {
                this.checkProjectArea((ITeamArea)shared);
            }
            return (IItem)shared;
        }
        return null;
    }

    private IItem setOrigin(IItem item) {
        ((ItemImpl)item).setOrigin((Object)this.fContext.teamRepository());
        return item;
    }

    private void checkProjectArea(ITeamArea area) throws TeamRepositoryException {
        IProjectAreaHandle projectAreaHandle = area.getProjectArea();
        if (projectAreaHandle == null) {
            return;
        }
        IProjectArea projectArea = (IProjectArea)this.getItemManager().getSharedItemIfKnown((IItemHandle)projectAreaHandle);
        if (projectArea != null) {
            Iterator teamAreas = projectArea.getTeamAreaHierarchy().getTeamAreas().iterator();
            IItemHandle teamAreaHandleToFind = area.getItemHandle();
            while (teamAreas.hasNext()) {
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreas.next();
                if (!teamAreaHandle.sameItemId(teamAreaHandleToFind)) continue;
                return;
            }
            ArrayList<IProjectArea> update = new ArrayList<IProjectArea>();
            update.add(projectArea);
            this.getItemManager().refreshSharedItems(update, null);
        }
    }

    private List shareList(List items) throws TeamRepositoryException {
        List sharedItems = this.getItemManager().applyItemUpdates(items);
        int i = 0;
        while (i < sharedItems.size()) {
            Object shared = sharedItems.get(i);
            if (shared == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ProcessClientService.12"), (Object)items.get(i).toString()));
            }
            ++i;
        }
        return sharedItems;
    }

    private void unshareList(List items) throws TeamRepositoryException {
        this.getItemManager().applyItemDeletes(items);
    }

    public List internalFetch(IItemQueryModel model, Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.internalFetch((IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model), 10, properties, monitor);
    }

    private List internalFetch(final IItemQuery query, final int pageSize, Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            final IQueryService queryService = this.getQueryService();
            IItemQueryPage page = (IItemQueryPage)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, pageSize);
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            List itemHandles = page.getItemHandles();
            SubProgressMonitor pageMonitor = new SubProgressMonitor(monitor, 800);
            pageMonitor.beginTask("", (int)Math.ceil((double)(page.getResultSize() - pageSize) / (double)pageSize) * 1000);
            while (page.hasNext()) {
                final UUID token = page.getToken();
                final int nextStartPosition = page.getNextStartPosition();
                page = (IItemQueryPage)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                    public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return queryService.fetchPage(token, nextStartPosition, pageSize);
                    }
                }, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 1000));
                itemHandles.addAll(page.getItemHandles());
            }
            List items = properties == null ? this.getItemManager().fetchCompleteItems(itemHandles, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100)) : this.getItemManager().fetchPartialItems(itemHandles, 0, properties, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            ListIterator iter = items.listIterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
            List list = items;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    public IQueryService getQueryService() {
        return (IQueryService)this.fContext.getServiceInterface(IQueryService.class);
    }

    public boolean isMailerServiceEnabled() {
        return this.getService().isMailerServiceEnabled();
    }

    private IProcessDefinition findProcessDefinitionInCache(String processId) {
        List processDefinitions = this.getItemManager().getKnownSharedItems(IProcessDefinition.ITEM_TYPE);
        for (IProcessDefinition definition : processDefinitions) {
            if (!definition.getProcessId().equals(processId)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            this.fWorkingCopyManager = new WorkingCopyManager();
        }
        return this.fWorkingCopyManager;
    }

    public ContentCache getContentCache() {
        if (this.fContentCache == null) {
            this.fContentCache = new ContentCache();
        }
        return this.fContentCache;
    }

    @Override
    public List findTeamAreaHierarchies(final IContributor user, final IProcessAreaHandle parent, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                List<ITeamArea> teamAreas = Arrays.asList(ProcessClientService.this.getService().findTeamAreaHierarchies(user, parent, propNames));
                return ProcessClientService.this.shareList(teamAreas);
            }
        }, this.getProgressMonitor(monitor));
    }

    @Override
    public List findTeamAreas(final IContributor user, final IProjectAreaHandle projectAreaHandle, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                List<ITeamArea> teamAreas = Arrays.asList(ProcessClientService.this.getService().findTeamAreas(user, projectAreaHandle, propNames));
                return ProcessClientService.this.shareList(teamAreas);
            }
        }, this.getProgressMonitor(monitor));
    }

    @Override
    public List findProcessAreas(final IContributor user, final IProjectAreaHandle projectAreaHandle, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                List<IProcessArea> processAreas = Arrays.asList(ProcessClientService.this.getService().findProcessAreas(user, projectAreaHandle, propNames));
                return ProcessClientService.this.shareList(processAreas);
            }
        }, this.getProgressMonitor(monitor));
    }

    public IAuditable[] fetchPredecessorStates(final IAuditable state, final int numPredecessors, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IAuditable[])this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                return ProcessClientService.this.getService().fetchPredecessorStates(state, numPredecessors, propNames);
            }
        }, this.getProgressMonitor(monitor));
    }

    public IProcessContainer[] fetchContentPredecessorStates(final IProcessContainer state, final int numPredecessors, final String contentKey, final Collection properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IProcessContainer[])this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] propNames = null;
                if (properties != null) {
                    propNames = properties.toArray(new String[properties.size()]);
                }
                return ProcessClientService.this.getService().fetchContentPredecessorStates(state, numPredecessors, contentKey, propNames);
            }
        }, this.getProgressMonitor(monitor));
    }

    private IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    public IProcessExtensionData getProcessExtensions(IProgressMonitor monitor) throws TeamRepositoryException {
        return (IProcessExtensionData)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().getProcessExtensions(null, null);
            }
        }, this.getProgressMonitor(monitor));
    }

    private IBundleFileContentService getExtensionSchemaContentService() throws ServiceNotAvailableException {
        if (this.fExtensionSchemaContentService == null) {
            this.fExtensionSchemaContentService = (IBundleFileContentService)this.fContext.getServiceInterface(IBundleFileContentService.class);
            if (this.fExtensionSchemaContentService == null) {
                throw new ServiceNotAvailableException(NLS.bind((String)Messages.getString("ProcessClientService.15"), (Object)this.fContext.teamRepository().getRepositoryURI()));
            }
        }
        return this.fExtensionSchemaContentService;
    }

    public TeamContent getExtensionSchemaContent(final String uri, IProgressMonitor monitor) throws TeamRepositoryException {
        return (TeamContent)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ProcessClientService.this.getExtensionSchemaContentService().get(uri);
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        }, monitor);
    }

    @Override
    public List fetchCompleteIterationStructure(final IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessItem[] items = ProcessClientService.this.getService().fetchCompleteIterationStructure(projectAreaHandle, null, null, null);
                return ProcessClientService.this.shareList(Arrays.asList(items));
            }
        }, monitor);
    }

    @Override
    public List findAdministratorsFor(final IProcessAreaHandle areaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IContributor[] admins = ProcessClientService.this.getService().findAdministratorsFor(areaHandle);
                return ProcessClientService.this.shareList(Arrays.asList(admins));
            }
        }, monitor);
    }

    public IProcessDefinition createProcessDefinitionFromProjectArea(final IProjectAreaHandle projectAreaHandle, final String newDefinitionName, final String newProcessId, final String summary, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        return (IProcessDefinition)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemsResponse response = ProcessClientService.this.getService().createProcessDefinitionFromProjectArea(projectAreaHandle, newDefinitionName, newProcessId, summary);
                IItem[] items = response.getClientItems();
                ProcessClientService.this.shareList(Arrays.asList(items));
                int i = 0;
                while (i < items.length) {
                    IItem item = items[i];
                    if (item instanceof IProcessDefinition) {
                        return item;
                    }
                    ++i;
                }
                return null;
            }
        }, monitor);
    }

    @Override
    public IProcessDefinition[] deployPredefinedProcessDefinitions(final String[] processIds, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IProcessDefinition[] definitions = (IProcessDefinition[])this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    IProcessDefinition[] definitions = ProcessClientService.this.getService().deployPredefinedProcessDefinitions(null, processIds);
                    return definitions;
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            try {
                List definitionsWithTranslations = this.fetchDefinitionsWithTranslations(Arrays.asList(definitions), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                definitions = definitionsWithTranslations.toArray(new IProcessDefinition[definitionsWithTranslations.size()]);
            }
            catch (ServiceNotAvailableException serviceNotAvailableException) {}
            this.shareList(Arrays.asList(definitions));
            IProcessDefinition[] iProcessDefinitionArray = definitions;
            return iProcessDefinitionArray;
        }
        finally {
            monitor.done();
        }
    }

    public void validateConfigurationInfo(final IOperationConfigurationInfo configurationInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ProcessClientService.this.getService().validateConfigurationInfo(configurationInfo);
                return null;
            }
        }, monitor);
    }

    public <T> T callCancelableService(IClientLibraryContext.IServiceRunnable<T> runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)this.fContext.callCancelableService(runnable, monitor);
    }

    public IItemQueryPage queryItems(final IItemQuery itemQuery, final Object[] queryParameters, final int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IItemQueryPage)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getQueryService().queryItems(itemQuery, queryParameters, pageSize);
            }
        }, monitor);
    }

    public IDataQueryPage queryData(final IDataQuery query, final Object[] queryParameters, final int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IDataQueryPage)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getQueryService().queryData(query, queryParameters, pageSize);
            }
        }, monitor);
    }

    public IQueryPage fetchPage(final UUID token, final int nextStartPosition, final int queryPageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IQueryPage)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getQueryService().fetchPage(token, nextStartPosition, queryPageSize);
            }
        }, monitor);
    }

    public boolean assertPermission(final String roleName, IProgressMonitor monitor) throws TeamRepositoryException {
        final IPermissionService permissionService = (IPermissionService)this.fContext.getServiceInterface(IPermissionService.class);
        Boolean hasPermission = (Boolean)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    permissionService.assertPermission(roleName);
                    return Boolean.TRUE;
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    return Boolean.FALSE;
                }
            }
        }, monitor);
        return hasPermission;
    }

    @Override
    public Boolean isProjectAreaUpdateable(final IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().isProjectAreaUpdateable((IProjectAreaHandle)projectArea);
            }
        }, monitor);
    }

    @Override
    public IProjectArea[] updateProjectAreas(final IProjectAreaHandle[] areasToUpdate, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea[] updatedAreas = (IProjectArea[])this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProjectArea[] updateAreas = ProcessClientService.this.getService().updateProjectAreas(areasToUpdate);
                List shared = ProcessClientService.this.shareList(Arrays.asList(updateAreas));
                return shared.toArray(new IProjectArea[shared.size()]);
            }
        }, monitor);
        return updatedAreas;
    }

    @Override
    public IProjectArea[] getUpdateableProjectAreas(final IProjectAreaHandle[] projectAreaHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea[] updateableAreas = (IProjectArea[])this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProjectArea[] areas = ProcessClientService.this.getService().getUpdateableProjectAreas(projectAreaHandles);
                List shared = ProcessClientService.this.shareList(Arrays.asList(areas));
                return shared.toArray(new IProjectArea[shared.size()]);
            }
        }, monitor);
        return updateableAreas;
    }

    @Override
    public IProjectArea[] getAllProcessProviders(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea[] updateableAreas = (IProjectArea[])this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProjectArea[] areas = ProcessClientService.this.getService().getAllProcessProviders();
                List shared = ProcessClientService.this.shareList(Arrays.asList(areas));
                return shared.toArray(new IProjectArea[shared.size()]);
            }
        }, monitor);
        return updateableAreas;
    }

    @Override
    public Boolean isOslcCoreEnabled(IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().isOslcCoreEnabled();
            }
        }, monitor);
    }

    @Override
    public String getTitleForRemoteSever(final String url, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ProcessClientService.this.getService().getTitleForRemoteServer(url);
            }
        }, monitor);
    }

    @Override
    public String getURIForProcessArea(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        String[] endSegments = new String[]{};
        if (processArea instanceof ITeamArea) {
            endSegments = new String[]{TEAM_AREAS_SEGMENT, processArea.getItemId().getUuidValue()};
        }
        ITeamRepository repo = (ITeamRepository)processArea.getOrigin();
        String repositoryURI = this.getTeamRepositoryURL(repo);
        String url = String.valueOf(repositoryURI) + PROCESS_PROJECT_AREAS_SEGMENT + processArea.getProjectArea().getItemId().getUuidValue();
        String[] stringArray = endSegments;
        int n = endSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            url = String.valueOf(url) + "/";
            url = String.valueOf(url) + segment;
            ++n2;
        }
        return url;
    }

    private String getTeamRepositoryURL(ITeamRepository repo) {
        String repositoryURL = repo.getRepositoryURI();
        repositoryURL = repositoryURL.replace("/jazz/secure", "/jazz");
        if ((repositoryURL = repositoryURL.replace("/jazz/team", "/jazz")).endsWith("/")) {
            repositoryURL = repositoryURL.substring(0, repositoryURL.length() - 1);
        }
        return repositoryURL;
    }

    @Override
    public void refreshProcessCache() {
        ThinClientProcess.clearCache();
    }

    @Override
    public IContributorHandle[] getContributorsWithRole(final IContributorHandle[] contributors, final IProcessAreaHandle processArea, final String[] roleIds, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IContributorHandle[])this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IContributorHandle[]>(){

            public IContributorHandle[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", 1000);
                try {
                    IContributorHandle[] iContributorHandleArray = ProcessClientService.this.getService().getContributorsWithRole(contributors, processArea, roleIds);
                    return iContributorHandleArray;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    @Override
    public IProcessInternalClientService.ITeamInvitation getTeamInvitation(String processAreaItemId, String repositoryUrl, String[] inviteesItemId) throws TeamRepositoryException {
        JSONObject invitationJson;
        String invitationContent = this.getService().generateEmailSubjectAndBodyWithInvitees(processAreaItemId, repositoryUrl, inviteesItemId);
        try {
            invitationJson = JSONObject.parse((Reader)new StringReader(invitationContent));
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return new IProcessInternalClientService.ITeamInvitation(){

            @Override
            public String getEmailSubject() {
                return XMLUtil.unescapeXML((String)((String)invitationJson.get((Object)"emailSubject")));
            }

            @Override
            public String getEmailBody() {
                return XMLUtil.unescapeXML((String)((String)invitationJson.get((Object)"emailBody")));
            }

            @Override
            public boolean getCopySelf() {
                return (Boolean)invitationJson.get((Object)"copySelf");
            }
        };
    }

    @Override
    public List getInheritedIterationTypes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IIterationType[] iterationTypes = this.getService().getInheritedIterationTypes(projectArea);
            List list = this.shareList(Arrays.asList(iterationTypes));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public HashMap getContributorToTeamAreaNames(final String[] contributorItemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorItemIds == null || contributorItemIds.length == 0) {
            return new HashMap();
        }
        return (HashMap)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                HashMap rtnValue = new HashMap();
                String contributorToTeamAreaNamesJsonArrayString = ProcessClientService.this.getService().getContributorToTeamAreaNames(contributorItemIds);
                if (contributorToTeamAreaNamesJsonArrayString != null && contributorToTeamAreaNamesJsonArrayString.length() > 0) {
                    JSONArray contributorToTeamAreaNamesJsonArray = null;
                    try {
                        contributorToTeamAreaNamesJsonArray = JSONArray.parse((Reader)new StringReader(contributorToTeamAreaNamesJsonArrayString));
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                    if (contributorToTeamAreaNamesJsonArray != null) {
                        int i = 0;
                        while (i < contributorToTeamAreaNamesJsonArray.size()) {
                            JSONObject contributorToTeamAreaNamesJson = (JSONObject)contributorToTeamAreaNamesJsonArray.get(i);
                            String contributorItemId = (String)contributorToTeamAreaNamesJson.keySet().iterator().next();
                            JSONArray teamAreaNamesJsonArray = (JSONArray)contributorToTeamAreaNamesJson.get((Object)contributorItemId);
                            ArrayList<Object> teamAreaNames = new ArrayList<Object>();
                            int j = 0;
                            while (j < teamAreaNamesJsonArray.size()) {
                                JSONObject teamAreaNameJson = (JSONObject)teamAreaNamesJsonArray.get(j);
                                teamAreaNames.add(teamAreaNameJson.get((Object)"name"));
                                ++j;
                            }
                            rtnValue.put(UUID.valueOf((String)contributorItemId), teamAreaNames);
                            ++i;
                        }
                    }
                }
                return rtnValue;
            }
        }, this.getProgressMonitor(monitor));
    }
}

