/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_def;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetDefTree {
    private String name;
    private PropSheetDef propSheetDef;
    private List<PropSheetDefTree> children = new ArrayList<PropSheetDefTree>();
    private List<String> ignoreList = new ArrayList<String>();

    public PropSheetDefTree(String name, PropSheetDef propSheetDef) {
        this.name = name;
        this.propSheetDef = propSheetDef;
    }

    public String getName() {
        return this.name;
    }

    public PropSheetDef getPropSheetDef() {
        return this.propSheetDef;
    }

    public void addPropSheetDefTree(PropSheetDefTree childTree) {
        if (!this.children.contains(childTree)) {
            this.children.add(childTree);
        }
    }

    public List<PropSheetDefTree> getChildPropSheetDefTreeList() {
        return Collections.unmodifiableList(this.children);
    }

    public PropSheetDefTree getChildPropSheetDefTree(String name) {
        PropSheetDefTree result = null;
        for (PropSheetDefTree child : this.children) {
            if (!child.getName().equals(name)) continue;
            result = child;
        }
        return result;
    }

    public void ignoreProperty(String propertyName) {
        int firstSlash = propertyName.indexOf("/");
        if (firstSlash >= 0) {
            String childName = propertyName.substring(0, firstSlash);
            String remainingName = propertyName.substring(firstSlash + 1);
            PropSheetDefTree child = this.getChildPropSheetDefTree(childName);
            if (child != null) {
                child.ignoreProperty(remainingName);
            }
        } else {
            this.ignoreList.add(propertyName);
        }
    }

    public boolean isIgnoring(String propertyName) {
        boolean result = false;
        if (this.ignoreList.contains(propertyName)) {
            result = true;
        }
        return result;
    }

    public Map<String, String> resolve(Map<String, String> submittedProperties) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Object> properties = new ArrayList();
        if (this.propSheetDef != null) {
            properties = this.propSheetDef.getPropDefList();
        }
        for (PropDef property : properties) {
            String propValue;
            String propertyName = property.getName();
            if (this.isIgnoring(propertyName) || (propValue = submittedProperties.get(propertyName)) == null) continue;
            result.put(property.getName(), propValue);
        }
        for (PropSheetDefTree child : this.children) {
            HashMap<String, String> submittedChildProperties = new HashMap<String, String>();
            String childName = child.getName();
            String childPrefix = childName + "/";
            for (Map.Entry<String, String> submittedEntry : submittedProperties.entrySet()) {
                String propertyName = submittedEntry.getKey();
                if (!propertyName.startsWith(childPrefix)) continue;
                String childPropertyName = propertyName.substring(childPrefix.length());
                submittedChildProperties.put(childPropertyName, submittedEntry.getValue());
            }
            Map<String, String> childProperties = child.resolve(submittedChildProperties);
            for (Map.Entry<String, String> resolvedEntry : childProperties.entrySet()) {
                String propertyName = resolvedEntry.getKey();
                String propValue = resolvedEntry.getValue();
                result.put(child.getName() + "/" + propertyName, propValue);
            }
        }
        return result;
    }

    public boolean isPropertySecure(String propertyName) {
        PropDef propDef;
        boolean result = false;
        int firstSlash = propertyName.indexOf("/");
        if (firstSlash >= 0) {
            String childName = propertyName.substring(0, firstSlash);
            String remainingName = propertyName.substring(firstSlash + 1);
            PropSheetDefTree child = this.getChildPropSheetDefTree(childName);
            if (child != null) {
                result = child.isPropertySecure(remainingName);
            }
        } else if (this.propSheetDef != null && (propDef = this.propSheetDef.getPropDef(propertyName)) != null && propDef.isSecure()) {
            result = true;
        }
        return result;
    }

    public boolean isValueValid(String propertyName, String propValue) {
        PropDef propDef;
        boolean result = true;
        int firstSlash = propertyName.indexOf("/");
        if (firstSlash >= 0) {
            String childName = propertyName.substring(0, firstSlash);
            String remainingName = propertyName.substring(firstSlash + 1);
            PropSheetDefTree child = this.getChildPropSheetDefTree(childName);
            if (child != null) {
                result = child.isValueValid(remainingName, propValue);
            }
        } else if (this.propSheetDef != null && (propDef = this.propSheetDef.getPropDef(propertyName)) != null && !propDef.isValidValue(propValue)) {
            result = false;
        }
        return result;
    }

    public PropDef getPropDef(String propertyName) {
        int firstSlash;
        PropSheetDef propSheetDef = this.getPropSheetDef();
        PropDef result = null;
        if (propSheetDef != null) {
            result = propSheetDef.getPropDef(propertyName);
        }
        if (result == null && (firstSlash = propertyName.indexOf("/")) >= 0) {
            String childName = propertyName.substring(0, firstSlash);
            String propDefName = propertyName.substring(firstSlash + 1);
            PropSheetDefTree childTree = this.getChildPropSheetDefTree(childName);
            if (childTree != null) {
                result = childTree.getPropDef(propDefName);
            }
        }
        return result;
    }
}

