/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.daemon;

import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class JSONMethod {
    protected Object receiver;
    protected Method method;
    protected Class<? extends IValidatingParameterWrapper> parameterType;
    protected boolean takesProgress;
    protected Field[] parameterFields;
    protected Class<?> returnType;

    public JSONMethod(Object receiver, Method m) {
        this.receiver = receiver;
        this.method = m;
        Class<?>[] params = m.getParameterTypes();
        if (params.length == 1) {
            if (IValidatingParameterWrapper.class.isAssignableFrom(params[0])) {
                this.parameterType = params[0].asSubclass(IValidatingParameterWrapper.class);
            } else {
                this.takesProgress = true;
            }
        } else if (params.length == 2) {
            this.parameterType = params[0].asSubclass(IValidatingParameterWrapper.class);
            this.takesProgress = true;
        }
        this.initParameterFields();
        this.returnType = m.getReturnType();
    }

    protected void initParameterFields() {
        if (this.parameterType != null) {
            Field[] fld = this.parameterType.getDeclaredFields();
            ArrayList<Field> selected = new ArrayList<Field>(fld.length);
            Field[] fieldArray = fld;
            int n = fld.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                int modifiers = f.getModifiers();
                if (Modifier.isPublic(modifiers) && !Modifier.isTransient(modifiers)) {
                    selected.add(f);
                }
                ++n2;
            }
            this.parameterFields = selected.toArray(new Field[selected.size()]);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public Class<? extends IValidatingParameterWrapper> getParameterType() {
        return this.parameterType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Field[] getParameterFields() {
        return this.parameterFields;
    }

    public boolean takesProgress() {
        return this.takesProgress;
    }
}

