/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal.util;

import com.ibm.team.repository.client.internal.nls.Messages;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MonitoredOutputStream
extends FilterOutputStream {
    private int numAttempts;
    private final IProgressMonitor monitor;
    private final long estimatedBytes;
    private long writtenBytes;
    private boolean cancellable;

    public MonitoredOutputStream(OutputStream out, int numAttempts, long estimatedBytes, IProgressMonitor monitor) {
        super(out);
        this.numAttempts = numAttempts;
        this.estimatedBytes = estimatedBytes;
        this.cancellable = true;
        this.monitor = monitor;
        if (this.monitor != null) {
            this.monitor.beginTask(null, 100);
        }
    }

    @Override
    public void write(int b) throws IOException {
        int attempts = 0;
        while (true) {
            this.cancelIfRequested();
            try {
                this.out.write(b);
                this.advance(1L);
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.getServerString("MonitoredOutputStream.WriteTimeout"));
            }
            break;
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        int len = length;
        int off = offset;
        int count = 0;
        int attempts = 0;
        while (true) {
            this.cancelIfRequested();
            try {
                this.out.write(buffer, off, len);
                this.advance(len);
                return;
            }
            catch (InterruptedIOException e) {
                int amount = e.bytesTransferred;
                if (amount <= 0) continue;
                this.advance(amount);
                if ((len -= amount) <= 0) {
                    return;
                }
                off += amount;
                count += amount;
                attempts = 0;
                if (++attempts != this.numAttempts) continue;
                e = new InterruptedIOException(Messages.getServerString("MonitoredOutputStream.WriteTimeout"));
                e.bytesTransferred = count;
                throw e;
            }
            break;
        }
    }

    @Override
    public void flush() throws IOException {
        int count = 0;
        int attempts = 0;
        while (true) {
            this.cancelIfRequested();
            try {
                this.out.flush();
                return;
            }
            catch (InterruptedIOException e) {
                int amount = e.bytesTransferred;
                if (amount <= 0) continue;
                count += amount;
                attempts = 0;
                if (++attempts != this.numAttempts) continue;
                e = new InterruptedIOException(Messages.getServerString("MonitoredOutputStream.WriteTimeout"));
                e.bytesTransferred = count;
                throw e;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() throws IOException {
        attempts = this.numAttempts - 1;
        try {
            this.out.flush();
            attempts = 0;
        }
        finally {
            stop = false;
            ** while (!stop)
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.out.close();
                stop = true;
                continue;
            }
            catch (InterruptedIOException v0) {
                this.cancelIfRequested();
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(Messages.getServerString("MonitoredOutputStream.CloseTimeout"));
            }
        }
lbl17:
        // 1 sources

        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private void cancelIfRequested() {
        if (this.cancellable && this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void advance(long count) {
        if (this.monitor != null) {
            int oldPercent = (int)(this.writtenBytes * 100L / this.estimatedBytes);
            this.writtenBytes += count;
            int newPercent = (int)(this.writtenBytes * 100L / this.estimatedBytes);
            this.monitor.worked(newPercent - oldPercent);
        }
    }
}

