/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.login.AbstractLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.InvalidCertificateOrSmartcardException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public abstract class KeyStoreLoginInfo
extends AbstractLoginInfo {
    private static final Log LOGGER = LogFactory.getLog(KeyStoreLoginInfo.class);
    private volatile KeyStore keyStore;

    protected static void logException(String message, Throwable exception) {
        LOGGER.error((Object)message, exception);
    }

    protected static void logException(Throwable exception) {
        String message = exception.getMessage();
        KeyStoreLoginInfo.logException(message, exception);
    }

    protected static void logInfo(String message, Throwable exception) {
        LOGGER.info((Object)message, exception);
    }

    protected static void logWarn(String message, Throwable exception) {
        LOGGER.warn((Object)message, exception);
    }

    protected KeyStoreLoginInfo() {
    }

    protected KeyStoreLoginInfo(String password) {
        this.setPassword(password);
    }

    private KeyStore basicGetKeyStore() {
        return this.keyStore;
    }

    protected void collectAliases(List<String> aliases) throws KeyStoreException, AuthenticationException {
        KeyStore ks = this.getKeyStore();
        Enumeration<String> enumeration = ks.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            boolean exists = aliases.contains(alias);
            if (exists) continue;
            aliases.add(alias);
        }
    }

    protected abstract KeyStore createKeyStore() throws KeyStoreException;

    public final List<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>(5);
        try {
            this.collectAliases(aliases);
            Collections.sort(aliases);
        }
        catch (AuthenticationException authenticationException) {
            String message = Messages.getClientString("KeyStoreLoginInfo.FailedToAliases");
            KeyStoreLoginInfo.logWarn(message, null);
        }
        catch (KeyStoreException exception) {
            KeyStoreLoginInfo.logException(exception);
        }
        return aliases;
    }

    protected KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    }

    protected final KeyManager[] getKeyManagers() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, AuthenticationException, TeamRepositoryException {
        KeyManagerFactory factory = this.getKeyManagerFactory();
        KeyStore ks = this.getKeyStore();
        if (ks == null) {
            return new KeyManager[0];
        }
        char[] password = this.getPasswordCharacters();
        factory.init(ks, password);
        return factory.getKeyManagers();
    }

    protected final KeyStore getKeyStore() throws AuthenticationException {
        this.initializeKeyStore();
        return this.basicGetKeyStore();
    }

    protected final KeyStore getKeyStore(String type) throws KeyStoreException {
        return KeyStore.getInstance(type);
    }

    protected final char[] getPasswordCharacters() {
        String password = null;
        try {
            password = this.getPassword();
        }
        catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {}
        return password != null ? password.toCharArray() : new char[]{};
    }

    @Override
    public final void handleCredentials(ITeamServer teamServer) throws TeamRepositoryException {
        try {
            KeyManager[] keyManagers = this.getKeyManagers();
            teamServer.setCredentials(keyManagers);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public void initialize() throws TeamRepositoryException {
        super.initialize();
        this.initializeKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeyStore() throws AuthenticationException {
        KeyStoreLoginInfo keyStoreLoginInfo = this;
        synchronized (keyStoreLoginInfo) {
            if (this.basicGetKeyStore() != null) {
                return;
            }
            KeyStore ks = this.loadKeyStore();
            this.setKeyStore(ks);
        }
    }

    @Override
    public boolean isValidLoginInfo() {
        KeyStore ks;
        try {
            ks = this.getKeyStore();
        }
        catch (AuthenticationException e) {
            KeyStoreLoginInfo.logException(e);
            return false;
        }
        return ks != null;
    }

    private KeyStore loadKeyStore() throws AuthenticationException {
        KeyStore keyStore;
        block11: {
            KeyStore ks;
            try {
                ks = this.createKeyStore();
            }
            catch (KeyStoreException e) {
                throw new InvalidCertificateOrSmartcardException(Messages.getClientString("KeyStoreLoginInfo.ERROR_INITIALIZING"), (Throwable)e);
            }
            InputStream stream = this.openKeyStoreInputStream();
            char[] password = this.getPasswordCharacters();
            try {
                ks.load(stream, password);
                keyStore = ks;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (CertificateException e) {
                    throw new InvalidCertificateOrSmartcardException(Messages.getClientString("KeyStoreLoginInfo.LOAD_CERTIFICATE_ERROR"), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new InvalidCertificateOrSmartcardException(Messages.getClientString("KeyStoreLoginInfo.CERTIFICATE_DOESNT_EXIST"), (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    String pattern = Messages.getClientString("KeyStoreLoginInfo.UNSUPPORTED_ENCRYPTION_ALGORITHM");
                    String type = ks.getType();
                    String message = NLS.bind((String)pattern, (Object)type);
                    throw new InvalidCertificateOrSmartcardException(message, (Throwable)e);
                }
                catch (IOException e) {
                    Throwable cause = e.getCause();
                    boolean badPassword = cause instanceof UnrecoverableKeyException || cause instanceof BadPaddingException;
                    String key = badPassword ? "KeyStoreLoginInfo.INVALID_PASSWORD" : "KeyStoreLoginInfo.UNSUPPORTED_ENCRYPTION_KEY_SIZE";
                    throw new InvalidCertificateOrSmartcardException(Messages.getClientString(key), (Throwable)e);
                }
            }
            stream.close();
        }
        return keyStore;
    }

    protected InputStream openKeyStoreInputStream() throws IOException {
        return null;
    }

    private void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public boolean validateLoggedInUser(String name, String userid) {
        return true;
    }
}

