/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.treedifferencer;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.textdifferencer.IDiffFormat;
import com.ibm.team.foundation.common.textdifferencer.TextDifferencer;
import com.ibm.team.foundation.common.treedifferencer.ITree;
import com.ibm.team.foundation.common.treedifferencer.TreeComparator;
import com.ibm.team.foundation.common.treedifferencer.TreeDifference;
import com.ibm.team.foundation.common.treedifferencer.XMLTransformationCost;
import com.ibm.team.foundation.common.treedifferencer.XMLTree;
import com.ibm.team.foundation.common.treedifferencer.XMLTreeParser;
import java.util.Iterator;
import java.util.Map;

public class XMLStringDifferencer {
    public XMLString diff(XMLString oldText, XMLString newText) {
        return this.diff(oldText, newText, new TextDifferencer.DefaultFormat());
    }

    public XMLString diff(XMLString oldText, XMLString newText, IDiffFormat format) {
        XMLTree oldTree = new XMLTreeParser().parse(oldText);
        XMLTree newTree = new XMLTreeParser().parse(newText);
        TreeDifference difference = new TreeComparator().findDifferences(oldTree, newTree, new XMLTransformationCost());
        StringBuilder result = new StringBuilder();
        this.process(newTree, difference, result, format);
        return XMLString.createFromXMLText(result.toString());
    }

    private void process(XMLTree node, TreeDifference treeDiff, StringBuilder result, IDiffFormat format) {
        boolean wasParentRemoved;
        boolean isAdded = treeDiff.getAdded().contains(node);
        boolean isChanged = treeDiff.getChanged().containsKey(node);
        XMLTree oldNode = (XMLTree)treeDiff.getMapping().get(node);
        boolean bl = wasParentRemoved = oldNode != null ? treeDiff.getRemoved().contains(oldNode.getParent()) : false;
        if (wasParentRemoved) {
            result.append(format.inserted(node.getContent().getXMLText()));
        } else if (isChanged) {
            this.processChange(node, treeDiff, result, format);
        } else if (isAdded) {
            this.processAddition(node, treeDiff, result, format);
        } else {
            result.append(format.unchanged(this.outerHtml(node, treeDiff, format)));
        }
    }

    private void processChange(XMLTree node, TreeDifference treeDiff, StringBuilder result, IDiffFormat format) {
        XMLTree original = (XMLTree)treeDiff.getChanged().get(node).getNode();
        if (node.isTextNode() && original.isTextNode()) {
            result.append(TextDifferencer.diff(original.getContent().getXMLText(), node.getContent().getXMLText(), format, null));
        } else {
            result.append(format.deleted(original.getContent().getXMLText()));
            result.append(format.inserted(node.getContent().getXMLText()));
        }
    }

    private void processAddition(XMLTree node, TreeDifference treeDiff, StringBuilder result, IDiffFormat format) {
        for (ITree c : node.getChildren()) {
            if (treeDiff.getAdded().contains(c)) continue;
            result.append(format.deleted(((XMLTree)c).getContent().getXMLText()));
        }
        result.append(format.inserted(node.getContent().getXMLText()));
    }

    private String outerHtml(XMLTree node, TreeDifference treeDiff, IDiffFormat format) {
        StringBuilder content = new StringBuilder();
        this.startTag(node, content);
        this.content(node, treeDiff, format, content);
        this.endTag(node, content);
        return content.toString();
    }

    private void startTag(XMLTree node, StringBuilder content) {
        if (node.getTag() != null) {
            content.append("<" + node.getTag() + " " + node.getAttributes());
            if (node.isSelfClosing()) {
                content.append("/");
            }
            content.append(">");
        }
    }

    private void content(XMLTree node, TreeDifference treeDiff, IDiffFormat format, StringBuilder content) {
        if (node.isSelfClosing()) {
            return;
        }
        if (node.getChildren().size() == 0) {
            content.append(node.getContent());
            return;
        }
        Map<ITree, ITree> treeMapping = treeDiff.getMapping();
        ITree originalNode = treeMapping.get(node);
        Iterator<ITree> oldChildrenIt = originalNode != null ? originalNode.getChildren().iterator() : null;
        for (ITree c : node.getChildren()) {
            ITree oldChild = treeMapping.get(c);
            if (oldChild != null && oldChildrenIt != null) {
                while (oldChildrenIt.hasNext()) {
                    ITree c2 = oldChildrenIt.next();
                    if (c2 == oldChild) break;
                    if (!treeDiff.getRemoved().contains(c2)) continue;
                    content.append(format.deleted(((XMLTree)c2).getContent().getXMLText()));
                }
            }
            this.process((XMLTree)c, treeDiff, content, format);
        }
        while (oldChildrenIt != null && oldChildrenIt.hasNext()) {
            ITree c2 = oldChildrenIt.next();
            if (!treeDiff.getRemoved().contains(c2)) continue;
            content.append(format.deleted(((XMLTree)c2).getContent().getXMLText()));
        }
    }

    private void endTag(XMLTree node, StringBuilder content) {
        if (!node.isSelfClosing() && node.getTag() != null) {
            content.append("</" + node.getTag() + ">");
        }
    }
}

