/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.util;

import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class XMLNamespaceUtil {
    public static Map<String, String> getReferencedNamespaces(EObject eObject) {
        HashMap<String, String> referencedNamespaceHashMap = new HashMap<String, String>();
        XMLNamespaceUtil.addReferencedNamespaces(eObject, referencedNamespaceHashMap);
        XMLNamespaceUtil.getReferencedNamespacesInEReferences(eObject, referencedNamespaceHashMap);
        return referencedNamespaceHashMap;
    }

    private static void getReferencedNamespacesInEReferences(EObject eObject, Map<String, String> referencedNamespaceHashMap) {
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!MarshallerUtil.shouldBeMarshalled(eObject, (EStructuralFeature)reference)) continue;
            if (MarshallerUtil.shouldConsiderAsContainment(reference)) {
                XMLNamespaceUtil.getReferencedNamespacedInContainmentReferences(eObject, reference, referencedNamespaceHashMap);
                continue;
            }
            XMLNamespaceUtil.getReferencedNamespacedInAssociationReferences(eObject, reference, referencedNamespaceHashMap);
        }
    }

    private static void addReferencedNamespaces(EObject eObject, Map<String, String> nsPrefixToNsURIMap) {
        EPackage ePackage = eObject.eClass().getEPackage();
        String namespacePrefix = ePackage.getNsPrefix();
        if (!nsPrefixToNsURIMap.containsKey(namespacePrefix)) {
            nsPrefixToNsURIMap.put(namespacePrefix, ePackage.getNsURI());
        } else {
            String nsURI = nsPrefixToNsURIMap.get(namespacePrefix);
            if (!ePackage.getNsURI().equals(nsURI)) {
                String newNsPrefix = XMLNamespaceUtil.constructUniqueNsPrefix(namespacePrefix, nsPrefixToNsURIMap);
                nsPrefixToNsURIMap.put(newNsPrefix, ePackage.getNsURI());
            }
        }
    }

    private static String constructUniqueNsPrefix(String nsPrefix, Map<String, String> nsPrefixToNsURIMap) {
        int i = 1;
        String newNsPrefix;
        while (nsPrefixToNsURIMap.containsKey(newNsPrefix = String.valueOf(nsPrefix) + i)) {
            ++i;
        }
        return newNsPrefix;
    }

    private static void getReferencedNamespacedInAssociationReferences(EObject eObject, EReference reference, Map<String, String> referencedNamespaceHashMap) {
        if (reference.isMany()) {
            List objectValues = (List)eObject.eGet((EStructuralFeature)reference);
            if (objectValues != null) {
                for (EObject objectValue : objectValues) {
                    XMLNamespaceUtil.addReferencedNamespaces(objectValue, referencedNamespaceHashMap);
                }
            }
        } else {
            EObject objectValue = (EObject)eObject.eGet((EStructuralFeature)reference);
            if (objectValue != null) {
                XMLNamespaceUtil.addReferencedNamespaces(objectValue, referencedNamespaceHashMap);
            }
        }
    }

    private static void getReferencedNamespacedInContainmentReferences(EObject eObject, EReference reference, Map<String, String> referencedNamespaceHashMap) {
        if (reference.isMany()) {
            List objectValues = (List)eObject.eGet((EStructuralFeature)reference);
            if (objectValues != null) {
                for (EObject containedObject : objectValues) {
                    XMLNamespaceUtil.addReferencedNamespaces(containedObject, referencedNamespaceHashMap);
                    XMLNamespaceUtil.getReferencedNamespacesInEReferences(containedObject, referencedNamespaceHashMap);
                }
            }
        } else {
            EObject containedObject = (EObject)eObject.eGet((EStructuralFeature)reference);
            if (containedObject != null) {
                XMLNamespaceUtil.addReferencedNamespaces(containedObject, referencedNamespaceHashMap);
                XMLNamespaceUtil.getReferencedNamespacesInEReferences(containedObject, referencedNamespaceHashMap);
            }
        }
    }

    public static Map<String, String> constructNsURIToNsPrefixMap(Map<String, String> nsPrefixToNsURIMap) {
        HashMap<String, String> nsURIToNsPrefixMap = new HashMap<String, String>(nsPrefixToNsURIMap.size() * 2);
        for (Map.Entry<String, String> entry : nsPrefixToNsURIMap.entrySet()) {
            nsURIToNsPrefixMap.put(entry.getValue(), entry.getKey());
        }
        return nsURIToNsPrefixMap;
    }
}

