/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateFilter {
    private String name;
    private Map<String, Stack<Object>> filterParameters = new HashMap<String, Stack<Object>>();

    public HibernateFilter(String name) {
        this.setName(name);
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Set<Map.Entry<String, Stack<Object>>> entrySet = this.filterParameters.entrySet();
        for (Map.Entry<String, Stack<Object>> entry : entrySet) {
            String paramName = entry.getKey();
            Object paramValue = this.peekParameter(paramName);
            if (paramValue == null) continue;
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }

    public Object peekParameter(String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException("The parameter paramName must be non-null.");
        }
        try {
            return this.filterParameters.get(paramName).peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public void pushParameter(String paramName, Object paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("The parameter paramName must be non-null.");
        }
        if (paramValue == null) {
            throw new IllegalArgumentException("The parameter paramValue must be non-null.");
        }
        Stack<Object> paramValues = this.filterParameters.get(paramName);
        if (paramValues == null) {
            paramValues = new Stack();
            this.filterParameters.put(paramName, paramValues);
        }
        paramValues.push(paramValue);
    }

    public Object popParameter(String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException("The parameter paramName must be non-null.");
        }
        Object oldValue = null;
        Stack<Object> paramValues = this.filterParameters.get(paramName);
        if (paramValues != null) {
            try {
                oldValue = paramValues.pop();
            }
            catch (EmptyStackException e) {
                this.filterParameters.remove(paramName);
            }
        }
        return oldValue;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter name must be non-null.");
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof HibernateFilter) {
            return this.getName().equals(((HibernateFilter)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

