/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.workitem.common.internal.attributeValueProviders.AbstractConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class CachableConfiguration
extends AbstractConfiguration {
    private final String fElementName;
    private final Map<String, String> fAttributes;
    private final List<IConfiguration> fConfigurationEntries;

    public CachableConfiguration(IProcessConfigurationElement definition) {
        Assert.isNotNull((Object)definition);
        this.fElementName = definition.getName();
        String[] attributeNames = definition.getAttributeNames();
        this.fAttributes = new HashMap<String, String>(attributeNames.length + 5);
        String[] stringArray = attributeNames;
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            this.fAttributes.put(attributeName, definition.getAttribute(attributeName));
            ++n2;
        }
        IProcessConfigurationElement[] children = definition.getChildren();
        this.fConfigurationEntries = new ArrayList<IConfiguration>(children.length + 5);
        IProcessConfigurationElement[] iProcessConfigurationElementArray = children;
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            IProcessConfigurationElement child = iProcessConfigurationElementArray[n];
            this.fConfigurationEntries.add(new CachableConfiguration(child));
            ++n;
        }
    }

    public CachableConfiguration(IConfiguration definition, IProcessConfigurationElement customization) {
        Assert.isNotNull((Object)definition);
        this.fElementName = definition.getElementName();
        List<String> attributeNames = definition.getAttributeNames();
        this.fAttributes = new HashMap<String, String>(attributeNames.size() + 5);
        for (String attributeName : attributeNames) {
            this.fAttributes.put(attributeName, definition.getString(attributeName));
        }
        this.fConfigurationEntries = new ArrayList<IConfiguration>();
        if (customization != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = customization.getChildren();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
                this.fConfigurationEntries.add(new CachableConfiguration(child));
                ++n2;
            }
        }
        List<IConfiguration> children = definition.getChildren();
        for (IConfiguration child : children) {
            this.fConfigurationEntries.add(child);
        }
    }

    protected List<IConfiguration> internalGetChildren() {
        return this.fConfigurationEntries;
    }

    @Override
    public String getElementName() {
        return this.fElementName;
    }

    @Override
    public String getString(String name) {
        return this.fAttributes.get(name);
    }

    @Override
    public List<String> getAttributeNames() {
        return new ArrayList<String>(this.fAttributes.keySet());
    }

    @Override
    public boolean isProcessAttachment() {
        String childConfigurationElementName;
        return this.fConfigurationEntries.size() == 1 && (childConfigurationElementName = this.fConfigurationEntries.get(0).getElementName()) != null && childConfigurationElementName.equals("script");
    }
}

