/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.Messages;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class DurationFormat
extends Format {
    private static final String BUNDLE_BASE_NAME = "com.ibm.team.workitem.common.internal.DurationFormat";
    private static final String[] FORMAT_DELIMITERS = new String[]{" ", ","};
    private static final String FORMAT_UNIT_MILLIS = "msUnit";
    private static final String FORMAT_UNIT_SECONDS = "secUnit";
    private static final String FORMAT_UNIT_MINUTES = "minUnit";
    private static final String FORMAT_UNIT_HOURS = "hrUnit";
    private static final String FORMAT_UNIT_DAYS = "dayUnit";
    private static final String FORMAT_UNIT_WEEKS = "weekUnit";
    private static final String[] UNIT_FORMAT_KEYS = new String[]{"msUnit", "secUnit", "minUnit", "hrUnit", "dayUnit", "weekUnit"};
    private static final String FORMAT_DAYS = "dayFormat";
    private static final String FORMAT_HOURS = "hrFormat";
    private static final String FORMAT_MILLIS = "msFormat";
    private static final String FORMAT_MINUTES = "minFormat";
    private static final String FORMAT_SECONDS = "secFormat";
    private static final String FORMAT_WEEKS = "weekFormat";
    private static final String[] FORMAT_KEYS = new String[]{"msFormat", "secFormat", "minFormat", "hrFormat", "dayFormat", "weekFormat"};
    private static final String FORMAT_SINGLE_UNIT_MILLIS = "singleUnitMsFormat";
    private static final String FORMAT_SINGLE_UNIT_SECONDS = "singleUnitSecFormat";
    private static final String FORMAT_SINGLE_UNIT_MINUTES = "singleUnitMinFormat";
    private static final String FORMAT_SINGLE_UNIT_HOURS = "singleUnitHrFormat";
    private static final String FORMAT_SINGLE_UNIT_DAYS = "singleUnitDayFormat";
    private static final String FORMAT_SINGLE_UNIT_WEEKS = "singleUnitWeekFormat";
    private static final String[] SINGLE_UNIT_FORMAT_KEYS = new String[]{"singleUnitMsFormat", "singleUnitSecFormat", "singleUnitMinFormat", "singleUnitHrFormat", "singleUnitDayFormat", "singleUnitWeekFormat"};
    private static final long SECOND_MILLIS = 1000L;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long HOUR_MILLIS = 3600000L;
    private static final long serialVersionUID = 1L;
    public static final int STYLE_FULL = 0;
    public static final int STYLE_LONG = 1;
    public static final int STYLE_MEDIUM = 2;
    public static final int STYLE_SHORT = 3;
    public static final int STYLE_OPTIMIZED = 4;
    public static final int STYLE_SINGLE_UNIT = 5;
    private static final int STYLE_TOTAL_COUNT = 6;
    private static final int STYLE_PSEUDO_COUNT = 2;
    public static final int STYLE_DEFAULT = 4;
    public static final int UNIT_MILLIS = "msUnit".hashCode();
    public static final int UNIT_MINUTES = "minUnit".hashCode();
    public static final int UNIT_SECONDS = "secUnit".hashCode();
    public static final int UNIT_HOURS = "hrUnit".hashCode();
    public static final int UNIT_DAYS = "dayUnit".hashCode();
    public static final int UNIT_WEEKS = "weekUnit".hashCode();
    private final Locale fLocale;
    private int fFormatStyle = 4;
    private Map<String, List<String>> fUnitFormatData = null;
    private Map<String, List<String>> fFormatData = null;
    private Map<String, String> fSingleUnitFormatData = null;
    private Map<String, String> fParseData = null;
    private int fDefaultUnit = UNIT_HOURS;
    private int fDaysPerWeek = 5;
    private long fMillisPerDay = 28800000L;
    private Units fUpperBoundOutputUnit = Units.Week;
    private String fSingleUnitNoScale = null;
    private String[] fFormatDelimiters = FORMAT_DELIMITERS;
    private String fUnspecifiedString = "";
    private String fInvalidString = "";

    @Deprecated
    public static synchronized DurationFormat getInstance() {
        return DurationFormat.getInstance(Locale.getDefault());
    }

    @Deprecated
    public static synchronized DurationFormat getInstance(int style) {
        return DurationFormat.getInstance(Locale.getDefault(), style);
    }

    @Deprecated
    public static synchronized DurationFormat getInstance(Locale locale) {
        Assert.isNotNull((Object)locale);
        return DurationFormat.getInstance(locale, 4);
    }

    @Deprecated
    public static synchronized DurationFormat getInstance(Locale locale, int style) {
        Assert.isNotNull((Object)locale);
        return new DurationFormat(locale, style);
    }

    public DurationFormat() {
        this(Locale.getDefault());
    }

    public DurationFormat(int style) {
        this(Locale.getDefault(), style);
    }

    public DurationFormat(Locale locale) {
        this(locale, 4);
    }

    public DurationFormat(Locale locale, int style) {
        Assert.isNotNull((Object)locale);
        Assert.isLegal((style >= 0 && style < 6 ? 1 : 0) != 0, (String)Messages.getString("DurationFormat.INVALID_FORMAT"));
        this.fLocale = locale;
        this.fFormatStyle = style;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public final synchronized int getFormatStyle() {
        return this.fFormatStyle;
    }

    public final synchronized String format(Duration duration) {
        return this.format(duration, new StringBuffer()).toString();
    }

    public final synchronized StringBuffer format(Duration duration, StringBuffer buffer) {
        return this.format(duration, buffer, NullFieldPosition.INSTANCE);
    }

    @Override
    public final synchronized StringBuffer format(Object object, StringBuffer buffer, FieldPosition position) {
        long value;
        if (!(object instanceof Duration)) {
            throw new IllegalArgumentException(Messages.getString("DurationFormat.ARGUMENT_NOT_A_DURATION"));
        }
        Duration duration = (Duration)object;
        if (!duration.isSpecified()) {
            buffer.append(this.fUnspecifiedString);
            return buffer;
        }
        if (!duration.isValid()) {
            buffer.append(this.fInvalidString);
            return buffer;
        }
        this.loadFormatData();
        long millis = value = duration.longValue();
        int ordinal = this.fUpperBoundOutputUnit.ordinal();
        long weeks = ordinal <= Units.Week.ordinal() ? millis / this.getWeekMillis() : 0L;
        long days = ordinal <= Units.Day.ordinal() ? (millis -= weeks * this.getWeekMillis()) / this.getDayMillis() : 0L;
        long hours = ordinal <= Units.Hours.ordinal() ? (millis -= days * this.getDayMillis()) / 3600000L : 0L;
        long minutes = ordinal <= Units.Minutes.ordinal() ? (millis -= hours * 3600000L) / 60000L : 0L;
        long seconds = ordinal <= Units.Seconds.ordinal() ? (millis -= minutes * 60000L) / 1000L : 0L;
        millis -= seconds * 1000L;
        if (this.getFormatStyle() == 5) {
            String unit = FORMAT_SINGLE_UNIT_DAYS;
            long scale = -1L;
            if (weeks > 0L) {
                unit = FORMAT_SINGLE_UNIT_WEEKS;
                scale = this.getWeekMillis();
            } else if (days > 0L) {
                unit = FORMAT_SINGLE_UNIT_DAYS;
                scale = this.getDayMillis();
            } else if (hours > 0L) {
                unit = FORMAT_SINGLE_UNIT_HOURS;
                scale = 3600000L;
            } else if (minutes > 0L) {
                unit = FORMAT_SINGLE_UNIT_MINUTES;
                scale = 60000L;
            } else if (seconds > 0L) {
                unit = FORMAT_SINGLE_UNIT_SECONDS;
                scale = 1000L;
            } else if (millis > 0L) {
                unit = FORMAT_SINGLE_UNIT_MILLIS;
                scale = 1L;
            }
            if (scale > 0L) {
                double units = (double)value / (double)scale;
                buffer.append(MessageFormat.format((String)this.fSingleUnitFormatData.get(unit), (Object[])new Object[]{units}));
            } else {
                buffer.append(MessageFormat.format((String)this.fSingleUnitNoScale, (Object[])new Object[]{0}));
            }
        } else if (this.fFormatStyle == 4) {
            int style = 0;
            if (weeks > 0L) {
                ++style;
            }
            if (days > 0L) {
                ++style;
            }
            if (hours > 0L) {
                ++style;
            }
            if (minutes > 0L) {
                ++style;
            }
            if (seconds > 0L) {
                ++style;
            }
            if (millis > 0L) {
                ++style;
            }
            if ((style -= (style - 0) / 2) > 3) {
                style = 3;
            }
            this.format(buffer, weeks, days, hours, minutes, seconds, millis, style);
        } else {
            this.format(buffer, weeks, days, hours, minutes, seconds, millis, this.fFormatStyle);
        }
        return buffer;
    }

    public final synchronized int getDaysPerWeek() {
        return this.fDaysPerWeek;
    }

    public final synchronized String[] getFormatDelimiters() {
        String[] temp = new String[this.fFormatDelimiters.length];
        System.arraycopy(this.fFormatDelimiters, 0, temp, 0, this.fFormatDelimiters.length);
        return temp;
    }

    public final synchronized long getMillisPerDay() {
        return this.fMillisPerDay;
    }

    public final synchronized String getInvalidString() {
        return this.fInvalidString;
    }

    public final synchronized String getUnitString(int unit, double amount) {
        return this.getUnitString(unit, amount, this.fFormatStyle == 4 ? 3 : this.fFormatStyle);
    }

    public final synchronized String getUnitString(int unit, double amount, int style) {
        this.loadFormatData();
        String pattern = this.getUnitFormatPattern(unit, style);
        if (pattern != null) {
            ChoiceFormat format = new ChoiceFormat(pattern);
            return format.format(amount);
        }
        return null;
    }

    public final synchronized String getUnspecifiedString() {
        return this.fUnspecifiedString;
    }

    public synchronized int getDefaultUnit() {
        return this.fDefaultUnit;
    }

    public synchronized String getValidationExpression() {
        this.loadParseData();
        StringBuilder builder = new StringBuilder(512);
        builder.append("([0-9]+((\\.|\\,)[0-9]+)?)");
        builder.append("|((");
        builder.append("([0-9]+((\\.|\\,)[0-9]+)?)");
        builder.append('|');
        builder.append("(\\.[0-9]+)");
        builder.append(")\\s*");
        this.createTokenExpression(builder);
        builder.append("\\s*)+");
        return builder.toString();
    }

    public final synchronized Duration parse(String source) throws ParseException {
        ParsePosition position = new ParsePosition(0);
        Duration result = this.parse(source, position);
        int index = position.getErrorIndex();
        if (result == null || index >= 0) {
            throw new ParseException(NLS.bind((String)Messages.getString("DurationFormat.NOT_VALID"), (Object[])new Object[]{source, this.getUnitString(UNIT_HOURS, 1.0, 3)}), index);
        }
        return result;
    }

    public final synchronized Duration parse(String source, ParsePosition position) {
        return (Duration)this.parseObject(source, position);
    }

    @Override
    public final synchronized Object parseObject(String source, ParsePosition position) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)position);
        BreakIterator iterator = BreakIterator.getWordInstance((Locale)this.getLocale());
        NumberFormat numberFormat = NumberFormat.getInstance((Locale)this.getLocale());
        numberFormat.setParseStrict(true);
        String input = source;
        int index = position.getIndex();
        if (index != 0 && index < input.length()) {
            input = input.substring(index);
        }
        iterator.setText(input);
        this.loadParseData();
        ArrayList<ParseToken> tokens = new ArrayList<ParseToken>(FORMAT_KEYS.length * 3);
        int start = iterator.first();
        String unit = "";
        int unitStart = -1;
        boolean lastWordWasNumber = false;
        boolean isWordNumber = false;
        int end = iterator.next();
        while (end != -1) {
            isWordNumber = false;
            String word = input.substring(start, end);
            String trimmed = word.trim();
            if (trimmed.length() == 0) {
                if (unit.length() > 0) {
                    unit = unit.concat("" + word.charAt(0));
                }
            } else if (this.isDelimiter(trimmed)) {
                if (unit.length() > 0) {
                    tokens.add(new UnitParseToken(unit.trim().toLowerCase(this.getLocale()), unitStart));
                    unit = "";
                    unitStart = -1;
                }
            } else {
                ParsePosition numberParsePosition = new ParsePosition(0);
                Number number = numberFormat.parse(trimmed, numberParsePosition);
                if (numberParsePosition.getIndex() == 0 || number == null) {
                    unit = unit.concat(trimmed);
                    if (unitStart == -1) {
                        unitStart = start;
                    }
                } else {
                    if (unit.length() > 0) {
                        tokens.add(new UnitParseToken(unit.trim().toLowerCase(this.getLocale()), unitStart));
                        unit = "";
                        unitStart = -1;
                    }
                    if (lastWordWasNumber && !tokens.isEmpty() && tokens.get(tokens.size() - 1) instanceof NumberParseToken) {
                        NumberParseToken token = (NumberParseToken)tokens.remove(tokens.size() - 1);
                        tokens.add(new NumberParseToken(String.valueOf(token.token) + trimmed, token.index, token.number * 10.0 + number.doubleValue()));
                    } else {
                        tokens.add(new NumberParseToken(trimmed, start, number.doubleValue()));
                    }
                    if (numberParsePosition.getIndex() < trimmed.length()) {
                        unit = unit.concat(trimmed.substring(numberParsePosition.getIndex()));
                        if (unitStart == -1) {
                            unitStart = start + numberParsePosition.getIndex();
                        }
                    } else {
                        isWordNumber = true;
                    }
                }
            }
            start = end;
            end = iterator.next();
            lastWordWasNumber = isWordNumber;
        }
        if (unit.length() > 0 && unitStart >= 0) {
            tokens.add(new UnitParseToken(unit.trim().toLowerCase(this.getLocale()), unitStart));
        }
        if (tokens.size() == 1) {
            double millis = 0.0;
            ParseToken token = (ParseToken)tokens.iterator().next();
            if (token instanceof UnitParseToken) {
                position.setErrorIndex(0);
                position.setIndex(0);
                return null;
            }
            if (position.getErrorIndex() < 0) {
                double doubleNumber = ((NumberParseToken)token).number;
                if (doubleNumber >= 0.0 && doubleNumber < 9.223372036854776E18) {
                    if (this.fDefaultUnit == UNIT_MILLIS) {
                        millis += doubleNumber;
                    } else if (this.fDefaultUnit == UNIT_SECONDS) {
                        millis += doubleNumber * 1000.0;
                    } else if (this.fDefaultUnit == UNIT_MINUTES) {
                        millis += doubleNumber * 60000.0;
                    } else if (this.fDefaultUnit == UNIT_HOURS) {
                        millis += doubleNumber * 3600000.0;
                    } else if (this.fDefaultUnit == UNIT_DAYS) {
                        millis += doubleNumber * (double)this.getDayMillis();
                    } else if (this.fDefaultUnit == UNIT_WEEKS) {
                        millis += doubleNumber * (double)this.getWeekMillis();
                    }
                    position.setIndex(source.length());
                    return new Duration((long)millis);
                }
                position.setIndex(0);
                position.setErrorIndex(0);
            }
        } else if (tokens.size() % 2 == 0) {
            double millis = 0.0;
            Iterator iter = tokens.iterator();
            while (iter.hasNext()) {
                ParseToken token = (ParseToken)iter.next();
                if (!(token instanceof NumberParseToken)) {
                    position.setErrorIndex(token.index);
                    position.setIndex(token.index);
                    return null;
                }
                double doubleNumber = ((NumberParseToken)token).number;
                if (!iter.hasNext()) continue;
                token = (ParseToken)iter.next();
                String data = this.fParseData.get(token.token);
                if (data != null) {
                    int code = data.hashCode();
                    if (code == UNIT_MILLIS) {
                        millis += doubleNumber;
                        continue;
                    }
                    if (code == UNIT_SECONDS) {
                        millis += doubleNumber * 1000.0;
                        continue;
                    }
                    if (code == UNIT_MINUTES) {
                        millis += doubleNumber * 60000.0;
                        continue;
                    }
                    if (code == UNIT_HOURS) {
                        millis += doubleNumber * 3600000.0;
                        continue;
                    }
                    if (code == UNIT_DAYS) {
                        millis += doubleNumber * (double)this.getDayMillis();
                        continue;
                    }
                    if (code == UNIT_WEEKS) {
                        millis += doubleNumber * (double)this.getWeekMillis();
                        continue;
                    }
                    position.setErrorIndex(token.index);
                    position.setIndex(token.index);
                    return null;
                }
                position.setErrorIndex(token.index);
                position.setIndex(token.index);
                return null;
            }
            if (position.getErrorIndex() < 0) {
                if (millis < 9.223372036854776E18) {
                    position.setIndex(source.length());
                    return new Duration((long)millis);
                }
                position.setIndex(source.length());
                position.setErrorIndex(0);
            }
        } else {
            position.setIndex(source.length());
            position.setErrorIndex(0);
        }
        return null;
    }

    public synchronized void setDaysPerWeek(int days) {
        Assert.isLegal((days > 0 && days <= 7 ? 1 : 0) != 0, (String)Messages.getString("DurationFormat.INVALID_DAYS"));
        this.fDaysPerWeek = days;
    }

    public synchronized void setFormatDelimiters(String[] delimiters) {
        Assert.isNotNull((Object)delimiters);
        ArrayList<String> collection = new ArrayList<String>(delimiters.length);
        String[] stringArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (delimiter != null && !"".equals(delimiters)) {
                collection.add(delimiter);
            }
            ++n2;
        }
        Assert.isLegal((!collection.isEmpty() ? 1 : 0) != 0, (String)Messages.getString("DurationFormat.DELIMITERS_NOT_LEGAL"));
        this.fFormatDelimiters = collection.toArray(new String[collection.size()]);
    }

    public synchronized void setFormatStyle(int style) {
        Assert.isLegal((style >= 0 && style < 6 ? 1 : 0) != 0, (String)Messages.getString("DurationFormat.INVALID_STYLE"));
        this.fFormatStyle = style;
    }

    public synchronized void setMillisPerDay(long millis) {
        Assert.isLegal((millis > 0L && millis <= 86400000L ? 1 : 0) != 0, (String)Messages.getString("DurationFormat.INAVLID_HOURS"));
        this.fMillisPerDay = millis;
    }

    public synchronized void setInvalidString(String invalid) {
        Assert.isNotNull((Object)invalid);
        this.fInvalidString = invalid;
    }

    public synchronized void setDefaultUnit(int unit) {
        Assert.isLegal((unit == UNIT_WEEKS || unit == UNIT_DAYS || unit == UNIT_HOURS || unit == UNIT_MINUTES || unit == UNIT_SECONDS || unit == UNIT_MILLIS ? 1 : 0) != 0, (String)"Unit must be one of the UNIT_XXX constants");
        this.fDefaultUnit = unit;
    }

    public synchronized void setUpperBoundOutputUnit(Units unit) {
        this.fUpperBoundOutputUnit = unit;
    }

    public synchronized void setUnspecifiedString(String unspecified) {
        Assert.isNotNull((Object)unspecified);
        this.fUnspecifiedString = unspecified;
    }

    private synchronized void loadFormatData() throws IllegalArgumentException {
        if (this.fFormatData == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_BASE_NAME, this.getLocale());
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(BUNDLE_BASE_NAME, Locale.US);
            }
            if (bundle != null) {
                String values;
                String key;
                HashMap<String, List<String>> result = new HashMap<String, List<String>>(FORMAT_KEYS.length);
                String[] stringArray = FORMAT_KEYS;
                int n = FORMAT_KEYS.length;
                int n2 = 0;
                while (n2 < n) {
                    key = stringArray[n2];
                    values = bundle.getString(key);
                    if (values == null || values.length() <= 0) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.getString("DurationFormat.KEY_MISSING"), (Object[])new Object[]{key}));
                    }
                    result.put(key, this.parseFormatData(key, values));
                    ++n2;
                }
                this.fFormatData = result;
                this.fUnitFormatData = new HashMap<String, List<String>>(UNIT_FORMAT_KEYS.length);
                stringArray = UNIT_FORMAT_KEYS;
                n = UNIT_FORMAT_KEYS.length;
                n2 = 0;
                while (n2 < n) {
                    key = stringArray[n2];
                    values = bundle.getString(key);
                    if (values == null || values.length() <= 0) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.getString("DurationFormat.KEY_MISSING"), (Object[])new Object[]{key}));
                    }
                    this.fUnitFormatData.put(key, this.parseFormatData(key, values));
                    ++n2;
                }
                this.fSingleUnitFormatData = new HashMap<String, String>(SINGLE_UNIT_FORMAT_KEYS.length);
                stringArray = SINGLE_UNIT_FORMAT_KEYS;
                n = SINGLE_UNIT_FORMAT_KEYS.length;
                n2 = 0;
                while (n2 < n) {
                    key = stringArray[n2];
                    this.fSingleUnitFormatData.put(key, bundle.getString(key));
                    ++n2;
                }
                this.fSingleUnitNoScale = bundle.getString("singleUnitNoScale");
            }
        }
    }

    private synchronized Map<String, String> loadParseData() throws IllegalArgumentException {
        if (this.fParseData == null) {
            this.loadFormatData();
            Map<String, List<String>> format = this.fUnitFormatData;
            ArrayList<ParseData> collection = new ArrayList<ParseData>(format.size() * 16);
            for (Map.Entry<String, List<String>> entry : format.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    this.computeParseMap(collection, key, value);
                }
            }
            Collections.sort(collection, new Comparator<ParseData>(){

                @Override
                public int compare(ParseData first, ParseData second) {
                    return second.token.length() - first.token.length();
                }
            });
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(collection.size());
            for (ParseData data : collection) {
                result.put(data.token, data.key);
            }
            this.fParseData = result;
        }
        return this.fParseData;
    }

    private void format(StringBuffer buffer, long weeks, long days, long hours, long minutes, long seconds, long millis, int style) {
        String delimiter = "";
        if (weeks == 0L && days == 0L && hours == 0L && minutes == 0L && seconds == 0L && millis == 0L) {
            this.format(0L, this.getFormatPattern(FORMAT_HOURS, style), buffer, delimiter, style);
            return;
        }
        if (weeks > 0L) {
            this.format(weeks, this.getFormatPattern(FORMAT_WEEKS, style), buffer, delimiter, style);
            delimiter = this.fFormatDelimiters[0];
        }
        if (days > 0L) {
            this.format(days, this.getFormatPattern(FORMAT_DAYS, style), buffer, delimiter, style);
            delimiter = this.fFormatDelimiters[0];
        }
        if (hours > 0L) {
            this.format(hours, this.getFormatPattern(FORMAT_HOURS, style), buffer, delimiter, style);
            delimiter = this.fFormatDelimiters[0];
        }
        if (minutes > 0L) {
            this.format(minutes, this.getFormatPattern(FORMAT_MINUTES, style), buffer, delimiter, style);
            delimiter = this.fFormatDelimiters[0];
        }
        if (seconds > 0L) {
            this.format(seconds, this.getFormatPattern(FORMAT_SECONDS, style), buffer, delimiter, style);
            delimiter = this.fFormatDelimiters[0];
        }
        if (millis > 0L) {
            this.format(millis, this.getFormatPattern(FORMAT_MILLIS, style), buffer, delimiter, style);
        }
    }

    private long getDayMillis() {
        return this.getMillisPerDay();
    }

    private String getFormatPattern(String format, int style) {
        return this.fFormatData.get(format).get(style);
    }

    private String getUnitFormatPattern(int unit, int style) {
        for (Map.Entry<String, List<String>> entry : this.fUnitFormatData.entrySet()) {
            if (unit != entry.getKey().hashCode()) continue;
            return entry.getValue().get(style);
        }
        return null;
    }

    private void createTokenExpression(StringBuilder builder) {
        builder.append('(');
        boolean first = true;
        for (String token : this.fParseData.keySet()) {
            if (!first) {
                builder.append('|');
            }
            first = false;
            builder.append(token);
        }
        builder.append(')');
    }

    private long getWeekMillis() {
        return this.getDayMillis() * (long)this.fDaysPerWeek;
    }

    private void computeParseMap(Collection<ParseData> result, String key, String values) {
        Object[] formats;
        ChoiceFormat format = new ChoiceFormat(values);
        Object[] objectArray = formats = format.getFormats();
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            Object unit = objectArray[n2];
            if (unit instanceof String) {
                result.add(new ParseData(((String)unit).toLowerCase(this.getLocale()), key));
            }
            ++n2;
        }
    }

    private boolean isDelimiter(String token) {
        String[] stringArray = this.fFormatDelimiters;
        int n = this.fFormatDelimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (delimiter.equalsIgnoreCase(token)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<String> parseFormatData(String key, String values) {
        StringTokenizer tokenizer = new StringTokenizer(values, "/");
        int tokens = tokenizer.countTokens();
        if (tokens != 4) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("DurationFormat.WRONG_NUMBER_OF_STYLES"), (Object[])new Object[]{key}));
        }
        ArrayList<String> result = new ArrayList<String>(tokens);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    private void format(long amount, String pattern, StringBuffer buffer, String delimiter, int style) {
        ChoiceFormat format = new ChoiceFormat(pattern);
        buffer.append(delimiter);
        String choice = format.format(amount);
        if (style == 3) {
            char[] characters;
            StringBuilder builder = new StringBuilder(choice.length());
            char[] cArray = characters = choice.toCharArray();
            int n = characters.length;
            int n2 = 0;
            while (n2 < n) {
                char character = cArray[n2];
                if (!Character.isWhitespace(character)) {
                    builder.append(character);
                }
                ++n2;
            }
            choice = builder.toString();
        }
        buffer.append(MessageFormat.format((String)choice, (Object[])new Object[]{amount}));
    }

    private static class NullFieldPosition
    extends FieldPosition {
        public static NullFieldPosition INSTANCE = new NullFieldPosition();

        public NullFieldPosition() {
            super(0);
        }
    }

    private static class NumberParseToken
    extends ParseToken {
        final double number;

        NumberParseToken(String token, int index, double number) {
            super(token, index);
            this.number = number;
        }
    }

    private static class ParseData {
        final String key;
        final String token;

        ParseData(String token, String key) {
            this.token = token;
            this.key = key;
        }
    }

    private static abstract class ParseToken {
        final String token;
        final int index;

        ParseToken(String token, int index) {
            this.token = token;
            this.index = index;
        }
    }

    private static class UnitParseToken
    extends ParseToken {
        UnitParseToken(String token, int index) {
            super(token, index);
        }
    }

    public static enum Units {
        Week,
        Day,
        Hours,
        Minutes,
        Seconds,
        Millis;

    }
}

