/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.EnvironmentReservation;
import com.urbancode.release.rest.models.RecurringDeployment;
import com.urbancode.release.rest.models.internal.ApplicationEnvironment;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;

public class ReleaseEnvironment
extends ClientDescribed<ReleaseEnvironment> {
    public static final ReleaseEnvironment DEV_1 = (ReleaseEnvironment)new ReleaseEnvironment().id("00000000-0000-0000-0000-000000000016");
    public static final ReleaseEnvironment CERT_1 = (ReleaseEnvironment)new ReleaseEnvironment().id("00000000-0000-0000-0000-000000000017");
    public static final ReleaseEnvironment QA_1 = (ReleaseEnvironment)new ReleaseEnvironment().id("00000000-0000-0000-0000-000000000018");
    public static final ReleaseEnvironment PT_1 = (ReleaseEnvironment)new ReleaseEnvironment().id("00000000-0000-0000-0000-000000000019");
    public static final ReleaseEnvironment PROD_1 = (ReleaseEnvironment)new ReleaseEnvironment().id("00000000-0000-0000-0000-000000000020");
    public static final ReleaseEnvironment[] ALL = new ReleaseEnvironment[]{DEV_1, CERT_1, QA_1, PT_1, PROD_1};
    @JsonReadOnly
    public ApplicationEnvironment[] applicationTargets;
    @JsonReadOnly
    public EnvironmentReservation[] reservations;
    @JsonReadOnly
    public RecurringDeployment[] rules;
    @JsonReadOnly
    public ScheduledDeployment[] scheduledDeployments;
    @JsonReadOnly
    public Phase[] phases;

    public ReleaseEnvironment() {
        this.path = "/environment/";
    }

    public ApplicationEnvironment getEnvironmentForApplication(Application app) {
        for (ApplicationEnvironment target : this.applicationTargets) {
            if (!target.application.equals(app)) continue;
            return target;
        }
        return null;
    }

    public void addApplicationEnvironment(ApplicationEnvironment appEnvironment) {
        RestAssured.given().post(this.path(this.id) + "/applicationTargets/" + appEnvironment.id, new Object[0]);
    }

    public ReleaseEnvironment[] getAllFilterable() {
        log.debug("getAllWithPath()");
        return (ReleaseEnvironment[])this.getAllWithPath("/releaseEnvironments/").as(this.arrayClass(), ObjectMapperType.GSON);
    }
}

